/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransparencyGroup;
import com.sun.pdfview.PDFRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import jpen.PButtonEvent;
import jpen.PKind;
import jpen.PKindEvent;
import jpen.PLevel;
import jpen.PLevelEvent;
import jpen.PScrollEvent;
import jpen.PenManager;
import jpen.event.PenListener;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcShape;
import org.alchemy.core.Alchemy;

public class AlcCanvas
extends JPanel
implements AlcConstants,
MouseListener,
MouseMotionListener,
PenListener,
Printable {
    private Color color;
    private int alpha = 255;
    private int style = 1;
    private float lineWidth = 1.0f;
    private Color bgColor;
    private int bgAlpha = 255;
    private boolean backgroundActive = false;
    private boolean redraw = true;
    boolean smoothing;
    private boolean canvasChanged = false;
    private boolean drawUnder = false;
    private boolean events = true;
    private boolean createEvents = true;
    private boolean affectEvents = true;
    private PenManager pm;
    private boolean penDown = false;
    private int penType = 3;
    private float penPressure = 0.0f;
    private Point2D.Float penTilt = new Point2D.Float();
    private Point2D.Float penLocation = new Point2D.Float();
    private boolean penLocationChanged = true;
    public ArrayList<AlcShape> shapes;
    public ArrayList<AlcShape> createShapes;
    public ArrayList<AlcShape> affectShapes;
    public ArrayList<AlcShape> guideShapes;
    ArrayList[] fullShapeList = new ArrayList[3];
    ArrayList[] activeShapeList = new ArrayList[2];
    private Image canvasImage;
    private Image image;
    private boolean imageDisplay = false;
    private Point imageLocation = new Point(0, 0);
    private Image transparentImage;
    private boolean recordIndicator = false;
    private boolean guides = true;
    private GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private GraphicsConfiguration gc = this.ge.getDefaultScreenDevice().getDefaultConfiguration();
    VectorCanvas vectorCanvas;
    Cursor oldCursor;
    private boolean autoToggleToolBar;

    AlcCanvas() {
        this.smoothing = Alchemy.preferences.smoothing;
        this.bgColor = new Color(Alchemy.preferences.bgColor);
        this.color = new Color(Alchemy.preferences.color);
        this.autoToggleToolBar = !Alchemy.preferences.paletteAttached;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.shapes = new ArrayList(100);
        this.shapes.ensureCapacity(100);
        this.createShapes = new ArrayList(25);
        this.createShapes.ensureCapacity(25);
        this.affectShapes = new ArrayList(25);
        this.affectShapes.ensureCapacity(25);
        this.guideShapes = new ArrayList(25);
        this.guideShapes.ensureCapacity(25);
        this.fullShapeList[0] = this.shapes;
        this.fullShapeList[1] = this.createShapes;
        this.fullShapeList[2] = this.affectShapes;
        this.activeShapeList[0] = this.createShapes;
        this.activeShapeList[1] = this.affectShapes;
        this.vectorCanvas = new VectorCanvas();
        this.pm = new PenManager(this);
        this.pm.pen.addListener(this);
        this.setCursor(CURSOR_CROSS);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle visibleRect = this.getVisibleRect();
        int w = visibleRect.width;
        int h = visibleRect.height;
        if (Alchemy.window.isTransparent() && this.transparentImage != null) {
            g2.drawImage(this.transparentImage, 0, 0, null);
            if (this.imageDisplay && this.image != null) {
                g2.drawImage(this.image, this.imageLocation.x, this.imageLocation.y, null);
            }
        } else {
            if (this.imageDisplay && this.image != null) {
                g2.drawImage(this.image, this.imageLocation.x, this.imageLocation.y, null);
            }
            g2.setColor(new Color(this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue()));
            g2.fillRect(0, 0, w, h);
        }
        if (this.smoothing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.canvasImage != null && !this.drawUnder) {
            g2.drawImage(this.canvasImage, 0, 0, null);
        }
        if (this.redraw) {
            for (int j = 0; j < this.activeShapeList.length; ++j) {
                for (int i = 0; i < this.activeShapeList[j].size(); ++i) {
                    AlcShape currentShape = (AlcShape)this.activeShapeList[j].get(i);
                    if (currentShape.style == 1) {
                        g2.setStroke(new BasicStroke(currentShape.lineWidth, 1, 2));
                        g2.setPaint(currentShape.getPaint());
                        g2.draw(currentShape.path);
                        continue;
                    }
                    g2.setPaint(currentShape.getPaint());
                    g2.fill(currentShape.path);
                }
            }
        }
        if (this.drawUnder) {
            g2.drawImage(this.canvasImage, 0, 0, null);
        }
        if (this.recordIndicator) {
            Ellipse2D.Double recordCircle = new Ellipse2D.Double(5.0, h - 12, 7.0, 7.0);
            g2.setColor(Color.RED);
            g2.fill(recordCircle);
        }
        if (this.guides) {
            for (int i = 0; i < this.guideShapes.size(); ++i) {
                AlcShape currentShape = this.guideShapes.get(i);
                if (currentShape.style == 1) {
                    g2.setStroke(new BasicStroke(currentShape.lineWidth, 1, 2));
                    g2.setColor(currentShape.color);
                    g2.draw(currentShape.path);
                    continue;
                }
                g2.setColor(currentShape.color);
                g2.fill(currentShape.path);
            }
        }
        g2.dispose();
    }

    public void redraw() {
        this.redraw(false);
    }

    public void redraw(boolean fullRedraw) {
        this.applyAffects();
        if (this.redraw) {
            if (fullRedraw) {
                this.canvasImage = Alchemy.window.isTransparent() ? this.renderCanvas(true, true) : this.renderCanvas(true);
            }
            this.repaint();
            this.canvasChanged = true;
        }
    }

    public void forceRedraw() {
        this.setRedraw(true);
        this.redraw(true);
        this.setRedraw(false);
    }

    public void setRedraw(boolean redraw) {
        this.redraw = redraw;
    }

    public boolean isRedraw() {
        return this.redraw;
    }

    void setDrawUnder(boolean drawUnder) {
        this.drawUnder = drawUnder;
        this.updateCanvasImage(true);
    }

    boolean getDrawUnder() {
        return this.drawUnder;
    }

    void updateCanvasImage(boolean transparency) {
        this.canvasImage = this.renderCanvas(true, true);
    }

    void setSmoothing(boolean smoothing) {
        this.smoothing = smoothing;
        if (this.redraw) {
            this.redraw(true);
        } else {
            this.canvasImage = this.renderCanvas(true);
        }
    }

    boolean isSmoothing() {
        return this.smoothing;
    }

    boolean canvasChanged() {
        return this.canvasChanged;
    }

    void resetCanvasChanged() {
        this.canvasChanged = false;
    }

    public void setEvents(boolean events) {
        this.events = events;
    }

    public void setCreateEvents(boolean createEvents) {
        this.createEvents = createEvents;
    }

    public void setAffectEvents(boolean affectEvents) {
        this.affectEvents = affectEvents;
    }

    public boolean isPenDown() {
        return this.penDown;
    }

    public boolean isMouseDown() {
        return this.penDown;
    }

    public float getPenPressure() {
        return this.penPressure;
    }

    public Point2D.Float getPenTilt() {
        return this.penTilt;
    }

    public Point2D.Float getPenLocation() {
        return new Point2D.Float(this.penLocation.x, this.penLocation.y);
    }

    private void setPenLocation(MouseEvent event) {
        if (this.penType == 3) {
            this.penLocation.x = event.getX();
            this.penLocation.y = event.getY();
        }
    }

    private void setPenLocation(PLevelEvent ev) {
        block4: for (PLevel level : ev.levels) {
            PLevel.Type levelType = (PLevel.Type)((Object)level.getType());
            switch (levelType) {
                case X: {
                    this.penLocation.x = ((Float)level.value).floatValue();
                    continue block4;
                }
                case Y: {
                    this.penLocation.y = ((Float)level.value).floatValue();
                }
            }
        }
    }

    public boolean isPenLocationChanged() {
        return this.penLocationChanged;
    }

    public int getPenType() {
        return this.penType;
    }

    private void setPenType() {
        PKind.Type kindType = (PKind.Type)((Object)this.pm.pen.getKind().getType());
        switch (kindType) {
            case CUSTOM: {
                this.penType = 0;
                break;
            }
            case STYLUS: {
                if (this.backgroundActive) {
                    this.setBackgroundColorActive(false);
                    Alchemy.toolBar.refreshColorButton();
                }
                this.penType = 1;
                break;
            }
            case ERASER: {
                if (!this.backgroundActive) {
                    this.setBackgroundColorActive(true);
                    Alchemy.toolBar.refreshColorButton();
                }
                this.penType = 2;
                break;
            }
            case CURSOR: {
                this.penType = 3;
            }
        }
    }

    public void resizeCanvas(Dimension windowSize) {
        int x = 0;
        if (Alchemy.preferences.simpleToolBar) {
            x = Alchemy.toolBar.toolBarWidth;
            windowSize.width -= Alchemy.toolBar.toolBarWidth;
        }
        this.setBounds(x, 0, windowSize.width, windowSize.height);
    }

    public void clear() {
        this.shapes.clear();
        this.createShapes.clear();
        this.affectShapes.clear();
        this.guideShapes.clear();
        this.canvasImage = null;
        if (this.imageDisplay && this.image != null) {
            this.canvasImage = this.renderCanvas(true);
        }
        if (this.redraw) {
            if (Alchemy.session.pdfReadPage == null) {
                this.redraw(false);
            } else {
                this.redraw(true);
            }
        } else {
            this.forceRedraw();
        }
        Alchemy.plugins.creates[Alchemy.plugins.currentCreate].cleared();
        if (Alchemy.plugins.hasCurrentAffects()) {
            for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                if (!Alchemy.plugins.currentAffects[i]) continue;
                Alchemy.plugins.affects[i].cleared();
            }
        }
        System.gc();
    }

    public void setTempCursor(Cursor cursor) {
        if (this.oldCursor == null) {
            this.oldCursor = this.getCursor();
            this.setCursor(cursor);
        }
    }

    public void restoreCursor() {
        if (this.oldCursor != null) {
            this.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    private void applyAffects() {
        if (Alchemy.plugins.hasCurrentAffects()) {
            for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                if (!Alchemy.plugins.currentAffects[i]) continue;
                Alchemy.plugins.affects[i].affect();
            }
        }
    }

    public void commitShapes() {
        if (this.drawUnder) {
            this.shapes.addAll(0, this.createShapes);
            this.shapes.addAll(0, this.affectShapes);
            this.createShapes.clear();
            this.affectShapes.clear();
            this.canvasImage = this.renderCanvas(true, true);
        } else {
            this.canvasImage = Alchemy.window.isTransparent() ? this.renderCanvas(true, true) : this.renderCanvas(false);
            this.shapes.addAll(this.createShapes);
            this.shapes.addAll(this.affectShapes);
            this.createShapes.clear();
            this.affectShapes.clear();
        }
        if (Alchemy.plugins.currentCreate >= 0) {
            Alchemy.plugins.creates[Alchemy.plugins.currentCreate].commited();
        }
        if (Alchemy.plugins.hasCurrentAffects()) {
            for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                if (!Alchemy.plugins.currentAffects[i]) continue;
                Alchemy.plugins.affects[i].commited();
            }
        }
    }

    public boolean hasShapes() {
        return this.shapes.size() > 0;
    }

    public AlcShape getCurrentShape() {
        if (this.shapes.size() > 0) {
            return this.shapes.get(this.shapes.size() - 1);
        }
        return null;
    }

    public void setCurrentShape(AlcShape shape) {
        if (this.shapes.size() > 0) {
            this.shapes.set(this.shapes.size() - 1, shape);
        }
    }

    public void removeCurrentShape() {
        if (this.shapes.size() > 0) {
            this.shapes.remove(this.shapes.size() - 1);
        }
    }

    public boolean hasCreateShapes() {
        return this.createShapes.size() > 0;
    }

    public AlcShape getCurrentCreateShape() {
        if (this.createShapes.size() > 0) {
            return this.createShapes.get(this.createShapes.size() - 1);
        }
        return null;
    }

    public void setCurrentCreateShape(AlcShape shape) {
        if (this.createShapes.size() > 0) {
            this.createShapes.set(this.createShapes.size() - 1, shape);
        }
    }

    public void removeCurrentCreateShape() {
        if (this.createShapes.size() > 0) {
            this.createShapes.remove(this.createShapes.size() - 1);
        }
    }

    public void commitCreateShapes() {
        this.canvasImage = this.renderCanvas(false);
        for (int i = 0; i < this.createShapes.size(); ++i) {
            this.shapes.add(this.createShapes.get(i));
        }
        this.createShapes.clear();
    }

    public boolean hasAffectShapes() {
        return this.affectShapes.size() > 0;
    }

    public AlcShape getCurrentAffectShape() {
        if (this.affectShapes.size() > 0) {
            return this.affectShapes.get(this.affectShapes.size() - 1);
        }
        return null;
    }

    public void setCurrentAffectShape(AlcShape shape) {
        if (this.affectShapes.size() > 0) {
            this.affectShapes.set(this.affectShapes.size() - 1, shape);
        }
    }

    public void removeCurrentAffectShape() {
        if (this.affectShapes.size() > 0) {
            this.affectShapes.remove(this.affectShapes.size() - 1);
        }
    }

    public void commitAffectShapes() {
        this.canvasImage = this.renderCanvas(false);
        for (int i = 0; i < this.affectShapes.size(); ++i) {
            this.shapes.add(this.affectShapes.get(i));
        }
        this.affectShapes.clear();
    }

    public AlcShape getCurrentGuideShape() {
        if (this.guideShapes.size() > 0) {
            return this.guideShapes.get(this.guideShapes.size() - 1);
        }
        return null;
    }

    public void setCurrentGuideShape(AlcShape shape) {
        if (this.guideShapes.size() > 0) {
            this.guideShapes.set(this.guideShapes.size() - 1, shape);
        }
    }

    public void removeCurrentGuideShape() {
        if (this.guideShapes.size() > 0) {
            this.guideShapes.remove(this.guideShapes.size() - 1);
        }
    }

    public Color getColor() {
        if (this.backgroundActive) {
            return this.bgColor;
        }
        return this.color;
    }

    public void setColor(Color color) {
        try {
            if (this.backgroundActive) {
                this.bgColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.bgAlpha);
                this.redraw(true);
            } else {
                this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
            }
            if (Alchemy.preferences.paletteAttached || Alchemy.preferences.simpleToolBar) {
                Alchemy.toolBar.refreshColorButton();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public boolean isBackgroundColorActive() {
        return this.backgroundActive;
    }

    public void setBackgroundColorActive(boolean backgroundActive) {
        this.backgroundActive = backgroundActive;
        Alchemy.toolBar.refreshTransparencySlider();
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.bgAlpha);
        this.redraw(true);
    }

    public Color getForegroundColor() {
        return this.color;
    }

    public void setForegroundColor(Color color) {
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
    }

    public int getAlpha() {
        if (this.backgroundActive) {
            return this.bgAlpha;
        }
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.backgroundActive) {
            this.bgAlpha = alpha;
        } else {
            this.alpha = alpha;
        }
        this.setColor(this.getColor());
        Alchemy.toolBar.refreshTransparencySlider();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void toggleStyle() {
        this.style = this.style == 1 ? 2 : 1;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    boolean isGuideEnabled() {
        return this.guides;
    }

    void setGuide(boolean guides) {
        this.guides = guides;
    }

    public boolean isRecordIndicatorEnabled() {
        return this.recordIndicator;
    }

    public void setRecordIndicator(boolean recordIndicator) {
        this.recordIndicator = recordIndicator;
    }

    void setAutoToggleToolBar(boolean manageToolBar) {
        if (!Alchemy.preferences.paletteAttached) {
            this.autoToggleToolBar = manageToolBar;
        }
    }

    boolean isAutoToggleToolBar() {
        if (Alchemy.preferences.paletteAttached) {
            return false;
        }
        return this.autoToggleToolBar;
    }

    void flipHorizontal() {
        AffineTransform horizontalReflection = new AffineTransform();
        horizontalReflection.translate(this.getWidth(), 0.0);
        horizontalReflection.scale(-1.0, 1.0);
        for (AlcShape shape : this.shapes) {
            GeneralPath reflectedPath = (GeneralPath)shape.getPath().createTransformedShape(horizontalReflection);
            shape.setPath(reflectedPath);
        }
        this.redraw(true);
    }

    void flipVertical() {
        AffineTransform verticalReflection = new AffineTransform();
        verticalReflection.translate(0.0, this.getHeight());
        verticalReflection.scale(1.0, -1.0);
        for (AlcShape shape : this.shapes) {
            GeneralPath reflectedPath = (GeneralPath)shape.getPath().createTransformedShape(verticalReflection);
            shape.setPath(reflectedPath);
        }
        this.redraw(true);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.canvasImage = this.renderCanvas(true);
        if (image != null) {
            Alchemy.menuBar.unloadBackgroundImageItem.setEnabled(true);
        } else {
            Alchemy.menuBar.unloadBackgroundImageItem.setEnabled(false);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isImageSet() {
        return this.image != null;
    }

    public void setImageDisplay(boolean imageDisplay) {
        this.imageDisplay = imageDisplay;
        this.canvasImage = this.renderCanvas(true);
    }

    public boolean isImageDisplayEnabled() {
        return this.imageDisplay;
    }

    public void setImageLocation(Point p) {
        this.imageLocation = p;
    }

    public void setImageLocation(int x, int y) {
        this.imageLocation.x = x;
        this.imageLocation.y = y;
    }

    public Point getImageLocation() {
        return this.imageLocation;
    }

    public void resetImageLocation() {
        this.imageLocation.x = 0;
        this.imageLocation.y = 0;
    }

    void setTransparentImage(Image transparentImage) {
        this.transparentImage = transparentImage;
    }

    Image renderCanvas(boolean vectorMode) {
        return this.renderCanvas(vectorMode, false, 1.0, -1, -1);
    }

    Image renderCanvas(boolean vectorMode, boolean transparent) {
        return this.renderCanvas(vectorMode, transparent, 1.0, -1, -1);
    }

    Image renderCanvas(boolean vectorMode, double scale) {
        return this.renderCanvas(vectorMode, false, scale, -1, -1);
    }

    Image renderCanvas(boolean vectorMode, boolean transparent, double scale, int width, int height) {
        if (width == -1 || height == -1) {
            Rectangle visibleRect = this.getVisibleRect();
            width = visibleRect.width;
            height = visibleRect.height;
        }
        this.ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.gc = this.ge.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage buffImage = transparent ? this.gc.createCompatibleImage(width, height, 3) : this.gc.createCompatibleImage(width, height, 1);
        Graphics2D g2 = buffImage.createGraphics();
        this.recordIndicator = false;
        if (scale != 1.0) {
            g2.scale(scale, scale);
        }
        if (transparent) {
            this.vectorCanvas.transparent = true;
            this.vectorCanvas.paintComponent(g2);
            this.vectorCanvas.transparent = false;
        } else if (vectorMode) {
            this.vectorCanvas.paintComponent(g2);
        } else {
            this.paintComponent(g2);
        }
        g2.dispose();
        return buffImage;
    }

    boolean saveBitmap(File file) {
        return this.saveBitmap(file, "png", false);
    }

    boolean saveBitmap(File file, boolean transparent) {
        return this.saveBitmap(file, "png", transparent);
    }

    boolean saveBitmap(File file, String format) {
        return this.saveBitmap(file, format, false);
    }

    boolean saveBitmap(File file, String format, boolean transparent) {
        try {
            this.setGuide(false);
            Image bitmapImage = this.renderCanvas(true, transparent);
            this.setGuide(true);
            ImageIO.write((RenderedImage)((BufferedImage)bitmapImage), format, file);
            return true;
        }
        catch (IOException ex) {
            System.err.println(ex);
            return false;
        }
    }

    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        double factor;
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2p = (Graphics2D)g;
        g2p.translate(format.getImageableX(), format.getImageableY());
        Dimension size = this.getSize();
        double pageWidth = format.getImageableWidth();
        double pageHeight = format.getImageableHeight();
        if ((double)size.width > pageWidth) {
            factor = pageWidth / (double)size.width;
            System.out.println("Width Scale: " + factor);
            g2p.scale(factor, factor);
            pageWidth /= factor;
            pageHeight /= factor;
        }
        if ((double)size.height > pageHeight) {
            factor = pageHeight / (double)size.height;
            System.out.println("Height Scale: " + factor);
            g2p.scale(factor, factor);
            pageWidth /= factor;
            pageHeight /= factor;
        }
        g2p.translate((pageWidth - (double)size.width) / 2.0, (pageHeight - (double)size.height) / 2.0);
        g2p.setClip(0, 0, size.width, size.height);
        this.vectorCanvas.paintComponent(g);
        return 0;
    }

    public void mouseMoved(MouseEvent event) {
        this.setPenLocation(event);
        if (this.isAutoToggleToolBar()) {
            Alchemy.toolBar.toggleToolBar(event.getY());
        }
        if (this.events) {
            if (this.createEvents) {
                Alchemy.plugins.creates[Alchemy.plugins.currentCreate].mouseMoved(event);
            }
            if (this.affectEvents && Alchemy.plugins.hasCurrentAffects()) {
                for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                    if (!Alchemy.plugins.currentAffects[i]) continue;
                    Alchemy.plugins.affects[i].mouseMoved(event);
                }
            }
        }
        if (this.penType != 3) {
            this.penLocationChanged = false;
        }
    }

    public void mousePressed(MouseEvent event) {
        this.penDown = true;
        if (!Alchemy.preferences.paletteAttached && Alchemy.toolBar.isToolBarVisible() && !Alchemy.preferences.simpleToolBar && event.getY() >= Alchemy.toolBar.getTotalHeight()) {
            Alchemy.toolBar.setToolBarVisible(false);
        }
        if (this.events) {
            if (this.createEvents) {
                Alchemy.plugins.creates[Alchemy.plugins.currentCreate].mousePressed(event);
            }
            if (this.affectEvents && Alchemy.plugins.hasCurrentAffects()) {
                for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                    if (!Alchemy.plugins.currentAffects[i]) continue;
                    Alchemy.plugins.affects[i].mousePressed(event);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (this.events) {
            if (this.createEvents) {
                Alchemy.plugins.creates[Alchemy.plugins.currentCreate].mouseClicked(event);
            }
            if (this.affectEvents && Alchemy.plugins.hasCurrentAffects()) {
                for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                    if (!Alchemy.plugins.currentAffects[i]) continue;
                    Alchemy.plugins.affects[i].mouseClicked(event);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent event) {
        if (this.events) {
            if (this.createEvents) {
                Alchemy.plugins.creates[Alchemy.plugins.currentCreate].mouseEntered(event);
            }
            if (this.affectEvents && Alchemy.plugins.hasCurrentAffects()) {
                for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                    if (!Alchemy.plugins.currentAffects[i]) continue;
                    Alchemy.plugins.affects[i].mouseEntered(event);
                }
            }
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.events) {
            if (this.createEvents) {
                Alchemy.plugins.creates[Alchemy.plugins.currentCreate].mouseExited(event);
            }
            if (this.affectEvents && Alchemy.plugins.hasCurrentAffects()) {
                for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                    if (!Alchemy.plugins.currentAffects[i]) continue;
                    Alchemy.plugins.affects[i].mouseExited(event);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.penDown = false;
        if (this.events) {
            if (this.createEvents) {
                Alchemy.plugins.creates[Alchemy.plugins.currentCreate].mouseReleased(event);
            }
            if (this.affectEvents && Alchemy.plugins.hasCurrentAffects()) {
                for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                    if (!Alchemy.plugins.currentAffects[i]) continue;
                    Alchemy.plugins.affects[i].mouseReleased(event);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent event) {
        this.setPenLocation(event);
        if (this.events) {
            if (this.createEvents) {
                Alchemy.plugins.creates[Alchemy.plugins.currentCreate].mouseDragged(event);
            }
            if (this.affectEvents && Alchemy.plugins.hasCurrentAffects()) {
                for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                    if (!Alchemy.plugins.currentAffects[i]) continue;
                    Alchemy.plugins.affects[i].mouseDragged(event);
                }
            }
        }
        if (this.penType != 3) {
            this.penLocationChanged = false;
        }
    }

    public void penKindEvent(PKindEvent ev) {
        this.setPenType();
    }

    public void penLevelEvent(PLevelEvent ev) {
        if (this.penType != 3) {
            if (this.penDown) {
                this.penPressure = this.pm.pen.getLevelValue(PLevel.Type.PRESSURE);
                this.penPressure *= this.penPressure;
                this.penTilt.x = this.pm.pen.getLevelValue(PLevel.Type.TILT_X);
                this.penTilt.y = this.pm.pen.getLevelValue(PLevel.Type.TILT_Y);
            }
            if (ev.isMovement()) {
                this.setPenLocation(ev);
                this.penLocationChanged = true;
            }
        }
    }

    public void penButtonEvent(PButtonEvent arg0) {
    }

    public void penScrollEvent(PScrollEvent arg0) {
    }

    public void penTock(long arg0) {
    }

    class VectorCanvas
    extends JPanel
    implements AlcConstants {
        boolean transparent = false;
        private int width;
        private int height;

        VectorCanvas() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.width = Alchemy.canvas.getWidth();
            this.height = Alchemy.canvas.getHeight();
            Graphics2D g2 = (Graphics2D)g;
            PdfContentByte cb = null;
            if (g2 instanceof PdfGraphics2D) {
                PdfGraphics2D g2pdf = (PdfGraphics2D)g2;
                cb = g2pdf.getContent();
            }
            if (Alchemy.canvas.smoothing) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (!this.transparent) {
                Color bgColor = Alchemy.canvas.getBackgroundColor();
                g2.setColor(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()));
                g2.fillRect(0, 0, this.width, this.height);
            }
            if (Alchemy.session.pdfReadPage != null) {
                AffineTransform at = g2.getTransform();
                int pageWidth = (int)Alchemy.session.pdfReadPage.getWidth();
                int pageHeight = (int)Alchemy.session.pdfReadPage.getHeight();
                PDFRenderer renderer = new PDFRenderer(Alchemy.session.pdfReadPage, g2, new Rectangle(0, 0, pageWidth, pageHeight), null, Alchemy.canvas.getBackgroundColor());
                try {
                    Alchemy.session.pdfReadPage.waitForFinish();
                    renderer.run();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                g2.setTransform(at);
            }
            if (Alchemy.canvas.isImageDisplayEnabled() && Alchemy.canvas.isImageSet()) {
                Point p = Alchemy.canvas.getImageLocation();
                g2.drawImage(Alchemy.canvas.getImage(), p.x, p.y, null);
            }
            for (int j = 0; j < Alchemy.canvas.fullShapeList.length; ++j) {
                for (int i = 0; i < Alchemy.canvas.fullShapeList[j].size(); ++i) {
                    AlcShape currentShape = (AlcShape)Alchemy.canvas.fullShapeList[j].get(i);
                    Paint paint = currentShape.getPaint();
                    if (currentShape.style == 1) {
                        g2.setStroke(new BasicStroke(currentShape.lineWidth, 1, 2));
                        if (paint instanceof GradientPaint && cb != null) {
                            this.drawTransparentGradient(cb, g2, (GradientPaint)paint, currentShape.path, false);
                            continue;
                        }
                        g2.setPaint(paint);
                        g2.draw(currentShape.path);
                        continue;
                    }
                    if (paint instanceof GradientPaint && cb != null) {
                        this.drawTransparentGradient(cb, g2, (GradientPaint)paint, currentShape.path, true);
                        continue;
                    }
                    g2.setPaint(paint);
                    g2.fill(currentShape.path);
                }
            }
            if (Alchemy.canvas.isGuideEnabled()) {
                for (int i = 0; i < Alchemy.canvas.guideShapes.size(); ++i) {
                    AlcShape currentShape = Alchemy.canvas.guideShapes.get(i);
                    if (currentShape.style == 1) {
                        g2.setStroke(new BasicStroke(currentShape.lineWidth, 1, 2));
                        g2.setColor(currentShape.color);
                        g2.draw(currentShape.path);
                        continue;
                    }
                    g2.setColor(currentShape.color);
                    g2.fill(currentShape.path);
                }
            }
            g2.dispose();
        }

        private void drawTransparentGradient(PdfContentByte cb, Graphics2D g2, GradientPaint gp, GeneralPath path, boolean fill) {
            PdfTemplate template = cb.createTemplate(this.width, this.height);
            PdfTransparencyGroup transGroup = new PdfTransparencyGroup();
            transGroup.put(PdfName.CS, PdfName.DEVICERGB);
            transGroup.setIsolated(true);
            transGroup.setKnockout(false);
            template.setGroup(transGroup);
            PdfGState gState = new PdfGState();
            PdfDictionary maskDict = new PdfDictionary();
            maskDict.put(PdfName.TYPE, PdfName.MASK);
            maskDict.put(PdfName.S, new PdfName("Luminosity"));
            maskDict.put(new PdfName("G"), template.getIndirectReference());
            gState.put(PdfName.SMASK, maskDict);
            cb.setGState(gState);
            PdfShading shading = PdfShading.simpleAxial(cb.getPdfWriter(), (float)gp.getPoint1().getX(), (float)((double)this.height - gp.getPoint1().getY()), (float)gp.getPoint2().getX(), (float)((double)this.height - gp.getPoint2().getY()), Color.WHITE, Color.BLACK, true, true);
            template.paintShading(shading);
            g2.setColor(gp.getColor1());
            if (fill) {
                g2.fill(path);
            } else {
                g2.draw(path);
            }
        }
    }
}

