/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.wintab;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpen.PButton;
import jpen.PKind;
import jpen.PLevel;
import jpen.PenDevice;
import jpen.provider.AbstractPenDevice;
import jpen.provider.wintab.WintabAccess;
import jpen.provider.wintab.WintabProvider;

class WintabDevice
extends AbstractPenDevice {
    private static final Logger L = Logger.getLogger(WintabDevice.class.getName());
    final WintabProvider wintabProvider;
    public final int cursor;
    private int lastButtonsValues;
    private final Point2D.Float componentLocation = new Point2D.Float();
    private final Dimension componentSize = new Dimension();
    private final List<PLevel> changedLevels = new ArrayList<PLevel>();
    private static final float PI_2 = (float)Math.PI * 2;
    private static final double PI_over_2 = 1.5707963267948966;
    private static final double PI_over_2_over_900 = 0.0017453292519943296;

    WintabDevice(WintabProvider wintabProvider, int cursor) {
        super(wintabProvider);
        L.fine("start");
        this.wintabProvider = wintabProvider;
        this.cursor = cursor;
        this.setKindTypeNumber(this.getDefaultKindTypeNumber());
        this.setEnabled(true);
        L.fine("end");
    }

    protected String evalPhysicalId() {
        WintabAccess cfr_ignored_0 = this.wintabProvider.wintabAccess;
        WintabAccess cfr_ignored_1 = this.wintabProvider.wintabAccess;
        return WintabAccess.getRawCursorType(this.cursor) + "." + WintabAccess.getPhysicalId(this.cursor) + "@" + this.wintabProvider.getConstructor().getName();
    }

    private int getDefaultKindTypeNumber() {
        WintabAccess cfr_ignored_0 = this.wintabProvider.wintabAccess;
        WintabAccess.CursorType cursorType = WintabAccess.getCursorType(this.cursor);
        switch (cursorType) {
            case PENTIP: {
                return PKind.Type.STYLUS.ordinal();
            }
            case PUCK: {
                return PKind.Type.CURSOR.ordinal();
            }
            case PENERASER: {
                return PKind.Type.ERASER.ordinal();
            }
        }
        return PKind.Type.CURSOR.ordinal();
    }

    public String getName() {
        WintabAccess cfr_ignored_0 = this.wintabProvider.wintabAccess;
        return WintabAccess.getCursorName(this.cursor).trim();
    }

    void scheduleEvents() {
        if (!this.getEnabled()) {
            L.fine("disabled");
            return;
        }
        this.scheduleLevelEvent();
    }

    private void scheduleButtonEvents() {
        int newButtonsValues = this.wintabProvider.wintabAccess.getButtons();
        if (newButtonsValues == this.lastButtonsValues) {
            return;
        }
        if (L.isLoggable(Level.FINE)) {
            L.fine("newButtonsValues=" + newButtonsValues);
        }
        for (PButton.Type buttonType : PButton.Type.values()) {
            boolean value = this.getButtonState(newButtonsValues, this.getButtonIndex(buttonType));
            this.getPenManager().scheduleButtonEvent(this, this.wintabProvider.wintabAccess.getTime(), new PButton(buttonType.ordinal(), value));
        }
        this.lastButtonsValues = newButtonsValues;
    }

    private int getButtonIndex(PButton.Type type) {
        switch (type) {
            case LEFT: {
                return 0;
            }
            case RIGHT: {
                return 1;
            }
            case CENTER: {
                return 2;
            }
        }
        throw new AssertionError();
    }

    private boolean getButtonState(int buttonsState, int buttonIndex) {
        return (buttonsState & 1 << buttonIndex) > 0;
    }

    private void scheduleLevelEvent() {
        int i = PLevel.Type.VALUES.size();
        while (--i >= 0) {
            PLevel.Type levelType = PLevel.Type.VALUES.get(i);
            float value = this.getMultRangedValue(levelType);
            this.changedLevels.add(new PLevel(levelType, value));
        }
        this.getPenManager().scheduleLevelEvent((PenDevice)this, this.wintabProvider.wintabAccess.getTime(), this.changedLevels, true);
        this.changedLevels.clear();
    }

    private float getMultRangedValue(PLevel.Type type) {
        if (PLevel.Type.TILT_TYPES.contains((Object)type)) {
            int altitude = this.wintabProvider.wintabAccess.getValue(PLevel.Type.TILT_Y);
            if (altitude < 0) {
                altitude = -altitude;
            }
            if (altitude == 900) {
                return 0.0f;
            }
            double betha = (double)altitude * 0.0017453292519943296;
            double theta = (double)this.wintabProvider.wintabAccess.getValue(PLevel.Type.TILT_X) * 0.0017453292519943296 - 1.5707963267948966;
            switch (type) {
                case TILT_X: {
                    return (float)Math.atan(Math.cos(theta) / Math.tan(betha));
                }
                case TILT_Y: {
                    return (float)Math.atan(Math.sin(theta) / Math.tan(betha));
                }
            }
            throw new AssertionError();
        }
        float rangedValue = this.wintabProvider.getLevelRange(type).getRangedValue(this.wintabProvider.wintabAccess.getValue(type));
        if (PLevel.Type.MOVEMENT_TYPES.contains((Object)type)) {
            if (type.equals((Object)PLevel.Type.Y)) {
                rangedValue = 1.0f - rangedValue;
            }
            rangedValue = this.wintabProvider.screenBounds.getLevelRangeOffset(type) + rangedValue * this.wintabProvider.screenBounds.getLevelRangeMult(type);
        }
        if (PLevel.Type.ROTATION.equals((Object)type)) {
            rangedValue *= (float)Math.PI * 2;
        }
        return rangedValue;
    }
}

