/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.wintab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jpen.PLevel;
import jpen.provider.wintab.WintabProvider;

public final class WintabAccess {
    private static final Object LOCK = new Object();
    private final int cellIndex;
    public static final int LEVEL_TYPE_X = 0;
    public static final int LEVEL_TYPE_Y = 1;
    public static final int LEVEL_TYPE_PRESSURE = 2;
    public static final int LEVEL_TYPE_TILT_AZIMUTH = 3;
    public static final int LEVEL_TYPE_TILT_ALTITUDE = 4;
    public static final int LEVEL_TYPE_SIDE_PRESSURE = 5;
    public static final int LEVEL_TYPE_ROTATION = 6;
    public static final int BUTTON1_MASK = 1;
    public static final int BUTTON2_MASK = 2;
    public static final int BUTTON3_MASK = 4;
    public static final int PK_CONTEXT = 1;
    public static final int PK_STATUS = 2;
    public static final int PK_TIME = 4;
    public static final int PK_CHANGED = 8;
    public static final int PK_SERIAL_NUMBER = 16;
    public static final int PK_CURSOR = 32;
    public static final int PK_BUTTONS = 64;
    public static final int PK_X = 128;
    public static final int PK_Y = 256;
    public static final int PK_Z = 512;
    public static final int PK_NORMAL_PRESSURE = 1024;
    public static final int PK_TANGENT_PRESSURE = 2048;
    public static final int PK_ORIENTATION = 4096;
    public static final int PK_ROTATION = 8192;
    public static final int TU_NONE = 0;
    public static final int TU_INCHES = 1;
    public static final int TU_CENTIMETERS = 2;
    public static final int TU_CIRCLE = 3;
    public static final int HWC_INTEGRATED = 1;
    public static final int HWC_TOUCH = 2;
    public static final int HWC_HARDPROX = 4;
    public static final int HWC_PHYSID_CURSORS = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WintabAccess() throws Exception {
        Object object = LOCK;
        synchronized (object) {
            WintabProvider.loadLibrary();
            this.cellIndex = WintabAccess.create();
            if (this.cellIndex == -1) {
                throw new Exception(WintabAccess.getError());
            }
        }
    }

    private static native int create();

    private static native String getError();

    public static native int getNativeBuild();

    public int getValue(PLevel.Type levelType) {
        return this.getValue(WintabAccess.getLevelTypeValueIndex(levelType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValue(int type) {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getValue(this.cellIndex, type);
        }
    }

    private static native int getValue(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextPacket() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.nextPacket(this.cellIndex);
        }
    }

    private static native boolean nextPacket(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEnabled() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getEnabled(this.cellIndex);
        }
    }

    private static native boolean getEnabled(int var0);

    private static native int getStatus(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        Object object = LOCK;
        synchronized (object) {
            WintabAccess.setEnabled(this.cellIndex, enabled);
        }
    }

    private static native void setEnabled(int var0, boolean var1);

    public PLevel.Range getLevelRange(PLevel.Type levelType) {
        int[] minMax = this.getLevelRange(WintabAccess.getLevelTypeValueIndex(levelType));
        return new PLevel.Range(minMax[0], minMax[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLevelRange(int type) {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getLevelRange(this.cellIndex, type);
        }
    }

    static int getLevelTypeValueIndex(PLevel.Type levelType) {
        return levelType.ordinal();
    }

    private static native int[] getLevelRange(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCursor() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getCursor(this.cellIndex);
        }
    }

    private static native int getCursor(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTime() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getTime(this.cellIndex);
        }
    }

    private static native long getTime(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getButtons() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getButtons(this.cellIndex);
        }
    }

    private static native int getButtons(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CursorType getCursorType(int cursor) {
        Object object = LOCK;
        synchronized (object) {
            return CursorType.VALUES.get(WintabAccess.getCursorTypeOrdinal(cursor));
        }
    }

    public static native int getCursorTypeOrdinal(int var0);

    public static native int getRawCursorType(int var0);

    public static native String getCursorName(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPacketRate() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getPacketRate(this.cellIndex);
        }
    }

    private static native int getPacketRate(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceName() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getDeviceName(this.cellIndex);
        }
    }

    private static native String getDeviceName(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeviceHardwareCapabilities() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getDeviceHardwareCapabilities(this.cellIndex);
        }
    }

    private static native int getDeviceHardwareCapabilities(int var0);

    public static native int getPhysicalId(int var0);

    public static native int getButtonCount(int var0);

    public static native String[] getButtonNames(int var0);

    public static native int getCapabilityMask(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = LOCK;
        synchronized (object) {
            if (this.cellIndex != -1) {
                WintabAccess.destroy(this.cellIndex);
            }
        }
        super.finalize();
    }

    private static native int destroy(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        Object object = LOCK;
        synchronized (object) {
            return WintabAccess.getStatus(this.cellIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = LOCK;
        synchronized (object) {
            StringBuffer sb = new StringBuffer();
            sb.append("WintabAccess:[values=(");
            for (PLevel.Type levelType : PLevel.Type.values()) {
                sb.append((Object)levelType);
                sb.append("=");
                sb.append(this.getValue(levelType));
                sb.append(",");
            }
            sb.append(") levelRanges=( ");
            for (PLevel.Type levelType : PLevel.Type.values()) {
                sb.append((Object)levelType);
                sb.append("=");
                sb.append(this.getLevelRange(levelType));
                sb.append(" ");
            }
            sb.append("), cursor=");
            sb.append(this.getCursor());
            sb.append(", cursorType=");
            sb.append((Object)WintabAccess.getCursorType(this.getCursor()));
            sb.append(", id=" + WintabAccess.getPhysicalId(this.getCursor()));
            sb.append(", buttons=");
            sb.append(this.getButtons());
            sb.append(", status=" + this.getStatus());
            sb.append("]");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CursorType {
        UNDEF,
        PENTIP,
        PUCK,
        PENERASER;

        public static final List<CursorType> VALUES;

        static {
            VALUES = Collections.unmodifiableList(Arrays.asList(CursorType.values()));
        }
    }
}

