/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

final class Utils {
    private static final Border LABELED_COMPONENT_BORDER = BorderFactory.createEmptyBorder(3, 3, 2, 2);

    Utils() {
    }

    static JComponent labelComponent(String label, Component c) {
        Box box = Box.createHorizontalBox();
        if (!label.trim().endsWith(":")) {
            label = label.trim() + ": ";
        }
        box.add(new JLabel(label));
        box.add(Box.createHorizontalGlue());
        Utils.freezeSizeToPreferred(c);
        box.add(c);
        box.setBorder(LABELED_COMPONENT_BORDER);
        return Utils.alignTopLeft(box);
    }

    static void freezeSizeToPreferred(Component c) {
        Utils.freezeSize(c, c.getPreferredSize());
    }

    static void freezeSize(Component c, Dimension s) {
        c.validate();
        c.setMinimumSize(s);
        c.setMaximumSize(s);
        c.setPreferredSize(s);
    }

    static JComponent alignTopLeft(JComponent c) {
        c.setAlignmentX(0.0f);
        c.setAlignmentY(0.0f);
        return c;
    }

    static Component createHorizontalStrut() {
        return new Box.Filler(new Dimension(3, 0), new Dimension(3, 0), new Dimension(3, 0));
    }

    static Component createVerticalStrut() {
        return new Box.Filler(new Dimension(0, 3), new Dimension(0, 3), new Dimension(0, 3));
    }
}

