/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;

public final class Utils {
    private static ResourceBundle moduleProperties;

    @Deprecated
    public static ResourceBundle getModuleProperties() {
        return Utils.getBuildProperties();
    }

    public static ResourceBundle getBuildProperties() {
        if (moduleProperties == null) {
            moduleProperties = ResourceBundle.getBundle("jpen.build");
        }
        return moduleProperties;
    }

    public static String getModuleId() {
        return Utils.getBuildProperties().getString("module.id");
    }

    public static String getFullVersion() {
        return Utils.getVersion() + "-" + Utils.getBuild();
    }

    public static String getVersion() {
        return Utils.getBuildProperties().getString("module.version");
    }

    public static String getBuild() {
        return Utils.getBuildProperties().getString("module.distVersion");
    }

    public static String evalStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizedWait(Object lock, long timeout) {
        Object object = lock;
        synchronized (object) {
            Utils.waitUninterrupted(lock, timeout);
        }
    }

    public static void waitUninterrupted(Object lock, long timeout) {
        try {
            lock.wait(timeout);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void waitUninterrupted(Object lock) {
        Utils.waitUninterrupted(lock, 0L);
    }

    public static void sleepUninterrupted(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static final class AccessibleField {
        private final Class clazz;
        private final String fieldName;
        private Field field;

        AccessibleField(Class clazz, String fieldName) {
            this.clazz = clazz;
            this.fieldName = fieldName;
        }

        Field getField() {
            if (this.field == null) {
                try {
                    this.field = AccessibleField.getAccessibleField(this.clazz, this.fieldName);
                }
                catch (PrivilegedActionException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            return this.field;
        }

        private static Field getAccessibleField(final Class clazz, final String fieldName) throws PrivilegedActionException {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws Exception {
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field;
                }
            });
        }
    }
}

