/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedClass<T extends Enum<T>>
implements Serializable {
    public static final long serialVersionUID = 1L;
    public final int typeNumber;

    TypedClass(int typeNumber) {
        if (typeNumber < 0) {
            throw new IllegalArgumentException();
        }
        this.typeNumber = typeNumber;
    }

    abstract List<T> getAllTypes();

    public final T getType() {
        return this.getType(this.typeNumber);
    }

    private final T getType(int typeNumber) {
        List<T> allTypes;
        int customTypeOrdinal = TypedClass.getCustomTypeOrdinal(allTypes = this.getAllTypes());
        return (T)((Enum)allTypes.get(typeNumber < customTypeOrdinal ? typeNumber : customTypeOrdinal));
    }

    private static final <T extends Enum<T>> int getCustomTypeOrdinal(List<T> allTypes) {
        return allTypes.size() - 1;
    }

    static final <T extends Enum<T>> List<T> createStandardTypes(List<T> allTypes) {
        int customTypeOrdinal = TypedClass.getCustomTypeOrdinal(allTypes);
        ArrayList<T> stdTypes = new ArrayList<T>(customTypeOrdinal);
        for (int i = 0; i < customTypeOrdinal; ++i) {
            stdTypes.add(allTypes.get(i));
        }
        return Collections.unmodifiableList(stdTypes);
    }

    public String toString() {
        return "(type=" + this.getType() + ")";
    }
}

