/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jpen.PButton;
import jpen.PKind;
import jpen.PLevel;
import jpen.PLevelEvent;

public class PenState
implements Serializable {
    public static final long serialVersionUID = 1L;
    private PKind kind = PKind.valueOf(PKind.Type.CURSOR);
    final Levels levels = new Levels();
    private final int[] buttonValues = new int[PButton.Type.VALUES.size()];
    final Map<Integer, Integer> extButtonTypeNumberToValue = new HashMap<Integer, Integer>();
    private int pressedButtonsCount;

    PenState() {
    }

    public float getLevelValue(PLevel.Type levelType) {
        return this.levels.getValue(levelType.ordinal());
    }

    public float getLevelValue(int levelTypeNumber) {
        return this.levels.getValue(levelTypeNumber);
    }

    public PKind getKind() {
        return this.kind;
    }

    void setKind(PKind kind) {
        this.kind = kind;
    }

    public boolean getButtonValue(PButton.Type buttonType) {
        return this.getButtonValue(buttonType.ordinal());
    }

    public boolean getButtonValue(int buttonTypeNumber) {
        return (buttonTypeNumber >= this.buttonValues.length ? this.getExtButtonValue(buttonTypeNumber) : this.buttonValues[buttonTypeNumber]) > 0;
    }

    public boolean hasPressedButtons() {
        return this.pressedButtonsCount > 0;
    }

    public int getPressedButtonsCount() {
        return this.pressedButtonsCount;
    }

    private int getExtButtonValue(int buttonTypeNumber) {
        Integer buttonValue = this.extButtonTypeNumberToValue.get(buttonTypeNumber);
        return buttonValue == null ? 0 : buttonValue;
    }

    boolean setButtonValue(int buttonTypeNumber, boolean value) {
        boolean oldValue = this.getButtonValue(buttonTypeNumber);
        if (buttonTypeNumber >= this.buttonValues.length) {
            this.setExtButtonValue(buttonTypeNumber, value);
        } else if (value) {
            if (this.buttonValues[buttonTypeNumber] == 0) {
                ++this.pressedButtonsCount;
            }
            int n = buttonTypeNumber;
            this.buttonValues[n] = this.buttonValues[n] + 1;
        } else {
            if (this.buttonValues[buttonTypeNumber] > 0) {
                --this.pressedButtonsCount;
            }
            this.buttonValues[buttonTypeNumber] = 0;
        }
        return oldValue != this.getButtonValue(buttonTypeNumber);
    }

    private void setExtButtonValue(int buttonTypeNumber, boolean value) {
        int currentValue = this.getExtButtonValue(buttonTypeNumber);
        if (value) {
            if (currentValue == 0) {
                ++this.pressedButtonsCount;
            }
            this.extButtonTypeNumberToValue.put(buttonTypeNumber, this.getExtButtonValue(buttonTypeNumber) + 1);
        } else {
            if (currentValue > 0) {
                --this.pressedButtonsCount;
            }
            this.extButtonTypeNumberToValue.put(buttonTypeNumber, 0);
        }
    }

    void setValues(PenState penState) {
        this.levels.setValues(penState.levels);
        int i = this.buttonValues.length;
        while (--i >= 0) {
            this.buttonValues[i] = penState.buttonValues[i];
        }
        this.extButtonTypeNumberToValue.clear();
        this.extButtonTypeNumberToValue.putAll(penState.extButtonTypeNumberToValue);
        this.kind = penState.kind;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Levels
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private final float[] values = new float[PLevel.Type.VALUES.size()];
        private final Map<Integer, Float> extTypeNumberToValue = new HashMap<Integer, Float>();

        public void setValues(PenState penState) {
            this.setValues(penState.levels);
        }

        public void setValues(Levels levels) {
            int i = levels.values.length;
            while (--i >= 0) {
                this.values[i] = levels.values[i];
            }
            this.extTypeNumberToValue.clear();
            this.extTypeNumberToValue.putAll(levels.extTypeNumberToValue);
            for (i = levels.values.length; i < this.values.length; ++i) {
                Float value = this.extTypeNumberToValue.remove(i);
                if (value == null) continue;
                this.values[i] = value.floatValue();
            }
        }

        public void setValues(PLevelEvent ev) {
            this.setValues(ev.levels);
        }

        public final void setValues(Collection<PLevel> levels) {
            for (PLevel level : levels) {
                this.setValue(level);
            }
        }

        public final void setValues(PLevel[] levels) {
            int i = levels.length;
            while (--i >= 0) {
                this.setValue(levels[i]);
            }
        }

        public final void setValue(PLevel level) {
            this.setValue(level.typeNumber, ((Float)level.value).floatValue());
        }

        public final void setValue(PLevel.Type levelType, float value) {
            this.setValue(levelType.ordinal(), value);
        }

        public final void setValue(int levelTypeNumber, float value) {
            if (levelTypeNumber < this.values.length) {
                this.values[levelTypeNumber] = value;
            } else {
                this.setExtValue(levelTypeNumber, value);
            }
        }

        public float getValue(int levelTypeNumber) {
            return levelTypeNumber < this.values.length ? this.values[levelTypeNumber] : this.getExtValue(levelTypeNumber);
        }

        public float getValue(PLevel.Type levelType) {
            return this.getValue(levelType.ordinal());
        }

        private float getExtValue(int extLevelTypeNumber) {
            Float value = this.extTypeNumberToValue.get(extLevelTypeNumber);
            return value == null ? 0.0f : value.floatValue();
        }

        private final void setExtValue(int levelTypeNumber, float value) {
            this.extTypeNumberToValue.put(levelTypeNumber, Float.valueOf(value));
        }
    }
}

