/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import jpen.Pen;
import jpen.PenDevice;
import jpen.PenState;
import jpen.Utils;

public abstract class PenEvent
implements Serializable {
    public static final long serialVersionUID = 2L;
    protected long time = -1L;
    volatile transient PenEvent next;
    public final transient Pen pen;
    private final byte deviceId;
    private final long deviceTime;
    static final Utils.AccessibleField deviceIdField = new Utils.AccessibleField(PenEvent.class, "deviceId");
    static final Utils.AccessibleField deviceTimeField = new Utils.AccessibleField(PenEvent.class, "deviceTime");

    PenEvent(PenDevice device, long deviceTime) {
        this(device.getProvider().getConstructor().getPenManager().pen, device.getId(), deviceTime);
    }

    private PenEvent(Pen pen, byte deviceId, long deviceTime) {
        this.pen = pen;
        this.deviceId = deviceId;
        this.deviceTime = deviceTime;
    }

    public long getTime() {
        return this.time;
    }

    abstract void copyTo(PenState var1);

    abstract void dispatch();

    public byte getDeviceId() {
        return this.deviceId;
    }

    public PenDevice getDevice() {
        if (this.pen == null) {
            throw new IllegalStateException();
        }
        return this.pen.penManager.getDevice(this.deviceId);
    }

    public long getDeviceTime() {
        return this.deviceTime;
    }

    public String toString() {
        return "[PenEvent: deviceId=" + this.deviceId + ", deviceTime=" + this.deviceTime + ", time=" + this.time + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream.GetField fields = in.readFields();
            this.time = fields.get("time", 0L);
            if (fields.defaulted("deviceTime")) {
                deviceTimeField.getField().set(this, fields.get("deviceTime", this.time));
            }
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static final class Dummy
    extends PenEvent {
        Dummy() {
            super(null, (byte)0, 0L);
        }

        void copyTo(PenState penState) {
        }

        void dispatch() {
        }
    }
}

