/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

public class CCITTFaxDecode {
    static CCITTTreeNode blackTree;
    static CCITTTreeNode whiteTree;
    private ByteBuffer buf;
    private int bytenum = 0;
    private int bitnum = 8;
    private byte bits;
    private int[] refline;
    private int reflen;
    private int refloc;
    private int[] curline;
    private int curlen;
    private int prevspan;
    private int nlines;
    private int WHITEBIT = 0;
    private ByteArrayOutputStream baos;
    private int destbyte;
    private int bitsremaining = 8;
    public static final int TWOD = 2;
    public static final int UNCOMPRESSED = 3;
    public static final int PASS = 4;
    public static final int VERTICAL = 5;
    public static final int HORIZONTAL = 6;
    public static final int BLACK = 1;
    public static final int WHITE = 0;

    private void createTrees() throws IOException {
        String line;
        InputStream is = this.getClass().getResourceAsStream("CCITTCodes");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        CCITTTreeBranch base = null;
        while ((line = br.readLine()) != null) {
            char nextChar;
            if (line.startsWith("# BLACK")) {
                blackTree = new CCITTTreeBranch();
                base = blackTree;
                continue;
            }
            if (line.startsWith("# WHITE")) {
                whiteTree = new CCITTTreeBranch();
                base = whiteTree;
                continue;
            }
            if (line.startsWith("#") || line.length() <= 0) continue;
            int scanbit = 0;
            char thisChar = line.charAt(scanbit++);
            CCITTTreeBranch tn = base;
            while ((nextChar = line.charAt(scanbit++)) != ' ') {
                if (thisChar == '0') {
                    if (tn.zero == null) {
                        tn.zero = new CCITTTreeBranch();
                    }
                    if (tn.zero instanceof CCITTTreeLeaf) {
                        throw new PDFParseException("Bad form: " + line + " has a leaf at bit number " + (scanbit - 1));
                    }
                    tn = (CCITTTreeBranch)tn.zero;
                } else {
                    if (tn.one == null) {
                        tn.one = new CCITTTreeBranch();
                    }
                    if (tn.one instanceof CCITTTreeLeaf) {
                        throw new PDFParseException("Bad form: " + line + " has a leaf at bit number " + (scanbit - 1));
                    }
                    tn = (CCITTTreeBranch)tn.one;
                }
                thisChar = nextChar;
            }
            int code = Integer.parseInt(line.substring(scanbit));
            if (thisChar == '0') {
                if (tn.zero != null) {
                    throw new PDFParseException("Bad form: last char of " + line + " is already occupied in the tree");
                }
                tn.zero = new CCITTTreeLeaf(code);
                continue;
            }
            if (tn.one != null) {
                throw new PDFParseException("Bad form: last char of " + line + " is already occupied in the tree");
            }
            tn.one = new CCITTTreeLeaf(code);
        }
    }

    private CCITTFaxDecode(ByteBuffer buf) throws IOException {
        if (blackTree == null) {
            this.createTrees();
        }
        this.buf = buf;
        this.bitnum = 0;
        this.bits = buf.get(0);
        this.bytenum = 1;
    }

    private void invert() {
        this.WHITEBIT = 1 - this.WHITEBIT;
    }

    private boolean nextBit() {
        if (this.bitnum == 8) {
            this.bitnum = 0;
            try {
                this.bits = this.buf.get(this.bytenum++);
            }
            catch (RuntimeException e) {
                System.out.println("Error: bytenum=" + this.bytenum + " of " + this.buf.limit());
                throw e;
            }
        }
        ++this.bitnum;
        boolean value = (this.bits & 0x80) != 0;
        this.bits = (byte)(this.bits << 1);
        return value;
    }

    private int nextCode(CCITTTreeNode base) throws PDFParseException {
        while (!(base instanceof CCITTTreeLeaf)) {
            base = this.nextBit() ? ((CCITTTreeBranch)base).one : ((CCITTTreeBranch)base).zero;
            if (base != null) continue;
            System.out.println(" bleah.");
            throw new PDFParseException("Bad code word!");
        }
        return ((CCITTTreeLeaf)base).code;
    }

    private int nextDist(CCITTTreeNode base) throws PDFParseException {
        int code;
        int tot = code = this.nextCode(base);
        while (code >= 64) {
            code = this.nextCode(base);
            tot += code;
        }
        return tot;
    }

    private void skipToEOL() {
        int bitcount = 0;
        int totcount = 0;
        while (true) {
            if (!this.nextBit()) {
                ++bitcount;
            } else {
                if (bitcount > 10) break;
                bitcount = 0;
            }
            if ((++totcount & 7) == 0) {
                System.out.print(" ");
            }
            if ((totcount & 0x3F) != 0) continue;
            System.out.println();
        }
    }

    private void addColor(int color, int num) {
        if (this.prevspan == color) {
            int n = this.curlen - 1;
            this.curline[n] = this.curline[n] + num;
        } else {
            if (this.curlen == this.curline.length) {
                int[] nline = new int[this.curline.length * 2];
                System.arraycopy(this.curline, 0, nline, 0, this.curline.length);
                this.curline = nline;
            }
            this.curline[this.curlen] = this.curline[this.curlen - 1] + num;
            ++this.curlen;
            this.prevspan = color;
        }
    }

    private int findB1(int a0color) {
        int start;
        int n = start = this.curlen == 1 ? -1 : this.curline[this.curlen - 1];
        while (this.refline[this.refloc] <= start) {
            ++this.refloc;
        }
        int scan = this.refloc;
        if ((scan & 1) == 0 == (a0color == 0)) {
            ++scan;
        }
        return this.refline[scan] - this.curline[this.curlen - 1];
    }

    private int findB2(int a0color) {
        int start;
        int n = start = this.curlen == 1 ? -1 : this.curline[this.curlen - 1];
        while (this.refline[this.refloc] <= start) {
            ++this.refloc;
        }
        int scan = this.refloc;
        if ((scan & 1) == 0 == (a0color == 0)) {
            ++scan;
        }
        return this.refline[scan + 1] - this.curline[this.curlen - 1];
    }

    private void stuffBlackBits(int span) {
        int num = span;
        int fillbits = 255 >> 8 - this.bitsremaining;
        this.destbyte |= (byte)fillbits;
        this.bitsremaining -= num;
        while (this.bitsremaining <= 0) {
            this.baos.write(this.destbyte);
            this.destbyte = 255;
            this.bitsremaining += 8;
        }
        this.destbyte &= 255 << this.bitsremaining;
    }

    private void stuffWhiteBits(int span) {
        int num = span;
        this.bitsremaining -= num;
        while (this.bitsremaining <= 0) {
            this.baos.write(this.destbyte);
            this.destbyte = 0;
            this.bitsremaining += 8;
        }
    }

    private void processLine(int width, int linenum) {
        for (int i = 1; i < this.reflen; ++i) {
            int len = this.refline[i] - this.refline[i - 1];
            if (len <= 0) continue;
            if ((i & 1) == this.WHITEBIT) {
                this.stuffWhiteBits(len);
                continue;
            }
            this.stuffBlackBits(len);
        }
        this.stuffWhiteBits(this.bitsremaining % 8);
    }

    private int decodeLine(int totlen) throws PDFParseException {
        boolean linelen = false;
        int mode = 2;
        int color = 0;
        int prevlen = 0;
        this.curline = new int[500];
        this.curlen = 0;
        this.curline[this.curlen++] = 0;
        this.prevspan = 1;
        this.refloc = 0;
        while (this.curline[this.curlen - 1] < totlen) {
            int count;
            if (mode == 3) {
                count = 0;
                while (!this.nextBit()) {
                    ++count;
                }
                if (count <= 5) {
                    this.addColor(0, count);
                    if (count < 5) {
                        this.addColor(1, 1);
                    }
                } else {
                    if (count > 10) break;
                    if (count > 6) {
                        this.addColor(0, count - 6);
                    }
                    color = this.nextBit() ? 1 : 0;
                    mode = 2;
                }
            } else if (mode == 2) {
                int len;
                count = 0;
                while (!this.nextBit()) {
                    ++count;
                }
                if (count == 2) {
                    for (int i = 0; i < 2; ++i) {
                        if (color == 0) {
                            len = this.nextDist(whiteTree);
                            this.addColor(0, len);
                            color = 1;
                            continue;
                        }
                        len = this.nextDist(blackTree);
                        this.addColor(1, len);
                        color = 0;
                    }
                } else if (count == 3) {
                    len = this.findB2(color);
                    if (color == 0) {
                        this.addColor(0, len);
                    } else {
                        this.addColor(1, len);
                    }
                } else if (count == 6) {
                    int type = (this.nextBit() ? 4 : 0) | (this.nextBit() ? 2 : 0) | (this.nextBit() ? 1 : 0);
                    mode = 3;
                } else if (count == 0) {
                    len = this.findB1(color);
                    if (color == 0) {
                        this.addColor(0, len);
                        color = 1;
                    } else {
                        this.addColor(1, len);
                        color = 0;
                    }
                } else {
                    int right;
                    if (count == 11) break;
                    int n = right = this.nextBit() ? 1 : -1;
                    if (count == 1) {
                        len = right;
                    } else if (count == 4) {
                        len = right * 2;
                    } else if (count == 5) {
                        len = right * 3;
                    } else {
                        throw new PDFParseException("Bad code word! (" + count + "), char=" + this.bytenum + ", line=" + this.nlines + ", insertion #" + this.curlen);
                    }
                    len += this.findB1(color);
                    if (color == 0) {
                        this.addColor(0, len);
                        color = 1;
                    } else {
                        this.addColor(1, len);
                        color = 0;
                    }
                }
            }
            if (this.curline[this.curlen - 1] > totlen) {
                throw new PDFParseException("Line went too long! (bytenum=" + this.bytenum + ", len=" + this.curline[this.curlen - 1] + " of " + totlen + ", prev=" + prevlen + ")");
            }
            prevlen = this.curline[this.curlen - 1];
        }
        this.addColor(0, 0);
        this.addColor(1, 0);
        this.addColor(0, 0);
        this.refline = this.curline;
        this.reflen = this.curlen;
        return this.curline[this.curlen - 1];
    }

    private ByteBuffer decode(int len, int rows) throws PDFParseException {
        int linelen;
        long time = System.currentTimeMillis();
        this.baos = new ByteArrayOutputStream();
        this.refline = new int[3];
        this.refline[0] = 0;
        this.refline[1] = this.refline[2] = len;
        this.reflen = 3;
        this.nlines = 0;
        while ((rows < 0 || this.nlines < rows) && (linelen = this.decodeLine(len)) != 0) {
            this.processLine(len, this.nlines);
            ++this.nlines;
        }
        return ByteBuffer.wrap(this.baos.toByteArray());
    }

    protected static ByteBuffer decode(PDFObject dict, ByteBuffer buf, PDFObject params) throws IOException {
        PDFObject blackis1;
        PDFObject height;
        CCITTFaxDecode me = new CCITTFaxDecode(buf);
        int len = 1728;
        int rows = -1;
        boolean invert = false;
        PDFObject cols = params.getDictRef("Columns");
        if (cols != null) {
            len = cols.getIntValue();
        }
        if ((height = dict.getDictRef("Height")) != null) {
            rows = height.getIntValue();
        }
        if ((blackis1 = params.getDictRef("BlackIs1")) != null && blackis1.getBooleanValue()) {
            me.invert();
        }
        return me.decode(len, rows);
    }

    class CCITTTreeLeaf
    extends CCITTTreeNode {
        int code;

        public CCITTTreeLeaf(int code) {
            this.code = code;
        }
    }

    class CCITTTreeBranch
    extends CCITTTreeNode {
        CCITTTreeNode zero;
        CCITTTreeNode one;

        CCITTTreeBranch() {
        }
    }

    class CCITTTreeNode {
        CCITTTreeNode() {
        }
    }
}

