/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import com.sun.pdfview.FullScreenWindow;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPrintPage;
import com.sun.pdfview.PageChangeListener;
import com.sun.pdfview.PagePanel;
import com.sun.pdfview.ThumbPanel;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class PDFViewer
extends JFrame
implements KeyListener,
TreeSelectionListener,
PageChangeListener {
    public static final String TITLE = "SwingLabs PDF Viewer";
    PDFFile curFile;
    String docName;
    JSplitPane split;
    JScrollPane thumbscroll;
    ThumbPanel thumbs;
    PagePanel page;
    PagePanel fspp;
    int curpage = -1;
    JToggleButton fullScreenButton;
    JTextField pageField;
    FullScreenWindow fullScreen;
    OutlineNode outline = null;
    PageFormat pformat = PrinterJob.getPrinterJob().defaultPage();
    boolean doThumb = true;
    Flag docWaiter;
    PagePreparer pagePrep;
    JDialog olf;
    JMenu docMenu;
    Action openAction = new AbstractAction("Open..."){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doOpen();
        }
    };
    Action pageSetupAction = new AbstractAction("Page setup..."){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doPageSetup();
        }
    };
    Action printAction = new AbstractAction("Print...", this.getIcon("gfx/print.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doPrint();
        }
    };
    Action closeAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doClose();
        }
    };
    Action quitAction = new AbstractAction("Quit"){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doQuit();
        }
    };
    ZoomAction zoomInAction = new ZoomAction("Zoom in", this.getIcon("gfx/zoomin.gif"), 2.0);
    ZoomAction zoomOutAction = new ZoomAction("Zoom out", this.getIcon("gfx/zoomout.gif"), 0.5);
    Action zoomToolAction = new AbstractAction("", this.getIcon("gfx/zoom.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doZoomTool();
        }
    };
    Action fitInWindowAction = new AbstractAction("Fit in window", this.getIcon("gfx/fit.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doFitInWindow();
        }
    };
    ThumbAction thumbAction = new ThumbAction();
    Action fullScreenAction = new AbstractAction("Full screen", this.getIcon("gfx/fullscrn.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doFullScreen((evt.getModifiers() & 1) != 0);
        }
    };
    Action nextAction = new AbstractAction("Next", this.getIcon("gfx/next.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doNext();
        }
    };
    Action firstAction = new AbstractAction("First", this.getIcon("gfx/first.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doFirst();
        }
    };
    Action lastAction = new AbstractAction("Last", this.getIcon("gfx/last.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doLast();
        }
    };
    Action prevAction = new AbstractAction("Prev", this.getIcon("gfx/prev.gif")){

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doPrev();
        }
    };
    FileFilter pdfFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".pdf");
        }

        public String getDescription() {
            return "Choose a PDF file";
        }
    };
    private File prevDirChoice;
    PageBuilder pb = new PageBuilder();

    public Icon getIcon(String name) {
        ImageIcon icon = null;
        URL url = null;
        try {
            url = this.getClass().getResource(name);
            icon = new ImageIcon(url);
            if (icon == null) {
                System.out.println("Couldn't find " + url);
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't find " + this.getClass().getName() + "/" + name);
            e.printStackTrace();
        }
        return icon;
    }

    public PDFViewer(boolean useThumbs) {
        super(TITLE);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PDFViewer.this.doQuit();
            }
        });
        this.doThumb = useThumbs;
        this.init();
    }

    protected void init() {
        this.page = new PagePanel();
        this.page.addKeyListener(this);
        if (this.doThumb) {
            this.split = new JSplitPane(1);
            this.split.addPropertyChangeListener("dividerLocation", this.thumbAction);
            this.split.setOneTouchExpandable(true);
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll = new JScrollPane(this.thumbs, 22, 31);
            this.split.setLeftComponent(this.thumbscroll);
            this.split.setRightComponent(this.page);
            this.getContentPane().add((Component)this.split, "Center");
        } else {
            this.getContentPane().add((Component)this.page, "Center");
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton jb = new JButton(this.firstAction);
        jb.setText("");
        toolbar.add(jb);
        jb = new JButton(this.prevAction);
        jb.setText("");
        toolbar.add(jb);
        this.pageField = new JTextField("-", 3);
        this.pageField.setMaximumSize(new Dimension(45, 32));
        this.pageField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFViewer.this.doPageTyped();
            }
        });
        toolbar.add(this.pageField);
        jb = new JButton(this.nextAction);
        jb.setText("");
        toolbar.add(jb);
        jb = new JButton(this.lastAction);
        jb.setText("");
        toolbar.add(jb);
        toolbar.add(Box.createHorizontalGlue());
        this.fullScreenButton = new JToggleButton(this.fullScreenAction);
        this.fullScreenButton.setText("");
        toolbar.add(this.fullScreenButton);
        this.fullScreenButton.setEnabled(true);
        toolbar.add(Box.createHorizontalGlue());
        ButtonGroup bg = new ButtonGroup();
        JToggleButton jtb = new JToggleButton(this.zoomToolAction);
        jtb.setText("");
        bg.add(jtb);
        toolbar.add(jtb);
        jtb = new JToggleButton(this.fitInWindowAction);
        jtb.setText("");
        bg.add(jtb);
        jtb.setSelected(true);
        toolbar.add(jtb);
        toolbar.add(Box.createHorizontalGlue());
        jb = new JButton(this.printAction);
        jb.setText("");
        toolbar.add(jb);
        this.getContentPane().add((Component)toolbar, "North");
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(this.openAction);
        file.add(this.closeAction);
        file.addSeparator();
        file.add(this.pageSetupAction);
        file.add(this.printAction);
        file.addSeparator();
        file.add(this.quitAction);
        mb.add(file);
        JMenu view = new JMenu("View");
        JMenu zoom = new JMenu("Zoom");
        zoom.add(this.zoomInAction);
        zoom.add(this.zoomOutAction);
        zoom.add(this.fitInWindowAction);
        zoom.setEnabled(false);
        view.add(zoom);
        view.add(this.fullScreenAction);
        if (this.doThumb) {
            view.addSeparator();
            view.add(this.thumbAction);
        }
        mb.add(view);
        this.setJMenuBar(mb);
        this.setEnabling();
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - this.getWidth()) / 2;
        int y = (screen.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        if (SwingUtilities.isEventDispatchThread()) {
            this.show();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        PDFViewer.this.show();
                    }
                });
            }
            catch (InvocationTargetException ie) {
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public void gotoPage(int pagenum) {
        if (pagenum < 0) {
            pagenum = 0;
        } else if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        this.forceGotoPage(pagenum);
    }

    public void forceGotoPage(int pagenum) {
        if (pagenum <= 0) {
            pagenum = 0;
        } else if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        this.curpage = pagenum;
        this.pageField.setText(String.valueOf(this.curpage + 1));
        PDFPage pg = this.curFile.getPage(pagenum + 1);
        if (this.fspp != null) {
            this.fspp.showPage(pg);
            this.fspp.requestFocus();
        } else {
            this.page.showPage(pg);
            this.page.requestFocus();
        }
        if (this.doThumb) {
            this.thumbs.pageShown(pagenum);
        }
        if (this.pagePrep != null) {
            this.pagePrep.quit();
        }
        this.pagePrep = new PagePreparer(pagenum);
        this.pagePrep.start();
        this.setEnabling();
    }

    public void setEnabling() {
        boolean fileavailable;
        boolean bl = fileavailable = this.curFile != null;
        boolean pageshown = this.fspp != null ? this.fspp.getPage() != null : this.page.getPage() != null;
        boolean printable = fileavailable && this.curFile.isPrintable();
        this.pageField.setEnabled(fileavailable);
        this.printAction.setEnabled(printable);
        this.closeAction.setEnabled(fileavailable);
        this.fullScreenAction.setEnabled(pageshown);
        this.prevAction.setEnabled(pageshown);
        this.nextAction.setEnabled(pageshown);
        this.firstAction.setEnabled(fileavailable);
        this.lastAction.setEnabled(fileavailable);
        this.zoomToolAction.setEnabled(pageshown);
        this.fitInWindowAction.setEnabled(pageshown);
        this.zoomInAction.setEnabled(pageshown);
        this.zoomOutAction.setEnabled(pageshown);
    }

    public void openFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        PDFFile newfile = null;
        try {
            newfile = new PDFFile(buf);
        }
        catch (IOException ioe) {
            this.openError(file.getPath() + " doesn't appear to be a PDF file.");
            return;
        }
        this.doClose();
        this.curFile = newfile;
        this.docName = file.getName();
        this.setTitle("SwingLabs PDF Viewer: " + this.docName);
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(this.curFile);
            this.thumbs.addPageChangeListener(this);
            this.thumbscroll.getViewport().setView(this.thumbs);
            this.thumbscroll.getViewport().setBackground(Color.gray);
        }
        this.setEnabling();
        this.forceGotoPage(0);
        try {
            this.outline = this.curFile.getOutline();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (this.outline != null) {
            if (this.outline.getChildCount() > 0) {
                this.olf = new JDialog((Frame)this, "Outline");
                this.olf.setDefaultCloseOperation(0);
                this.olf.setLocation(this.getLocation());
                JTree jt = new JTree(this.outline);
                jt.setRootVisible(false);
                jt.addTreeSelectionListener(this);
                JScrollPane jsp = new JScrollPane(jt);
                this.olf.getContentPane().add(jsp);
                this.olf.pack();
                this.olf.setVisible(true);
            } else if (this.olf != null) {
                this.olf.setVisible(false);
                this.olf = null;
            }
        }
    }

    public void openError(String message) {
        JOptionPane.showMessageDialog(this.split, message, "Error opening file", 0);
    }

    public void doOpen() {
        try {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(this.prevDirChoice);
            fc.setFileFilter(this.pdfFilter);
            fc.setMultiSelectionEnabled(false);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    this.prevDirChoice = fc.getSelectedFile();
                    this.openFile(fc.getSelectedFile());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.split, "Opening files from your local disk is not available\nfrom the Java Web Start version of this program.\n", "Error opening directory", 0);
            e.printStackTrace();
        }
    }

    public void doOpen(String name) {
        try {
            this.openFile(new File(name));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doPageSetup() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        this.pformat = pjob.pageDialog(this.pformat);
    }

    public void doPrint() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        pjob.setJobName(this.docName);
        Book book = new Book();
        PDFPrintPage pages = new PDFPrintPage(this.curFile);
        book.append(pages, this.pformat, this.curFile.getNumPages());
        pjob.setPageable(book);
        if (pjob.printDialog()) {
            new PrintThread(pages, pjob).start();
        }
    }

    public void doClose() {
        if (this.thumbs != null) {
            this.thumbs.stop();
        }
        if (this.olf != null) {
            this.olf.setVisible(false);
            this.olf = null;
        }
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll.getViewport().setView(this.thumbs);
        }
        this.setFullScreenMode(false, false);
        this.page.showPage(null);
        this.curFile = null;
        this.setTitle(TITLE);
        this.setEnabling();
    }

    public void doQuit() {
        this.doClose();
        this.dispose();
        System.exit(0);
    }

    public void doZoomTool() {
        if (this.fspp == null) {
            this.page.useZoomTool(true);
        }
    }

    public void doFitInWindow() {
        if (this.fspp == null) {
            this.page.useZoomTool(false);
            this.page.setClip(null);
        }
    }

    public void doThumbs(boolean show) {
        if (show) {
            this.split.setDividerLocation(this.thumbs.getPreferredSize().width + this.thumbscroll.getVerticalScrollBar().getWidth() + 4);
        } else {
            this.split.setDividerLocation(0);
        }
    }

    public void doFullScreen(boolean force) {
        this.setFullScreenMode(this.fullScreen == null, force);
    }

    public void doZoom(double factor) {
    }

    public void doNext() {
        this.gotoPage(this.curpage + 1);
    }

    public void doPrev() {
        this.gotoPage(this.curpage - 1);
    }

    public void doFirst() {
        this.gotoPage(0);
    }

    public void doLast() {
        this.gotoPage(this.curFile.getNumPages() - 1);
    }

    public void doPageTyped() {
        int pagenum = -1;
        try {
            pagenum = Integer.parseInt(this.pageField.getText()) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        if (pagenum >= 0) {
            if (pagenum != this.curpage) {
                this.gotoPage(pagenum);
            }
        } else {
            this.pageField.setText(String.valueOf(this.curpage));
        }
    }

    public void setFullScreenMode(boolean full, boolean force) {
        if (full && this.fullScreen == null) {
            this.fullScreenAction.setEnabled(false);
            new Thread(new PerformFullScreenMode(force)).start();
            this.fullScreenButton.setSelected(true);
        } else if (!full && this.fullScreen != null) {
            this.fullScreen.close();
            this.fspp = null;
            this.fullScreen = null;
            this.gotoPage(this.curpage);
            this.fullScreenButton.setSelected(false);
        }
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean useThumbs = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-noThumb")) {
                useThumbs = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("-?")) {
                System.out.println("java com.sun.awc.PDFViewer [flags] [file]");
                System.out.println("flags: [-noThumb] [-help or -h or -?]");
                System.exit(0);
                continue;
            }
            fileName = args[i];
        }
        PDFViewer viewer = new PDFViewer(useThumbs);
        if (fileName != null) {
            viewer.doOpen(fileName);
        }
    }

    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 37) {
            this.doPrev();
        } else if (code == 39) {
            this.doNext();
        } else if (code == 38) {
            this.doPrev();
        } else if (code == 40) {
            this.doNext();
        } else if (code == 36) {
            this.doFirst();
        } else if (code == 35) {
            this.doLast();
        } else if (code == 33) {
            this.doPrev();
        } else if (code == 34) {
            this.doNext();
        } else if (code == 32) {
            this.doNext();
        } else if (code == 27) {
            this.setFullScreenMode(false, false);
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (key >= '0' && key <= '9') {
            int val = key - 48;
            this.pb.keyTyped(val);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.isAddedPath()) {
            OutlineNode node = (OutlineNode)e.getPath().getLastPathComponent();
            if (node == null) {
                return;
            }
            try {
                PDFAction action = node.getAction();
                if (action == null) {
                    return;
                }
                if (action instanceof GoToAction) {
                    PDFDestination dest = ((GoToAction)action).getDestination();
                    if (dest == null) {
                        return;
                    }
                    PDFObject page = dest.getPage();
                    if (page == null) {
                        return;
                    }
                    int pageNum = this.curFile.getPageNumber(page);
                    if (pageNum >= 0) {
                        this.gotoPage(pageNum);
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    class PageBuilder
    implements Runnable {
        int value = 0;
        long timeout;
        Thread anim;
        static final long TIMEOUT = 500L;

        PageBuilder() {
        }

        public synchronized void keyTyped(int keyval) {
            this.value = this.value * 10 + keyval;
            this.timeout = System.currentTimeMillis() + 500L;
            if (this.anim == null) {
                this.anim = new Thread(this);
                this.anim.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long then;
            long now;
            PageBuilder pageBuilder = this;
            synchronized (pageBuilder) {
                now = System.currentTimeMillis();
                then = this.timeout;
            }
            while (now < then) {
                try {
                    Thread.sleep(this.timeout - now);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                pageBuilder = this;
                synchronized (pageBuilder) {
                    now = System.currentTimeMillis();
                    then = this.timeout;
                }
            }
            pageBuilder = this;
            synchronized (pageBuilder) {
                PDFViewer.this.gotoPage(this.value - 1);
                this.anim = null;
                this.value = 0;
            }
        }
    }

    class PerformFullScreenMode
    implements Runnable {
        boolean force;

        public PerformFullScreenMode(boolean forcechoice) {
            this.force = forcechoice;
        }

        public void run() {
            PDFViewer.this.fspp = new PagePanel();
            PDFViewer.this.fspp.setBackground(Color.black);
            PDFViewer.this.page.showPage(null);
            PDFViewer.this.fullScreen = new FullScreenWindow(PDFViewer.this.fspp, this.force);
            PDFViewer.this.fspp.addKeyListener(PDFViewer.this);
            PDFViewer.this.gotoPage(PDFViewer.this.curpage);
            PDFViewer.this.fullScreenAction.setEnabled(true);
        }
    }

    class PrintThread
    extends Thread {
        PDFPrintPage ptPages;
        PrinterJob ptPjob;

        public PrintThread(PDFPrintPage pages, PrinterJob pjob) {
            this.ptPages = pages;
            this.ptPjob = pjob;
        }

        public void run() {
            try {
                this.ptPages.show(this.ptPjob);
                this.ptPjob.print();
            }
            catch (PrinterException pe) {
                JOptionPane.showMessageDialog(PDFViewer.this, "Printing Error: " + pe.getMessage(), "Print Aborted", 0);
            }
            this.ptPages.hide();
        }
    }

    class PagePreparer
    extends Thread {
        int waitforPage;
        int prepPage;

        public PagePreparer(int waitforPage) {
            this.setDaemon(true);
            this.waitforPage = waitforPage;
            this.prepPage = waitforPage + 1;
        }

        public void quit() {
            this.waitforPage = -1;
        }

        public void run() {
            PDFPage pdfPage;
            Dimension size = null;
            Rectangle2D clip = null;
            if (PDFViewer.this.fspp != null) {
                PDFViewer.this.fspp.waitForCurrentPage();
                size = PDFViewer.this.fspp.getCurSize();
                clip = PDFViewer.this.fspp.getCurClip();
            } else if (PDFViewer.this.page != null) {
                PDFViewer.this.page.waitForCurrentPage();
                size = PDFViewer.this.page.getCurSize();
                clip = PDFViewer.this.page.getCurClip();
            }
            if (this.waitforPage == PDFViewer.this.curpage && (pdfPage = PDFViewer.this.curFile.getPage(this.prepPage + 1, true)) != null && this.waitforPage == PDFViewer.this.curpage) {
                pdfPage.getImage(size.width, size.height, clip, null, true, true);
            }
        }
    }

    class ThumbAction
    extends AbstractAction
    implements PropertyChangeListener {
        boolean isOpen;

        public ThumbAction() {
            super("Hide thumbnails");
            this.isOpen = true;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int v = (Integer)evt.getNewValue();
            if (v <= 1) {
                this.isOpen = false;
                this.putValue("ActionCommandKey", "Show thumbnails");
                this.putValue("Name", "Show thumbnails");
            } else {
                this.isOpen = true;
                this.putValue("ActionCommandKey", "Hide thumbnails");
                this.putValue("Name", "Hide thumbnails");
            }
        }

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doThumbs(!this.isOpen);
        }
    }

    class ZoomAction
    extends AbstractAction {
        double zoomfactor;

        public ZoomAction(String name, double factor) {
            super(name);
            this.zoomfactor = 1.0;
            this.zoomfactor = factor;
        }

        public ZoomAction(String name, Icon icon, double factor) {
            super(name, icon);
            this.zoomfactor = 1.0;
            this.zoomfactor = factor;
        }

        public void actionPerformed(ActionEvent evt) {
            PDFViewer.this.doZoom(this.zoomfactor);
        }
    }
}

