/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:30 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_36 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 26721, "epsg", 26721,
        "NAD27 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 21N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6721\"]]");
    p = add_epsg_def (filter, first, last, 26722, "epsg", 26722,
        "NAD27 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 22N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6722\"]]");
    p = add_epsg_def (filter, first, last, 26729, "epsg", 26729,
        "NAD27 / Alabama East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9996 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alabama East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-85.83333333333333],PARAMETER[\"scale_factor\",0.99996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26729\"]]");
    p = add_epsg_def (filter, first, last, 26730, "epsg", 26730,
        "NAD27 / Alabama West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=1");
    add_proj4text (p, 1,
        "52400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alabama West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-87.5],PARAMETER[\"scale_factor\",0.999933333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"26730\"]]");
    p = add_epsg_def (filter, first, last, 26731, "epsg", 26731,
        "NAD27 / Alaska zone 1");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=32");
    add_proj4text (p, 1,
        "3.1301023611111 +k=0.9999 +x_0=5000000.001016002 +y_0=-5");
    add_proj4text (p, 2,
        "000000.001016002 +no_uoff +gamma=323.1301023611111 +datu");
    add_proj4text (p, 3,
        "m=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 1\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_center\",57],PARAMETER[\"longitude_of");
    add_srs_wkt (p, 8,
        "_center\",-133.6666666666667],PARAMETER[\"azimuth\",323.");
    add_srs_wkt (p, 9,
        "1301023611111],PARAMETER[\"rectified_grid_angle\",323.13");
    add_srs_wkt (p, 10,
        "01023611111],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",16404166.67],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",-16404166.67],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26731\"]]");
    p = add_epsg_def (filter, first, last, 26732, "epsg", 26732,
        "NAD27 / Alaska zone 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 2\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-142],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26732\"]]");
    p = add_epsg_def (filter, first, last, 26733, "epsg", 26733,
        "NAD27 / Alaska zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 3\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-146],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26733\"]]");
    p = add_epsg_def (filter, first, last, 26734, "epsg", 26734,
        "NAD27 / Alaska zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 4\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-150],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26734\"]]");
    p = add_epsg_def (filter, first, last, 26735, "epsg", 26735,
        "NAD27 / Alaska zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 5\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-154],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26735\"]]");
    p = add_epsg_def (filter, first, last, 26736, "epsg", 26736,
        "NAD27 / Alaska zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 6\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-158],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26736\"]]");
    p = add_epsg_def (filter, first, last, 26737, "epsg", 26737,
        "NAD27 / Alaska zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=213360.");
    add_proj4text (p, 1,
        "4267208534 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 7\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-162],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",700000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26737\"]]");
    p = add_epsg_def (filter, first, last, 26738, "epsg", 26738,
        "NAD27 / Alaska zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 8\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-166],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26738\"]]");
    p = add_epsg_def (filter, first, last, 26739, "epsg", 26739,
        "NAD27 / Alaska zone 9");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=182880.");
    add_proj4text (p, 1,
        "3657607315 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 9\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",54],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-170],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",600000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"26739\"]]");
    p = add_epsg_def (filter, first, last, 26740, "epsg", 26740,
        "NAD27 / Alaska zone 10");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=914401.8288036576 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 10\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",53.83333333333334],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",51.83333333333334],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",51],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-176],PARAMETER[\"false_easting\",3000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26740\"]]");
    p = add_epsg_def (filter, first, last, 26741, "epsg", 26741,
        "NAD27 / California zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone I\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",41.66666666666666],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_2\",40],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",39.33333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-122],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26741\"]]");
    p = add_epsg_def (filter, first, last, 26742, "epsg", 26742,
        "NAD27 / California zone II");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone II\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",39.83333333333334]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",38.33333333333334],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",37.66666666666666],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-122],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"26742\"]]");
    p = add_epsg_def (filter, first, last, 26743, "epsg", 26743,
        "NAD27 / California zone III");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone III\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",38.43333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",37.06666666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",36.5],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-120.5],PARAMETER[\"false_easting\",2000000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26743\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 26744, "epsg", 26744,
        "NAD27 / California zone IV");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=609601.2192024384 +y_0=0 +datum=NAD27");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone IV\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",37.25],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_2\",36],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 9,
        "\",35.33333333333334],PARAMETER[\"central_meridian\",-11");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26744\"]]");
    p = add_epsg_def (filter, first, last, 26745, "epsg", 26745,
        "NAD27 / California zone V");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone V\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",35.46666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_2\",34.03333333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",33.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-118],PARAMETER[\"false_easting\",2000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26745\"]]");
    p = add_epsg_def (filter, first, last, 26746, "epsg", 26746,
        "NAD27 / California zone VI");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=609601.");
    add_proj4text (p, 2,
        "2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VI\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",33.88333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",32.78333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",32.16666666666666],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-116.25],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 12,
        " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"26746\"]]");
    p = add_epsg_def (filter, first, last, 26747, "epsg", 26747,
        "NAD27 / California zone VII (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666");
    add_proj4text (p, 1,
        "667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=1276106.450596901 +y_0=127079.524511049 +datum=NAD27");
    add_proj4text (p, 3,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VII (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",34.4");
    add_srs_wkt (p, 8,
        "1666666666666],PARAMETER[\"standard_parallel_2\",33.8666");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"latitude_of_origin\",34.13333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"central_meridian\",-118.333333333333");
    add_srs_wkt (p, 11,
        "3],PARAMETER[\"false_easting\",4186692.58],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",416926.74],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 13,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26747\"]]");
    p = add_epsg_def (filter, first, last, 26748, "epsg", 26748,
        "NAD27 / Arizona East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-110.1666666666667],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26748\"]]");
    p = add_epsg_def (filter, first, last, 26749, "epsg", 26749,
        "NAD27 / Arizona Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-111.9166666666667],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26749\"]]");
    p = add_epsg_def (filter, first, last, 26750, "epsg", 26750,
        "NAD27 / Arizona West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-113.75],PARAMETER[\"scale_factor\",0.999933333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"26750\"]]");
    p = add_epsg_def (filter, first, last, 26751, "epsg", 26751,
        "NAD27 / Arkansas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",36.23333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",34.93333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",34.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-92],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26751\"]]");
    p = add_epsg_def (filter, first, last, 26752, "epsg", 26752,
        "NAD27 / Arkansas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",34.76666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",33.3],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",32.66666666666666],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-92],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26752\"]]");
    p = add_epsg_def (filter, first, last, 26753, "epsg", 26753,
        "NAD27 / Colorado North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.71666666666667 +lat_2=40.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",39.71666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",40.78333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",39.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-105.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"26753\"]]");
    p = add_epsg_def (filter, first, last, 26754, "epsg", 26754,
        "NAD27 / Colorado Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +datum=");
    add_proj4text (p, 2,
        "NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",39.75],PARAMETER[\"sta");
    add_srs_wkt (p, 8,
        "ndard_parallel_2\",38.45],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 9,
        "\",37.83333333333334],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 10,
        "5.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 12,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26754\"]]");
    p = add_epsg_def (filter, first, last, 26755, "epsg", 26755,
        "NAD27 / Colorado South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",38.43333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",37.23333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",36.66666666666666],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-105.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"26755\"]]");
    p = add_epsg_def (filter, first, last, 26756, "epsg", 26756,
        "NAD27 / Connecticut");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=182880.3657607315 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Connecticut\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",41.86666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",41.2],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",40.83333333333334],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",-72.75],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26756\"]]");
    p = add_epsg_def (filter, first, last, 26757, "epsg", 26757,
        "NAD27 / Delaware");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Delaware\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "7\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",38],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
        "5.41666666666667],PARAMETER[\"scale_factor\",0.999995],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26757\"]]");
    p = add_epsg_def (filter, first, last, 26758, "epsg", 26758,
        "NAD27 / Florida East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",24.33333333333333],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-81],PARAMETER[\"scale_factor\",0.9999411");
    add_srs_wkt (p, 9,
        "77],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26758\"]]");
    p = add_epsg_def (filter, first, last, 26759, "epsg", 26759,
        "NAD27 / Florida West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",24.33333333333333],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-82],PARAMETER[\"scale_factor\",0.9999411");
    add_srs_wkt (p, 9,
        "77],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26759\"]]");
    p = add_epsg_def (filter, first, last, 26760, "epsg", 26760,
        "NAD27 / Florida North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",30.75],PARAMETER[\"stan");
    add_srs_wkt (p, 8,
        "dard_parallel_2\",29.58333333333333],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",29],PARAMETER[\"central_meridian\",-84.5],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26760\"]]");
    p = add_epsg_def (filter, first, last, 26766, "epsg", 26766,
        "NAD27 / Georgia East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Georgia East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-82.16666666666667],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26766\"]]");
    p = add_epsg_def (filter, first, last, 26767, "epsg", 26767,
        "NAD27 / Georgia West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Georgia West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-84.16666666666667],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26767\"]]");
    p = add_epsg_def (filter, first, last, 26768, "epsg", 26768,
        "NAD27 / Idaho East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=152400.3048006096 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho East\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-112.1666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999947368],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26768\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 26769, "epsg", 26769,
        "NAD27 / Idaho Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=152400.3048006096 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",41.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-114],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "947368],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26769\"]]");
    p = add_epsg_def (filter, first, last, 26770, "epsg", 26770,
        "NAD27 / Idaho West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +u");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho West\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-115.75],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "933333],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26770\"]]");
    p = add_epsg_def (filter, first, last, 26771, "epsg", 26771,
        "NAD27 / Illinois East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=152400.3048006096 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Illinois East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",36.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-88.33333333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999975],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26771\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 26772, "epsg", 26772,
        "NAD27 / Illinois West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Illinois West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",36.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-90.16666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999941177],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 11,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26772\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 26773, "epsg", 26773,
        "NAD27 / Indiana East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Indiana East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-85.66666666666667],PARAMETER[\"scale_factor\",0.999966");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26773\"]]");
    p = add_epsg_def (filter, first, last, 26774, "epsg", 26774,
        "NAD27 / Indiana West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Indiana West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-87.08333333333333],PARAMETER[\"scale_factor\",0.999966");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26774\"]]");
    p = add_epsg_def (filter, first, last, 26775, "epsg", 26775,
        "NAD27 / Iowa North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",43.26666666666667],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",42.06666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",41.5],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",-93.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26775\"]]");
    p = add_epsg_def (filter, first, last, 26776, "epsg", 26776,
        "NAD27 / Iowa South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",41.78333333333333],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",40.61666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",40],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-93.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26776\"]]");
    p = add_epsg_def (filter, first, last, 26777, "epsg", 26777,
        "NAD27 / Kansas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",39.78333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",38.71666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",38.33333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-98],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"267");
    add_srs_wkt (p, 14,
        "77\"]]");
    p = add_epsg_def (filter, first, last, 26778, "epsg", 26778,
        "NAD27 / Kansas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",38.56666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",37.26666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",36.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-98.5],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "6778\"]]");
    p = add_epsg_def (filter, first, last, 26779, "epsg", 26779,
        "NAD27 / Kentucky North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",37.96666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",38.96666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",37.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-84.25],PARAMETER[\"false_easting\",2000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26779\"]]");
    p = add_epsg_def (filter, first, last, 26780, "epsg", 26780,
        "NAD27 / Kentucky South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.73333333333333 +lat_2=37.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",36.73333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",37.93333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",36.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-85.75],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"26780\"]]");
    p = add_epsg_def (filter, first, last, 26781, "epsg", 26781,
        "NAD27 / Louisiana North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.16666666666667 +lat_2=32.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=30.66666666666667 +lon_0=-92.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",31.16666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",32.66666666666666],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",30.66666666666667],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-92.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"26781\"]]");
    p = add_epsg_def (filter, first, last, 26782, "epsg", 26782,
        "NAD27 / Louisiana South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29.3 +lat_2=30.7 +lat_0=28.666666666666");
    add_proj4text (p, 1,
        "67 +lon_0=-91.33333333333333 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",29.3],PARAMETER[\"stan");
    add_srs_wkt (p, 8,
        "dard_parallel_2\",30.7],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",28.66666666666667],PARAMETER[\"central_meridian\",-91.3");
    add_srs_wkt (p, 10,
        "3333333333333],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26782\"]]");
    p = add_epsg_def (filter, first, last, 26783, "epsg", 26783,
        "NAD27 / Maine East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine East\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",43.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-68.5],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26783\"]]");
    p = add_epsg_def (filter, first, last, 26784, "epsg", 26784,
        "NAD27 / Maine West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine West\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",42.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-70.16666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999966667],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26784\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 26785, "epsg", 26785,
        "NAD27 / Maryland");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.3 +lat_2=39.45 +lat_0=37.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-77 +x_0=243840.4876809754 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maryland\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"standard_parallel_1\",38.3],PARAMETER[\"standard_p");
    add_srs_wkt (p, 8,
        "arallel_2\",39.45],PARAMETER[\"latitude_of_origin\",37.8");
    add_srs_wkt (p, 9,
        "3333333333334],PARAMETER[\"central_meridian\",-77],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",800000.0000000002],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 12,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26785\"]]");
    p = add_epsg_def (filter, first, last, 26786, "epsg", 26786,
        "NAD27 / Massachusetts Mainland");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.71666666666667 +lat_2=42.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-71.5 +x_0=182880.3657607315 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Mainland\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",41.7166666666666");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"standard_parallel_2\",42.68333333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",41],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-71.5],PARAMETER[\"false_easting\",600000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26786\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 26787, "epsg", 26787,
        "NAD27 / Massachusetts Island");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.28333333333333 +lat_2=41.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=60960.12192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Island\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",41.2833333333333");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"standard_parallel_2\",41.48333333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",41],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-70.5],PARAMETER[\"false_easting\",200000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26787\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 26791, "epsg", 26791,
        "NAD27 / Minnesota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.03333333333333 +lat_2=48.63333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",47.03333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",48.63333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",46.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-93.1],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26791\"]]");
    p = add_epsg_def (filter, first, last, 26792, "epsg", 26792,
        "NAD27 / Minnesota Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.61666666666667 +lat_2=47.05 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota Central\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",45.61666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_2\",47.05],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",45],PARAMETER[\"central_meridian\",-94.");
    add_srs_wkt (p, 10,
        "25],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26792\"]]");
    p = add_epsg_def (filter, first, last, 26793, "epsg", 26793,
        "NAD27 / Minnesota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.78333333333333 +lat_2=45.21666666666");
    add_proj4text (p, 1,
        "667 +lat_0=43 +lon_0=-94 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",43.78333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",45.21666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",43],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-94],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26793\"]]");
    p = add_epsg_def (filter, first, last, 26794, "epsg", 26794,
        "NAD27 / Mississippi East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.66666666666667 +lon_0=-88.83333333");
    add_proj4text (p, 1,
        "333333 +k=0.99996 +x_0=152400.3048006096 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Mississippi East\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",29.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-88.83333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.99996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26794\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 26795, "epsg", 26795,
        "NAD27 / Mississippi West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Mississippi West\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",30.5],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-90.33333333333333],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99941177],PARAMETER[\"false_easting\",500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 11,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26795\"]]");
    p = add_epsg_def (filter, first, last, 26796, "epsg", 26796,
        "NAD27 / Missouri East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",35.83333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-90.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9933333],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26796\"]]");
    p = add_epsg_def (filter, first, last, 26797, "epsg", 26797,
        "NAD27 / Missouri Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",35.83333333333334],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-92.5],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99933333],PARAMETER[\"false_easting\",500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 11,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26797\"]]");
    p = add_epsg_def (filter, first, last, 26798, "epsg", 26798,
        "NAD27 / Missouri West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",36.16666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-94.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9941177],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26798\"]]");
    p = add_epsg_def (filter, first, last, 26799, "epsg", 26799,
        "NAD27 / California zone VII");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666");
    add_proj4text (p, 1,
        "667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=1276106.450596901 +y_0=1268253.006858014 +datum=NAD2");
    add_proj4text (p, 3,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VII\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",34.41666666666666]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",33.86666666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",34.13333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-118.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",4186692.58],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",4160926.74],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"26799\"]]");
    p = add_epsg_def (filter, first, last, 26801, "epsg", 26801,
        "NAD Michigan / Michigan East (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99942857 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548");
    add_proj4text (p, 2,
        "896 +b=6356826.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan East (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866 Michigan\",6378450.047548896,294.97869716");
    add_srs_wkt (p, 3,
        "46739,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",41.5],PARAMETER[\"central_meridian\",-83.66666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.999942857],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"26801\"]]");
    p = add_epsg_def (filter, first, last, 26802, "epsg", 26802,
        "NAD Michigan / Michigan Old Central (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=63568");
    add_proj4text (p, 2,
        "26.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan Old Central (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1866 Michigan\",6378450.047548896,294.9");
    add_srs_wkt (p, 3,
        "786971646739,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4268\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",41.5],PARAMETER[\"central_meridian\",-85.75],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",0.999909091],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"26802\"]]");
    p = add_epsg_def (filter, first, last, 26803, "epsg", 26803,
        "NAD Michigan / Michigan West (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=63568");
    add_proj4text (p, 2,
        "26.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan West (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866 Michigan\",6378450.047548896,294.97869716");
    add_srs_wkt (p, 3,
        "46739,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",41.5],PARAMETER[\"central_meridian\",-88.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.999909091],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"26803\"]]");
    p = add_epsg_def (filter, first, last, 26811, "epsg", 26811,
        "NAD Michigan / Michigan North (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.48333333333333 +lat_2=47.08333333333");
    add_proj4text (p, 1,
        "334 +lat_0=44.78333333333333 +lon_0=-87 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 ");
    add_proj4text (p, 3,
        "+units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan North (deprecated)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866 Michigan\",6378450.047548896,294.9786971");
    add_srs_wkt (p, 3,
        "646739,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_");
    add_srs_wkt (p, 8,
        "parallel_1\",45.48333333333333],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_2\",47.08333333333334],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",44.78333333333333],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 11,
        "-87],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26811\"]]");
    p = add_epsg_def (filter, first, last, 26812, "epsg", 26812,
        "NAD Michigan / Michigan Central (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.18333333333333 +lat_2=45.7 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.33333333333333 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +a=6378450.047548896 +b=6356826.62148844");
    add_proj4text (p, 3,
        "4 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan Central (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Clarke 1866 Michigan\",6378450.047548896,294.97869");
    add_srs_wkt (p, 3,
        "71646739,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 8,
        "_parallel_1\",44.18333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_2\",45.7],PARAMETER[\"latitude_of_origin\",43.316");
    add_srs_wkt (p, 10,
        "66666666667],PARAMETER[\"central_meridian\",-84.33333333");
    add_srs_wkt (p, 11,
        "333333],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26812\"]]");
    p = add_epsg_def (filter, first, last, 26813, "epsg", 26813,
        "NAD Michigan / Michigan South (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.1 +lat_2=43.66666666666666 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.33333333333333 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan South (deprecated)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866 Michigan\",6378450.047548896,294.9786971");
    add_srs_wkt (p, 3,
        "646739,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_");
    add_srs_wkt (p, 8,
        "parallel_1\",42.1],PARAMETER[\"standard_parallel_2\",43.");
    add_srs_wkt (p, 9,
        "66666666666666],PARAMETER[\"latitude_of_origin\",41.5],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"central_meridian\",-84.33333333333333],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",2000000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"26813\"]]");
    p = add_epsg_def (filter, first, last, 26814, "epsg", 26814,
        "NAD83 / Maine East (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East (ftUS) (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"626");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "3.66666666666666],PARAMETER[\"central_meridian\",-68.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",300000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26814\"]]");
    p = add_epsg_def (filter, first, last, 26815, "epsg", 26815,
        "NAD83 / Maine West (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +datum=NAD83 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West (ftUS) (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"626");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "2.83333333333334],PARAMETER[\"central_meridian\",-70.166");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"scale_factor\",0.999966667],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",900000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26815\"]]");
    p = add_epsg_def (filter, first, last, 26819, "epsg", 26819,
        "NAD83 / Minnesota North (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +datum=NAD83 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North (ftUS) (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_");
    add_srs_wkt (p, 8,
        "parallel_1\",48.63333333333333],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_2\",47.03333333333333],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",46.5],PARAMETER[\"central_meridian\",-93.1],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",800000.0000101601],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",99999.99998984],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"26819\"]]");
    p = add_epsg_def (filter, first, last, 26820, "epsg", 26820,
        "NAD83 / Minnesota Central (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central (ftUS) (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 8,
        "_parallel_1\",47.05],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 9,
        "5.61666666666667],PARAMETER[\"latitude_of_origin\",45],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"central_meridian\",-94.25],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",800000.0000101601],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",99999.99998984],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"26820\"]]");
    p = add_epsg_def (filter, first, last, 26821, "epsg", 26821,
        "NAD83 / Minnesota South (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South (ftUS) (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_");
    add_srs_wkt (p, 8,
        "parallel_1\",45.21666666666667],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_2\",43.78333333333333],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",43],PARAMETER[\"central_meridian\",-94],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",800000.0000101601],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",99999.99998984],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"26821\"]]");
    p = add_epsg_def (filter, first, last, 26822, "epsg", 26822,
        "NAD83 / Nebraska (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +datum=NAD83 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska (ftUS) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",43],PARAMETER[\"standard_parallel_2\",40],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",39.83333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-100],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00.0000101601],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26822\"]]");
    p = add_epsg_def (filter, first, last, 26823, "epsg", 26823,
        "NAD83 / West Virginia North (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia North (ftUS) (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",40.25],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",39],PARAMETER[\"latitude_of_origin\",38.5],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-79.5],PARAMETER[\"false_easting\",19");
    add_srs_wkt (p, 11,
        "68500],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"26823\"]]");
    p = add_epsg_def (filter, first, last, 26824, "epsg", 26824,
        "NAD83 / West Virginia South (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +datum=NAD8");
    add_proj4text (p, 2,
        "3 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia South (ftUS) (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",38.88333333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",37.48333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",37],PARAMETER[\"central_meridian\",-81],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",1968500],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26");
    add_srs_wkt (p, 14,
        "824\"]]");
    p = add_epsg_def (filter, first, last, 26825, "epsg", 26825,
        "NAD83(HARN) / Maine East (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine East (ftUS) (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-68.5],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",300000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"26825\"]]");
    p = add_epsg_def (filter, first, last, 26826, "epsg", 26826,
        "NAD83(HARN) / Maine West (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine West (ftUS) (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",42.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-70.16666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.999966667],PARAMETER[\"false_easting\",900000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26826\"]]");
    p = add_epsg_def (filter, first, last, 26830, "epsg", 26830,
        "NAD83(HARN) / Minnesota North (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota North (ftUS) (deprecate");
    add_srs_wkt (p, 1,
        "d)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_");
    add_srs_wkt (p, 2,
        "Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",48.63333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",47.03333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",46.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 11,
        "eridian\",-93.1],PARAMETER[\"false_easting\",800000.0000");
    add_srs_wkt (p, 12,
        "101601],PARAMETER[\"false_northing\",99999.99998984],UNI");
    add_srs_wkt (p, 13,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26830\"]]");
    p = add_epsg_def (filter, first, last, 26831, "epsg", 26831,
        "NAD83(HARN) / Minnesota Central (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota Central (ftUS) (depreca");
    add_srs_wkt (p, 1,
        "ted)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accurac");
    add_srs_wkt (p, 2,
        "y_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",47.05],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",45.61666666666667],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",45],PARAMETER[\"central_meridian\",-94");
    add_srs_wkt (p, 11,
        ".25],PARAMETER[\"false_easting\",800000.0000101601],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",99999.99998984],UNIT[\"metre\",");
    add_srs_wkt (p, 13,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26831\"]]");
    p = add_epsg_def (filter, first, last, 26832, "epsg", 26832,
        "NAD83(HARN) / Minnesota South (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota South (ftUS) (deprecate");
    add_srs_wkt (p, 1,
        "d)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_");
    add_srs_wkt (p, 2,
        "Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",45.21666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",43.78333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",43],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-94],PARAMETER[\"false_easting\",800000.00001016");
    add_srs_wkt (p, 12,
        "01],PARAMETER[\"false_northing\",99999.99998984],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26832\"]]");
    p = add_epsg_def (filter, first, last, 26833, "epsg", 26833,
        "NAD83(HARN) / Nebraska (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nebraska (ftUS) (deprecated)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referen");
    add_srs_wkt (p, 2,
        "ce_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_1\",43],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_2\",40],PARAMETER[\"latitude_of_origin\",39.8333");
    add_srs_wkt (p, 10,
        "3333333334],PARAMETER[\"central_meridian\",-100],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",500000.0000101601],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"26833\"]]");
    p = add_epsg_def (filter, first, last, 26834, "epsg", 26834,
        "NAD83(HARN) / West Virginia North (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia North (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accur");
    add_srs_wkt (p, 2,
        "acy_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",40.25],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",39],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",38.5],PARAMETER[\"central_meridian\",-79.5],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",1968500],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26");
    add_srs_wkt (p, 14,
        "834\"]]");
    p = add_epsg_def (filter, first, last, 26835, "epsg", 26835,
        "NAD83(HARN) / West Virginia South (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia South (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accur");
    add_srs_wkt (p, 2,
        "acy_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",38.8833333333333");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"standard_parallel_2\",37.48333333333333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"latitude_of_origin\",37],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-81],PARAMETER[\"false_easting\",1968500],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"26835\"]]");
    p = add_epsg_def (filter, first, last, 26836, "epsg", 26836,
        "NAD83(NSRS2007) / Maine East (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine East (ftUS) (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4759\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",43.66666666666666],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-68.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"26836\"]]");
    p = add_epsg_def (filter, first, last, 26837, "epsg", 26837,
        "NAD83(NSRS2007) / Maine West (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine West (ftUS) (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4759\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",42.83333333333334],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-70.16666666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",0.999966667],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",900000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26837\"]]");
    p = add_epsg_def (filter, first, last, 26841, "epsg", 26841,
        "NAD83(NSRS2007) / Minnesota North (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota North (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Nation");
    add_srs_wkt (p, 2,
        "al_Spatial_Reference_System_2007\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 4,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM");
    add_srs_wkt (p, 5,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 6,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",48.6");
    add_srs_wkt (p, 9,
        "3333333333333],PARAMETER[\"standard_parallel_2\",47.0333");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"latitude_of_origin\",46.5],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"central_meridian\",-93.1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
        "ng\",800000.0000101601],PARAMETER[\"false_northing\",999");
    add_srs_wkt (p, 13,
        "99.99998984],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 14,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"26841\"]]");
    p = add_epsg_def (filter, first, last, 26842, "epsg", 26842,
        "NAD83(NSRS2007) / Minnesota Central (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota Central (ftUS) (dep");
    add_srs_wkt (p, 1,
        "recated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Nati");
    add_srs_wkt (p, 2,
        "onal_Spatial_Reference_System_2007\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",47");
    add_srs_wkt (p, 9,
        ".05],PARAMETER[\"standard_parallel_2\",45.61666666666667");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",45],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-94.25],PARAMETER[\"false_easting\",800000");
    add_srs_wkt (p, 12,
        ".0000101601],PARAMETER[\"false_northing\",99999.99998984");
    add_srs_wkt (p, 13,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26842\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def (filter, first, last, 26843, "epsg", 26843,
        "NAD83(NSRS2007) / Minnesota South (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota South (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Nation");
    add_srs_wkt (p, 2,
        "al_Spatial_Reference_System_2007\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 4,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM");
    add_srs_wkt (p, 5,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 6,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45.2");
    add_srs_wkt (p, 9,
        "1666666666667],PARAMETER[\"standard_parallel_2\",43.7833");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"latitude_of_origin\",43],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"central_meridian\",-94],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",800000.0000101601],PARAMETER[\"false_northing\",99999.9");
    add_srs_wkt (p, 13,
        "9998984],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "26843\"]]");
    p = add_epsg_def (filter, first, last, 26844, "epsg", 26844,
        "NAD83(NSRS2007) / Nebraska (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Nebraska (ftUS) (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",43],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",40],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 10,
        "igin\",39.83333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-100],PARAMETER[\"false_easting\",500000.0000101601],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"26844\"]]");
    p = add_epsg_def (filter, first, last, 26845, "epsg", 26845,
        "NAD83(NSRS2007) / West Virginia North (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia North (ftUS) (d");
    add_srs_wkt (p, 1,
        "eprecated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Na");
    add_srs_wkt (p, 2,
        "tional_Spatial_Reference_System_2007\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 9,
        "0.25],PARAMETER[\"standard_parallel_2\",39],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",38.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-79.5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26845\"]]");
    p = add_epsg_def (filter, first, last, 26846, "epsg", 26846,
        "NAD83(NSRS2007) / West Virginia South (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia South (ftUS) (d");
    add_srs_wkt (p, 1,
        "eprecated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Na");
    add_srs_wkt (p, 2,
        "tional_Spatial_Reference_System_2007\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "8.88333333333333],PARAMETER[\"standard_parallel_2\",37.4");
    add_srs_wkt (p, 10,
        "8333333333333],PARAMETER[\"latitude_of_origin\",37],PARA");
    add_srs_wkt (p, 11,
        "METER[\"central_meridian\",-81],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 12,
        "g\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 13,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26846\"]]");
    p = add_epsg_def (filter, first, last, 26847, "epsg", 26847,
        "NAD83 / Maine East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000.0000000001 +y_0=0 +datum=NAD83 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",43.66666666666");
    add_srs_wkt (p, 8,
        "666],PARAMETER[\"central_meridian\",-68.5],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",984250");
    add_srs_wkt (p, 10,
        ".0000000002],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"26847\"]]");
    p = add_epsg_def (filter, first, last, 26848, "epsg", 26848,
        "NAD83 / Maine West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +datum=NAD83 +u");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",42.83333333333");
    add_srs_wkt (p, 8,
        "334],PARAMETER[\"central_meridian\",-70.16666666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.999966667],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",2952750],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"26848\"]]");
    p = add_epsg_def (filter, first, last, 26849, "epsg", 26849,
        "NAD83 / Minnesota North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101599 +y_0=99999.99998983997 +datum=NAD83 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 8,
        "8.63333333333333],PARAMETER[\"standard_parallel_2\",47.0");
    add_srs_wkt (p, 9,
        "3333333333333],PARAMETER[\"latitude_of_origin\",46.5],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-93.1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",2624666.6667],PARAMETER[\"false_northing\",32808");
    add_srs_wkt (p, 12,
        "3.3333],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"26849\"]]");
    p = add_epsg_def (filter, first, last, 26850, "epsg", 26850,
        "NAD83 / Minnesota Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.999989");
    add_proj4text (p, 2,
        "83997 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",47.05],PARAMETER[\"standard_parallel_2\",45.61666666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"latitude_of_origin\",45],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-94.25],PARAMETER[\"false_easting\",262");
    add_srs_wkt (p, 11,
        "4666.6667],PARAMETER[\"false_northing\",328083.3333],UNI");
    add_srs_wkt (p, 12,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"26850\"]]");
    p = add_epsg_def (filter, first, last, 26851, "epsg", 26851,
        "NAD83 / Minnesota South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=999");
    add_proj4text (p, 2,
        "99.99998983997 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 8,
        "5.21666666666667],PARAMETER[\"standard_parallel_2\",43.7");
    add_srs_wkt (p, 9,
        "8333333333333],PARAMETER[\"latitude_of_origin\",43],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-94],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2624666.6667],PARAMETER[\"false_northing\",328083.33");
    add_srs_wkt (p, 12,
        "33],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"26851\"]]");
    p = add_epsg_def (filter, first, last, 26852, "epsg", 26852,
        "NAD83 / Nebraska (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +datum=NAD83 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",43],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",40],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",39.83333333333334],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-100],PARAMETER[\"false_easting\",1640416.6667],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26852\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

