/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:30 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_31 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 6567, "epsg", 6567,
        "NAD83(2011) / Rhode Island");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=100000 +y_0=0 +ellps=GRS80 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Rhode Island\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",41.08333333");
    add_srs_wkt (p, 8,
        "333334],PARAMETER[\"central_meridian\",-71.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.99999375],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",100000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6567\"]]");
    p = add_epsg_def (filter, first, last, 6568, "epsg", 6568,
        "NAD83(2011) / Rhode Island (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Rhode Island (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.0");
    add_srs_wkt (p, 8,
        "8333333333334],PARAMETER[\"central_meridian\",-71.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.99999375],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",328083.3333],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6568\"]]");
    p = add_epsg_def (filter, first, last, 6569, "epsg", 6569,
        "NAD83(2011) / South Carolina");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / South Carolina\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 8,
        "4.83333333333334],PARAMETER[\"standard_parallel_2\",32.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",31.83333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-81],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",609600],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6569\"]]");
    p = add_epsg_def (filter, first, last, 6570, "epsg", 6570,
        "NAD83(2011) / South Carolina (ft)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / South Carolina (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",34.83333333333334],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",32.5],PARAMETER[\"latitude_of_origin\",31.8333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"central_meridian\",-81],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",2000000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6570\"]]");
    p = add_epsg_def (filter, first, last, 6571, "epsg", 6571,
        "NAD83(2011) / South Dakota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / South Dakota North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",45.68333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",44.41666666666666],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 10,
        "83333333333334],PARAMETER[\"central_meridian\",-100],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",600000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6571\"]]");
    p = add_epsg_def (filter, first, last, 6572, "epsg", 6572,
        "NAD83(2011) / South Dakota North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / South Dakota North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",45.68333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_2\",44.41666666666666],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 10,
        "n\",43.83333333333334],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6572\"]]");
    p = add_epsg_def (filter, first, last, 6573, "epsg", 6573,
        "NAD83(2011) / South Dakota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / South Dakota South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",44.4],PARAMETER[\"standard_parallel_2\",42.833333333");
    add_srs_wkt (p, 9,
        "33334],PARAMETER[\"latitude_of_origin\",42.3333333333333");
    add_srs_wkt (p, 10,
        "4],PARAMETER[\"central_meridian\",-100.3333333333333],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",600000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6573\"]]");
    p = add_epsg_def (filter, first, last, 6574, "epsg", 6574,
        "NAD83(2011) / South Dakota South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / South Dakota South (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",44.4],PARAMETER[\"standard_parallel_2\",42.83");
    add_srs_wkt (p, 9,
        "333333333334],PARAMETER[\"latitude_of_origin\",42.333333");
    add_srs_wkt (p, 10,
        "33333334],PARAMETER[\"central_meridian\",-100.3333333333");
    add_srs_wkt (p, 11,
        "333],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6574\"]]");
    p = add_epsg_def (filter, first, last, 6575, "epsg", 6575,
        "NAD83(2011) / Tennessee");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Tennessee\",GEOGCS[\"NAD83(2011)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_National_Spatial_Reference_System_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.4166");
    add_srs_wkt (p, 8,
        "6666666666],PARAMETER[\"standard_parallel_2\",35.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",34.33333333333334],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-86],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",600000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6575\"]]");
    p = add_epsg_def (filter, first, last, 6576, "epsg", 6576,
        "NAD83(2011) / Tennessee (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Tennessee (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",36.41666666666666],PARAMETER[\"standard_parallel_2\",35");
    add_srs_wkt (p, 9,
        ".25],PARAMETER[\"latitude_of_origin\",34.33333333333334]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"central_meridian\",-86],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6576\"]]");
    p = add_epsg_def (filter, first, last, 6577, "epsg", 6577,
        "NAD83(2011) / Texas Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=700000 +y_0=3000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas Central\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",31");
    add_srs_wkt (p, 8,
        ".88333333333333],PARAMETER[\"standard_parallel_2\",30.11");
    add_srs_wkt (p, 9,
        "666666666667],PARAMETER[\"latitude_of_origin\",29.666666");
    add_srs_wkt (p, 10,
        "66666667],PARAMETER[\"central_meridian\",-100.3333333333");
    add_srs_wkt (p, 11,
        "333],PARAMETER[\"false_easting\",700000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6577\"]]");
    p = add_epsg_def (filter, first, last, 6578, "epsg", 6578,
        "NAD83(2011) / Texas Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas Central (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",31.88333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",30.11666666666667],PARAMETER[\"latitude_of_origin\",29.");
    add_srs_wkt (p, 10,
        "66666666666667],PARAMETER[\"central_meridian\",-100.3333");
    add_srs_wkt (p, 11,
        "333333333],PARAMETER[\"false_easting\",2296583.333],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",9842500.000000002],UNIT[\"US su");
    add_srs_wkt (p, 13,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"6578\"]]");
    p = add_epsg_def (filter, first, last, 6579, "epsg", 6579,
        "NAD83(2011) / Texas Centric Albers Equal Area");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=6000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas Centric Albers Equal Area\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_");
    add_srs_wkt (p, 8,
        "parallel_1\",27.5],PARAMETER[\"standard_parallel_2\",35]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"latitude_of_center\",18],PARAMETER[\"longit");
    add_srs_wkt (p, 10,
        "ude_of_center\",-100],PARAMETER[\"false_easting\",150000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",6000000],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6579\"]]");
    p = add_epsg_def (filter, first, last, 6580, "epsg", 6580,
        "NAD83(2011) / Texas Centric Lambert Conformal");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=5000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas Centric Lambert Conformal\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",27.5],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",35],PARAMETER[\"latitude_of_origin\",18],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-100],PARAMETER[\"false_easting\",15000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",5000000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6580\"]]");
    p = add_epsg_def (filter, first, last, 6581, "epsg", 6581,
        "NAD83(2011) / Texas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas North\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.");
    add_srs_wkt (p, 8,
        "18333333333333],PARAMETER[\"standard_parallel_2\",34.65]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"latitude_of_origin\",34],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",-101.5],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6581\"]]");
    p = add_epsg_def (filter, first, last, 6582, "epsg", 6582,
        "NAD83(2011) / Texas North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.99989");
    add_proj4text (p, 2,
        "83998 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas North (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",36.18333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",34.65],PARAMETER[\"latitude_of_origin\",34],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-101.5],PARAMETER[\"false_easting\",6");
    add_srs_wkt (p, 11,
        "56166.667],PARAMETER[\"false_northing\",3280833.333],UNI");
    add_srs_wkt (p, 12,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6582\"]]");
    p = add_epsg_def (filter, first, last, 6583, "epsg", 6583,
        "NAD83(2011) / Texas North Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas North Central\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",33.96666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",32.13333333333333],PARAMETER[\"latitude_of_origin\",31.");
    add_srs_wkt (p, 10,
        "66666666666667],PARAMETER[\"central_meridian\",-98.5],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",600000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"6583\"]]");
    p = add_epsg_def (filter, first, last, 6584, "epsg", 6584,
        "NAD83(2011) / Texas North Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000.0001016 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas North Central (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",33.96666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_2\",32.13333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 10,
        "n\",31.66666666666667],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 11,
        "8.5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",6561666.667],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 13,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6584\"]]");
    p = add_epsg_def (filter, first, last, 6585, "epsg", 6585,
        "NAD83(2011) / Texas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y");
    add_proj4text (p, 2,
        "_0=5000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas South\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",27.");
    add_srs_wkt (p, 8,
        "83333333333333],PARAMETER[\"standard_parallel_2\",26.166");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"latitude_of_origin\",25.6666666");
    add_srs_wkt (p, 10,
        "6666667],PARAMETER[\"central_meridian\",-98.5],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",300000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6585\"]]");
    p = add_epsg_def (filter, first, last, 6586, "epsg", 6586,
        "NAD83(2011) / Texas South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.00");
    add_proj4text (p, 2,
        "00000001 +y_0=5000000.0001016 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas South (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "1\",27.83333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",26.16666666666667],PARAMETER[\"latitude_of_origin\",25.");
    add_srs_wkt (p, 10,
        "66666666666667],PARAMETER[\"central_meridian\",-98.5],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",984250.0000000002],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",16404166.667],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 13,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6586\"]]");
    p = add_epsg_def (filter, first, last, 6587, "epsg", 6587,
        "NAD83(2011) / Texas South Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=4000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas South Central\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",30.28333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",28.38333333333333],PARAMETER[\"latitude_of_origin\",27.");
    add_srs_wkt (p, 10,
        "83333333333333],PARAMETER[\"central_meridian\",-99],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",600000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",4000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"6587\"]]");
    p = add_epsg_def (filter, first, last, 6588, "epsg", 6588,
        "NAD83(2011) / Texas South Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=3999999.9998984 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Texas South Central (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",30.28333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_2\",28.38333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 10,
        "n\",27.83333333333333],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 11,
        "9],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",13123333.333],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 13,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6588\"]]");
    p = add_epsg_def (filter, first, last, 6589, "epsg", 6589,
        "NAD83(2011) / Vermont");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Vermont\",GEOGCS[\"NAD83(2011)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"NAD83_National_Spatial_Reference_System_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",42.5],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-72.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".999964286],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"6589\"]]");
    p = add_epsg_def (filter, first, last, 6590, "epsg", 6590,
        "NAD83(2011) / Vermont (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Vermont (ftUS)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",42.5],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-72.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.999964286],PARAMETER[\"false_easting\",1640416.66");
    add_srs_wkt (p, 10,
        "67],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 11,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"659");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def (filter, first, last, 6591, "epsg", 6591,
        "NAD83(2011) / Virginia Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Virginia Lambert\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",37],PARAMETER[\"standard_parallel_2\",39.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",36],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "-79.5],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6591\"]]");
    p = add_epsg_def (filter, first, last, 6592, "epsg", 6592,
        "NAD83(2011) / Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Virginia North\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 8,
        "9.2],PARAMETER[\"standard_parallel_2\",38.03333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",37.66666666666666],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-78.5],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",3500000],PARAMETER[\"false_northing\",2000000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6592\"]]");
    p = add_epsg_def (filter, first, last, 6593, "epsg", 6593,
        "NAD83(2011) / Virginia North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2");
    add_proj4text (p, 2,
        "000000.0001016 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Virginia North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_1\",39.2],PARAMETER[\"standard_parallel_2\",38.033333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"latitude_of_origin\",37.6666666666");
    add_srs_wkt (p, 10,
        "6666],PARAMETER[\"central_meridian\",-78.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",11482916.667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",6561666.667],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6593\"]]");
    p = add_epsg_def (filter, first, last, 6594, "epsg", 6594,
        "NAD83(2011) / Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Virginia South\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 8,
        "7.96666666666667],PARAMETER[\"standard_parallel_2\",36.7");
    add_srs_wkt (p, 9,
        "6666666666667],PARAMETER[\"latitude_of_origin\",36.33333");
    add_srs_wkt (p, 10,
        "333333334],PARAMETER[\"central_meridian\",-78.5],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",3500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6594\"]]");
    p = add_epsg_def (filter, first, last, 6595, "epsg", 6595,
        "NAD83(2011) / Virginia South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0");
    add_proj4text (p, 2,
        "001016 +y_0=999999.9998983998 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Virginia South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_1\",37.96666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 9,
        "2\",36.76666666666667],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 10,
        "36.33333333333334],PARAMETER[\"central_meridian\",-78.5]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",11482916.667],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",3280833.333],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 13,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6595\"]]");
    p = add_epsg_def (filter, first, last, 6596, "epsg", 6596,
        "NAD83(2011) / Washington North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Washington North\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",48.73333333333333],PARAMETER[\"standard_parallel_2\",47");
    add_srs_wkt (p, 9,
        ".5],PARAMETER[\"latitude_of_origin\",47],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",-120.8333333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6596\"]]");
    p = add_epsg_def (filter, first, last, 6597, "epsg", 6597,
        "NAD83(2011) / Washington North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
        " +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Washington North (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",48.73333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",47.5],PARAMETER[\"latitude_of_origin\",47],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"central_meridian\",-120.8333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",1640416.667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"6597\"]]");
    p = add_epsg_def (filter, first, last, 6598, "epsg", 6598,
        "NAD83(2011) / Washington South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Washington South\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",47.33333333333334],PARAMETER[\"standard_parallel_2\",45");
    add_srs_wkt (p, 9,
        ".83333333333334],PARAMETER[\"latitude_of_origin\",45.333");
    add_srs_wkt (p, 10,
        "33333333334],PARAMETER[\"central_meridian\",-120.5],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "598\"]]");
    p = add_epsg_def (filter, first, last, 6599, "epsg", 6599,
        "NAD83(2011) / Washington South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "001016001 +y_0=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Washington South (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",47.33333333333334],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",45.83333333333334],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",45.33333333333334],PARAMETER[\"central_meridian\",-120.");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",1640416.667],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6599\"]]");
    p = add_epsg_def (filter, first, last, 6600, "epsg", 6600,
        "NAD83(2011) / West Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / West Virginia North\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",40.25],PARAMETER[\"standard_parallel_2\",39],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",38.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-79.5],PARAMETER[\"false_easting\",600000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6600\"]]");
    p = add_epsg_def (filter, first, last, 6601, "epsg", 6601,
        "NAD83(2011) / West Virginia North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / West Virginia North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",40.25],PARAMETER[\"standard_parallel_2\",39],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",38.5],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-79.5],PARAMETER[\"false_easting\",1968500");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6601\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 6602, "epsg", 6602,
        "NAD83(2011) / West Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / West Virginia South\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",38.88333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",37.48333333333333],PARAMETER[\"latitude_of_origin\",37]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"central_meridian\",-81],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",600000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6602\"]]");
    p = add_epsg_def (filter, first, last, 6603, "epsg", 6603,
        "NAD83(2011) / West Virginia South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / West Virginia South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",38.88333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_2\",37.48333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 10,
        "n\",37],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",1968500],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"6603\"]]");
    p = add_epsg_def (filter, first, last, 6604, "epsg", 6604,
        "NAD83(2011) / Wisconsin Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_1\",45.5],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",44.25],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 10,
        ".83333333333334],PARAMETER[\"central_meridian\",-90],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",600000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6604\"]]");
    p = add_epsg_def (filter, first, last, 6605, "epsg", 6605,
        "NAD83(2011) / Wisconsin Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin Central (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 8,
        "llel_1\",45.5],PARAMETER[\"standard_parallel_2\",44.25],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",43.83333333333334],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-90],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"6605\"]]");
    p = add_epsg_def (filter, first, last, 6606, "epsg", 6606,
        "NAD83(2011) / Wisconsin North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin North\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",46.76666666666667],PARAMETER[\"standard_parallel_2\",45");
    add_srs_wkt (p, 9,
        ".56666666666667],PARAMETER[\"latitude_of_origin\",45.166");
    add_srs_wkt (p, 10,
        "66666666666],PARAMETER[\"central_meridian\",-90],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",600000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6606\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 6607, "epsg", 6607,
        "NAD83(2011) / Wisconsin North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_1\",46.76666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 9,
        "2\",45.56666666666667],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 10,
        "45.16666666666666],PARAMETER[\"central_meridian\",-90],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",1968500],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"6607\"]]");
    p = add_epsg_def (filter, first, last, 6608, "epsg", 6608,
        "NAD83(2011) / Wisconsin South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin South\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",44.06666666666667],PARAMETER[\"standard_parallel_2\",42");
    add_srs_wkt (p, 9,
        ".73333333333333],PARAMETER[\"latitude_of_origin\",42],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-90],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",600000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6608\"]]");
    p = add_epsg_def (filter, first, last, 6609, "epsg", 6609,
        "NAD83(2011) / Wisconsin South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 7,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_1\",44.06666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 9,
        "2\",42.73333333333333],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 10,
        "42],PARAMETER[\"central_meridian\",-90],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",1968500],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6609\"]]");
    p = add_epsg_def (filter, first, last, 6610, "epsg", 6610,
        "NAD83(2011) / Wisconsin Transverse Mercator");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y");
    add_proj4text (p, 1,
        "_0=-4480000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin Transverse Mercator\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-90],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",52000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",-4480000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6610\"]]");
    p = add_epsg_def (filter, first, last, 6611, "epsg", 6611,
        "NAD83(2011) / Wyoming East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming East\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-105.1666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9999375],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6611\"]]");
    p = add_epsg_def (filter, first, last, 6612, "epsg", 6612,
        "NAD83(2011) / Wyoming East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-105.1666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9999375],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",656166.6667],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6612\"]]");
    p = add_epsg_def (filter, first, last, 6613, "epsg", 6613,
        "NAD83(2011) / Wyoming East Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming East Central\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-107.3333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9999375],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",400000],PARAMETER[\"false_northing\",100000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6613\"]]");
    p = add_epsg_def (filter, first, last, 6614, "epsg", 6614,
        "NAD83(2011) / Wyoming East Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming East Central (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",40.5],PARAMETER[\"central_meridian\",-107.3333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",1312333.3333],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",328083.3333],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6614\"]]");
    p = add_epsg_def (filter, first, last, 6615, "epsg", 6615,
        "NAD83(2011) / Wyoming West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming West\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-110.0833333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9999375],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "800000],PARAMETER[\"false_northing\",100000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6615\"]]");
    p = add_epsg_def (filter, first, last, 6616, "epsg", 6616,
        "NAD83(2011) / Wyoming West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-110.0833333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9999375],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",2624666.6667],PARAMETER[\"false_northing\",328083");
    add_srs_wkt (p, 11,
        ".3333],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6616\"]]");
    p = add_epsg_def (filter, first, last, 6617, "epsg", 6617,
        "NAD83(2011) / Wyoming West Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming West Central\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-108.75],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9999375],PARAMETER[\"false_easting\",6000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"6617\"]]");
    p = add_epsg_def (filter, first, last, 6618, "epsg", 6618,
        "NAD83(2011) / Wyoming West Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wyoming West Central (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",40.5],PARAMETER[\"central_meridian\",-108.75],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.9999375],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6618\"]]");
    p = add_epsg_def (filter, first, last, 6619, "epsg", 6619,
        "NAD83(2011) / Utah Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Utah Central\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40");
    add_srs_wkt (p, 8,
        ".65],PARAMETER[\"standard_parallel_2\",39.01666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",38.33333333333334],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-111.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",500000],PARAMETER[\"false_northing\",2000000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6619\"]]");
    p = add_epsg_def (filter, first, last, 6620, "epsg", 6620,
        "NAD83(2011) / Utah North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Utah North\",GEOGCS[\"NAD83(2011)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_National_Spatial_Reference_System_2011\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.7833");
    add_srs_wkt (p, 8,
        "3333333333],PARAMETER[\"standard_parallel_2\",40.7166666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",40.33333333333");
    add_srs_wkt (p, 10,
        "334],PARAMETER[\"central_meridian\",-111.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"662");
    add_srs_wkt (p, 14,
        "0\"]]");
    p = add_epsg_def (filter, first, last, 6621, "epsg", 6621,
        "NAD83(2011) / Utah South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Utah South\",GEOGCS[\"NAD83(2011)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_National_Spatial_Reference_System_2011\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38.35],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_2\",37.21666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",36.66666666666666],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-111.5],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",3000000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6621\"]]");
    p = add_epsg_def (filter, first, last, 6622, "epsg", 6622,
        "NAD83(CSRS) / Quebec Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Quebec Lambert\",GEOGCS[\"NAD83(C");
    add_srs_wkt (p, 1,
        "SRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",60],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",-68.5],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6622\"]]");
    p = add_epsg_def (filter, first, last, 6623, "epsg", 6623,
        "NAD83 / Quebec Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Quebec Albers\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_Equal_");
    add_srs_wkt (p, 7,
        "Area\"],PARAMETER[\"standard_parallel_1\",60],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",46],PARAMETER[\"latitude_of_cent");
    add_srs_wkt (p, 9,
        "er\",44],PARAMETER[\"longitude_of_center\",-68.5],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",0],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6623\"]]");
    p = add_epsg_def (filter, first, last, 6624, "epsg", 6624,
        "NAD83(CSRS) / Quebec Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Quebec Albers\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 1,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_");
    add_srs_wkt (p, 8,
        "parallel_1\",60],PARAMETER[\"standard_parallel_2\",46],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"latitude_of_center\",44],PARAMETER[\"longitud");
    add_srs_wkt (p, 10,
        "e_of_center\",-68.5],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6624\"]]");
    p = add_epsg_def (filter, first, last, 6625, "epsg", 6625,
        "NAD83(2011) / Utah Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0");
    add_proj4text (p, 2,
        "=2000000.00001016 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Utah Central (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",40.65],PARAMETER[\"standard_parallel_2\",39.0166666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",38.33333333333");
    add_srs_wkt (p, 10,
        "334],PARAMETER[\"central_meridian\",-111.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",1640416.6667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",6561666.666700001],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6625\"]]");
    p = add_epsg_def (filter, first, last, 6626, "epsg", 6626,
        "NAD83(2011) / Utah North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "0001016 +y_0=999999.9999898402 +ellps=GRS80 +units=us-ft");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Utah North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 8,
        "\",41.78333333333333],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 9,
        "40.71666666666667],PARAMETER[\"latitude_of_origin\",40.3");
    add_srs_wkt (p, 10,
        "3333333333334],PARAMETER[\"central_meridian\",-111.5],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",1640416.6667],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",3280833.333300001],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6626\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def (filter, first, last, 6627, "epsg", 6627,
        "NAD83(2011) / Utah South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0");
    add_proj4text (p, 2,
        "=3000000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Utah South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 8,
        "\",38.35],PARAMETER[\"standard_parallel_2\",37.216666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"latitude_of_origin\",36.6666666666666");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"central_meridian\",-111.5],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",1640416.6667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",9842500.000000002],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6627\"]]");
    p = add_epsg_def (filter, first, last, 6628, "epsg", 6628,
        "NAD83(PA11) / Hawaii zone 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.");
    add_proj4text (p, 1,
        "999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / Hawaii zone 1\",GEOGCS[\"NAD83(PA");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_PA");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",18.83333333");
    add_srs_wkt (p, 8,
        "333333],PARAMETER[\"central_meridian\",-155.5],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.999966667],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6628\"]]");
    p = add_epsg_def (filter, first, last, 6629, "epsg", 6629,
        "NAD83(PA11) / Hawaii zone 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / Hawaii zone 2\",GEOGCS[\"NAD83(PA");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_PA");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",20.33333333");
    add_srs_wkt (p, 8,
        "333333],PARAMETER[\"central_meridian\",-156.666666666666");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",0.999966667],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6629\"]]");
    p = add_epsg_def (filter, first, last, 6630, "epsg", 6630,
        "NAD83(PA11) / Hawaii zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / Hawaii zone 3\",GEOGCS[\"NAD83(PA");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_PA");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",21.16666666");
    add_srs_wkt (p, 8,
        "666667],PARAMETER[\"central_meridian\",-158],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99999],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"6630\"]]");
    p = add_epsg_def (filter, first, last, 6631, "epsg", 6631,
        "NAD83(PA11) / Hawaii zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.");
    add_proj4text (p, 1,
        "99999 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / Hawaii zone 4\",GEOGCS[\"NAD83(PA");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_PA");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",21.83333333");
    add_srs_wkt (p, 8,
        "333333],PARAMETER[\"central_meridian\",-159.5],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.99999],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"6631\"]]");
    p = add_epsg_def (filter, first, last, 6632, "epsg", 6632,
        "NAD83(PA11) / Hawaii zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / Hawaii zone 5\",GEOGCS[\"NAD83(PA");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_PA");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",21.66666666");
    add_srs_wkt (p, 8,
        "666667],PARAMETER[\"central_meridian\",-160.166666666666");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6632\"]]");
    p = add_epsg_def (filter, first, last, 6633, "epsg", 6633,
        "NAD83(PA11) / Hawaii zone 3 (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / Hawaii zone 3 (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(PA11)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_PA11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",21.1");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"central_meridian\",-158],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.99999],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",1640416.6667],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"6633\"]]");
    p = add_epsg_def (filter, first, last, 6634, "epsg", 6634,
        "NAD83(PA11) / UTM zone 4N");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / UTM zone 4N\",GEOGCS[\"NAD83(PA11");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_PA11");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-159],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6634\"]]");
    p = add_epsg_def (filter, first, last, 6635, "epsg", 6635,
        "NAD83(PA11) / UTM zone 5N");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / UTM zone 5N\",GEOGCS[\"NAD83(PA11");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_PA11");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-153],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6635\"]]");
    p = add_epsg_def (filter, first, last, 6636, "epsg", 6636,
        "NAD83(PA11) / UTM zone 2S");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / UTM zone 2S\",GEOGCS[\"NAD83(PA11");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_PA11");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-171],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"6636\"]]");
    p = add_epsg_def (filter, first, last, 6637, "epsg", 6637,
        "NAD83(MA11) / Guam Map Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.5 +lon_0=144.75 +k=1 +x_0=100000 +");
    add_proj4text (p, 1,
        "y_0=200000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(MA11) / Guam Map Grid\",GEOGCS[\"NAD83(MA");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_MA");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1118\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6325\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",13.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",144.75],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"6637\"]]");
    p = add_epsg_def (filter, first, last, 6646, "epsg", 6646,
        "Karbala 1979 / Iraq National Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.02626833333333 +lon_0=46.5 +k=0.99");
    add_proj4text (p, 1,
        "94 +x_0=800000 +y_0=0 +ellps=clrk80 +towgs84=70.995,-335");
    add_proj4text (p, 2,
        ".916,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / Iraq National Grid\",GEOGCS[\"Ka");
    add_srs_wkt (p, 1,
        "rbala 1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[70.995,-335.916,262.898,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6743\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4743\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",29.02626833333333],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",46.5],PARAMETER[\"scale_factor\",0.9994],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",800000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"6646\"]]");
    p = add_epsg_def (filter, first, last, 6668, "epsg", 6668,
        "JGD2011");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"6668\"]]");
    p = add_epsg_def (filter, first, last, 6669, "epsg", 6669,
        "JGD2011 / Japan Plane Rectangular CS I");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS I\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",129.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"6669\"]]");
    p = add_epsg_def (filter, first, last, 6670, "epsg", 6670,
        "JGD2011 / Japan Plane Rectangular CS II");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS II\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",131],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"6670\"]]");
    p = add_epsg_def (filter, first, last, 6671, "epsg", 6671,
        "JGD2011 / Japan Plane Rectangular CS III");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS III\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",132.1666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AUTHORITY[\"EPSG\",\"6671\"]]");
    p = add_epsg_def (filter, first, last, 6672, "epsg", 6672,
        "JGD2011 / Japan Plane Rectangular CS IV");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS IV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",133.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"6672\"]]");
    p = add_epsg_def (filter, first, last, 6673, "epsg", 6673,
        "JGD2011 / Japan Plane Rectangular CS V");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS V\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",134.3333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"6673\"]]");
    p = add_epsg_def (filter, first, last, 6674, "epsg", 6674,
        "JGD2011 / Japan Plane Rectangular CS VI");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",136],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"6674\"]]");
    p = add_epsg_def (filter, first, last, 6675, "epsg", 6675,
        "JGD2011 / Japan Plane Rectangular CS VII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",137.1666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AUTHORITY[\"EPSG\",\"6675\"]]");
    p = add_epsg_def (filter, first, last, 6676, "epsg", 6676,
        "JGD2011 / Japan Plane Rectangular CS VIII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",138.5],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AUTHORITY[\"EPSG\",\"6676\"]]");
    p = add_epsg_def (filter, first, last, 6677, "epsg", 6677,
        "JGD2011 / Japan Plane Rectangular CS IX");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS IX\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",139.8333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"6677\"]]");
    p = add_epsg_def (filter, first, last, 6678, "epsg", 6678,
        "JGD2011 / Japan Plane Rectangular CS X");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS X\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",140.8333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"6678\"]]");
    p = add_epsg_def (filter, first, last, 6679, "epsg", 6679,
        "JGD2011 / Japan Plane Rectangular CS XI");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",140.25],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"6679\"]]");
    p = add_epsg_def (filter, first, last, 6680, "epsg", 6680,
        "JGD2011 / Japan Plane Rectangular CS XII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",142.25],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AUTHORITY[\"EPSG\",\"6680\"]]");
    p = add_epsg_def (filter, first, last, 6681, "epsg", 6681,
        "JGD2011 / Japan Plane Rectangular CS XIII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",144.25],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AUTHORITY[\"EPSG\",\"6681\"]]");
    p = add_epsg_def (filter, first, last, 6682, "epsg", 6682,
        "JGD2011 / Japan Plane Rectangular CS XIV");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIV\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",142],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"6682\"]]");
    p = add_epsg_def (filter, first, last, 6683, "epsg", 6683,
        "JGD2011 / Japan Plane Rectangular CS XV");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",127.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"6683\"]]");
    p = add_epsg_def (filter, first, last, 6684, "epsg", 6684,
        "JGD2011 / Japan Plane Rectangular CS XVI");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVI\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",124],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"6684\"]]");
    p = add_epsg_def (filter, first, last, 6685, "epsg", 6685,
        "JGD2011 / Japan Plane Rectangular CS XVII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",131],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"6685\"]]");
    p = add_epsg_def (filter, first, last, 6686, "epsg", 6686,
        "JGD2011 / Japan Plane Rectangular CS XVIII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVIII\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",20],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",136],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"6686\"]]");
    p = add_epsg_def (filter, first, last, 6687, "epsg", 6687,
        "JGD2011 / Japan Plane Rectangular CS XIX");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIX\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",154],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"6687\"]]");
    p = add_epsg_def (filter, first, last, 6688, "epsg", 6688,
        "JGD2011 / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 51N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"668");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def (filter, first, last, 6689, "epsg", 6689,
        "JGD2011 / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 52N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"668");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def (filter, first, last, 6690, "epsg", 6690,
        "JGD2011 / UTM zone 53N");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 53N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"669");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def (filter, first, last, 6691, "epsg", 6691,
        "JGD2011 / UTM zone 54N");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 54N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"669");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def (filter, first, last, 6692, "epsg", 6692,
        "JGD2011 / UTM zone 55N");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 55N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"669");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def (filter, first, last, 6703, "epsg", 6703,
        "WGS 84 / TM 60 SW");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-60 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 60 SW\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-60],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"6703\"]]");
    p = add_epsg_def (filter, first, last, 6706, "epsg", 6706,
        "RDN2008");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RDN2008\",DATUM[\"Rete_Dinamica_Nazionale_2008\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6706\"]]");
    p = add_epsg_def (filter, first, last, 6707, "epsg", 6707,
        "RDN2008 / TM32");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / TM32\",GEOGCS[\"RDN2008\",DATUM[\"Ret");
    add_srs_wkt (p, 1,
        "e_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",9],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"6707\"]]");
    p = add_epsg_def (filter, first, last, 6708, "epsg", 6708,
        "RDN2008 / TM33");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / TM33\",GEOGCS[\"RDN2008\",DATUM[\"Ret");
    add_srs_wkt (p, 1,
        "e_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",15],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"6708\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

