/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:29 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_27 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 5576, "epsg", 5576,
        "UCS-2000 / 3-degree Gauss-Kruger zone 13 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger zone 13 (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",39],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",13500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 12,
        "76\"]]");
    p = add_epsg_def (filter, first, last, 5577, "epsg", 5577,
        "UCS-2000 / 3-degree Gauss-Kruger CM 21E (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 21E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",21],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"557");
    add_srs_wkt (p, 12,
        "7\"]]");
    p = add_epsg_def (filter, first, last, 5578, "epsg", 5578,
        "UCS-2000 / 3-degree Gauss-Kruger CM 24E (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 24E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",24],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"557");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def (filter, first, last, 5579, "epsg", 5579,
        "UCS-2000 / 3-degree Gauss-Kruger CM 27E (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 27E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",27],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"557");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def (filter, first, last, 5580, "epsg", 5580,
        "UCS-2000 / 3-degree Gauss-Kruger CM 30E (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 30E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",30],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"558");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def (filter, first, last, 5581, "epsg", 5581,
        "UCS-2000 / 3-degree Gauss-Kruger CM 33E (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 33E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",33],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"558");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def (filter, first, last, 5582, "epsg", 5582,
        "UCS-2000 / 3-degree Gauss-Kruger CM 36E (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 36E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",36],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"558");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def (filter, first, last, 5583, "epsg", 5583,
        "UCS-2000 / 3-degree Gauss-Kruger CM 39E (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / 3-degree Gauss-Kruger CM 39E (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7024\"]],TOWGS84[25,-141,-78.5,-0,0.35,0.736,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",39],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"558");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def (filter, first, last, 5588, "epsg", 5588,
        "NAD27 / New Brunswick Stereographic (NAD27)");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=3");
    add_proj4text (p, 1,
        "04800 +y_0=304800 +datum=NAD27 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Brunswick Stereographic (NAD27)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Oblique_Ste");
    add_srs_wkt (p, 7,
        "reographic\"],PARAMETER[\"latitude_of_origin\",46.5],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-66.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999912],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",1000000],UNIT[\"foot\",0.3048,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9002\"]],AUTHORITY[\"EPSG\",\"5588\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def (filter, first, last, 5589, "epsg", 5589,
        "Sibun Gorge 1922 / Colony Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=17.06124194444444 +lon_0=-88.6318575 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=66220.02833082761 +y_0=135779.5099885299 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +to_meter=0.3047972");
    add_proj4text (p, 3,
        "654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sibun Gorge 1922 / Colony Grid\",GEOGCS[\"Sibun");
    add_srs_wkt (p, 1,
        " Gorge 1922\",DATUM[\"Sibun_Gorge_1922\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1858\",6378293.645208759,294.2606763692569,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"1071\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"5464\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",17.0612419444");
    add_srs_wkt (p, 8,
        "4444],PARAMETER[\"central_meridian\",-88.6318575],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2172");
    add_srs_wkt (p, 10,
        "59.26],PARAMETER[\"false_northing\",445474.83],UNIT[\"Cl");
    add_srs_wkt (p, 11,
        "arke's foot\",0.3047972654,AUTHORITY[\"EPSG\",\"9005\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"5589\"]]");
    p = add_epsg_def (filter, first, last, 5593, "epsg", 5593,
        "FEH2010");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"FEH2010\",DATUM[\"Fehmarnbelt_Datum_2010\",SPHE");
    add_srs_wkt (p, 1,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"1078\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5593\"]]");
    p = add_epsg_def (filter, first, last, 5596, "epsg", 5596,
        "FEH2010 / Fehmarnbelt TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"FEH2010 / Fehmarnbelt TM\",GEOGCS[\"FEH2010\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Fehmarnbelt_Datum_2010\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1078\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5593\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",11.33333333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"5596\"]]");
    p = add_epsg_def (filter, first, last, 5623, "epsg", 5623,
        "NAD27 / Michigan East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99942857 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",41.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-83.66666666666667],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9942857],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5623\"]]");
    p = add_epsg_def (filter, first, last, 5624, "epsg", 5624,
        "NAD27 / Michigan Old Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan Old Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",41.5],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-85.75],PARAMETER[\"scale_factor\",0.9999090");
    add_srs_wkt (p, 9,
        "91],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"5624\"]]");
    p = add_epsg_def (filter, first, last, 5625, "epsg", 5625,
        "NAD27 / Michigan West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",41.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-88.75],PARAMETER[\"scale_factor\",0.999909091],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 12,
        "RTH],AUTHORITY[\"EPSG\",\"5625\"]]");
    p = add_epsg_def (filter, first, last, 5627, "epsg", 5627,
        "ED50 / TM 6 NE");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 6 NE\",GEOGCS[\"ED50\",DATUM[\"Europe");
    add_srs_wkt (p, 1,
        "an_Datum_1950\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
        "297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",6],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5627\"]]");
    p = add_epsg_def (filter, first, last, 5629, "epsg", 5629,
        "Moznet / UTM zone 38S");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=WGS84 +towgs84=0,0,0,-0");
    add_proj4text (p, 1,
        ",-0,-0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Moznet / UTM zone 38S\",GEOGCS[\"Moznet\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Moznet_ITRF94\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,-0,-0,-");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6130\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4130\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 10,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"5629\"]]");
    p = add_epsg_def (filter, first, last, 5631, "epsg", 5631,
        "Pulkovo 1942(58) / Gauss-Kruger zone 2 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 2 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0");
    add_srs_wkt (p, 4,
        ".844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5631\"]]");
    p = add_epsg_def (filter, first, last, 5632, "epsg", 5632,
        "PTRA08 / LCC Europe");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / LCC Europe\",GEOGCS[\"PTRA08\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1041\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"5013\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_2\",65],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",52],PARAMETER[\"central_meridian\",10],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",4000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AUTHORITY[\"EPSG\",\"5632\"]]");
    p = add_epsg_def (filter, first, last, 5633, "epsg", 5633,
        "PTRA08 / LAEA Europe");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / LAEA Europe\",GEOGCS[\"PTRA08\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1041\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"5013\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Azimuthal_Equal_Area\"],PARAMETER[\"latitude_of_center\"");
    add_srs_wkt (p, 8,
        ",52],PARAMETER[\"longitude_of_center\",10],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",4321000],PARAMETER[\"false_northing\",321");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"5633\"]]");
    p = add_epsg_def (filter, first, last, 5634, "epsg", 5634,
        "REGCAN95 / LCC Europe");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / LCC Europe\",GEOGCS[\"REGCAN95\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_2\",65],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",52],PARAMETER[\"central_meridian\",10],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",4000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AUTHORITY[\"EPSG\",\"5634\"]]");
    p = add_epsg_def (filter, first, last, 5635, "epsg", 5635,
        "REGCAN95 / LAEA Europe");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / LAEA Europe\",GEOGCS[\"REGCAN95\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Lambert_Az");
    add_srs_wkt (p, 7,
        "imuthal_Equal_Area\"],PARAMETER[\"latitude_of_center\",5");
    add_srs_wkt (p, 8,
        "2],PARAMETER[\"longitude_of_center\",10],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",4321000],PARAMETER[\"false_northing\",32100");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"5635\"]]");
    p = add_epsg_def (filter, first, last, 5636, "epsg", 5636,
        "TUREF / LAEA Europe");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / LAEA Europe\",GEOGCS[\"TUREF\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Turkish_National_Reference_Frame\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"5252\"]],PROJECTION[\"Lambert_Azimu");
    add_srs_wkt (p, 7,
        "thal_Equal_Area\"],PARAMETER[\"latitude_of_center\",52],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"longitude_of_center\",10],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",4321000],PARAMETER[\"false_northing\",3210000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"5636\"]]");
    p = add_epsg_def (filter, first, last, 5637, "epsg", 5637,
        "TUREF / LCC Europe");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / LCC Europe\",GEOGCS[\"TUREF\",DATUM[\"T");
    add_srs_wkt (p, 1,
        "urkish_National_Reference_Frame\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"5252\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_2\",65],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",52],PARAMETER[\"central_meridian\",10],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",4000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AUTHORITY[\"EPSG\",\"5637\"]]");
    p = add_epsg_def (filter, first, last, 5638, "epsg", 5638,
        "ISN2004 / LAEA Europe");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / LAEA Europe\",GEOGCS[\"ISN2004\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"5324\"]],PROJECTION[\"Lambert_Azimuthal_Equal_A");
    add_srs_wkt (p, 7,
        "rea\"],PARAMETER[\"latitude_of_center\",52],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "longitude_of_center\",10],PARAMETER[\"false_easting\",43");
    add_srs_wkt (p, 9,
        "21000],PARAMETER[\"false_northing\",3210000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "5638\"]]");
    p = add_epsg_def (filter, first, last, 5639, "epsg", 5639,
        "ISN2004 / LCC Europe");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / LCC Europe\",GEOGCS[\"ISN2004\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"5324\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",35],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_2\",65],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",52],PARAMETER[\"central_meridian\",10],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",4000000],PARAMETER[\"false_northing\",280000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"5639\"]]");
    p = add_epsg_def (filter, first, last, 5641, "epsg", 5641,
        "SIRGAS 2000 / Brazil Mercator");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=-43 +lat_ts=-2 +x_0=5000000 +y_0=10000");
    add_proj4text (p, 1,
        "000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / Brazil Mercator\",GEOGCS[\"SIRGAS");
    add_srs_wkt (p, 1,
        " 2000\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_l");
    add_srs_wkt (p, 2,
        "as_AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4674\"]],PROJECTION[\"Mercator_2SP\"],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "tandard_parallel_1\",-2],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-43],PARAMETER[\"false_easting\",5000000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"5641\"]]");
    p = add_epsg_def (filter, first, last, 5643, "epsg", 5643,
        "ED50 / SPBA LCC");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=52.66666666666666 +lat_2=54.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=48 +lon_0=10 +x_0=815000 +y_0=0 +ellps=intl +");
    add_proj4text (p, 2,
        "towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / SPBA LCC\",GEOGCS[\"ED50\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Datum_1950\",SPHEROID[\"International 1924\",6378388");
    add_srs_wkt (p, 2,
        ",297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4230\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",52.6666666666666");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"standard_parallel_2\",54.33333333333334],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",48],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",10],PARAMETER[\"false_easting\",815000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"5643\"]]");
    p = add_epsg_def (filter, first, last, 5644, "epsg", 5644,
        "RGR92 / UTM zone 39S");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGR92 / UTM zone 39S\",GEOGCS[\"RGR92\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_de_la_Reunion_1992\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6627\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4627\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",51],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"5644\"]]");
    p = add_epsg_def (filter, first, last, 5646, "epsg", 5646,
        "NAD83 / Vermont (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +datum=NAD83 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Vermont (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",42.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-72.5],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99964286],PARAMETER[\"false_easting\",1640416.6667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5646\"]]");
    p = add_epsg_def (filter, first, last, 5649, "epsg", 5649,
        "ETRS89 / UTM zone 31N (zE-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",3150000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5649\"]]");
    p = add_epsg_def (filter, first, last, 5650, "epsg", 5650,
        "ETRS89 / UTM zone 33N (zE-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",335000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5650\"]]");
    p = add_epsg_def (filter, first, last, 5651, "epsg", 5651,
        "ETRS89 / UTM zone 31N (N-zE)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",3150000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5651\"]]");
    p = add_epsg_def (filter, first, last, 5652, "epsg", 5652,
        "ETRS89 / UTM zone 32N (N-zE)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=32500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",3250000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5652\"]]");
    p = add_epsg_def (filter, first, last, 5653, "epsg", 5653,
        "ETRS89 / UTM zone 33N (N-zE)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",335000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"5653\"]]");
    p = add_epsg_def (filter, first, last, 5654, "epsg", 5654,
        "NAD83(HARN) / Vermont (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Vermont (ftUS)\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",42.5],PARAMETER[\"central_meridian\",-72.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999964286],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",1640416.6667],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"5654\"]]");
    p = add_epsg_def (filter, first, last, 5655, "epsg", 5655,
        "NAD83(NSRS2007) / Vermont (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Vermont (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",42.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-72.5],PARAMETER[\"scale_factor\",0.999964286],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",1640416.6667],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.3048006096012192,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"5655\"]]");
    p = add_epsg_def (filter, first, last, 5659, "epsg", 5659,
        "Monte Mario / TM Emilia-Romagna");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=500053 +y_0");
    add_proj4text (p, 1,
        "=-3999820 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-");
    add_proj4text (p, 2,
        "2.917,0.714,-11.68 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario / TM Emilia-Romagna\",GEOGCS[\"Mont");
    add_srs_wkt (p, 1,
        "e Mario\",DATUM[\"Monte_Mario\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6265\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4265\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500053],PARAMETER[\"false_northing\",-3999820],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5659\"]]");
    p = add_epsg_def (filter, first, last, 5663, "epsg", 5663,
        "Pulkovo 1942(58) / Gauss-Kruger zone 3 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 3 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0");
    add_srs_wkt (p, 4,
        ".844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",3500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"5663\"]]");
    p = add_epsg_def (filter, first, last, 5664, "epsg", 5664,
        "Pulkovo 1942(83) / Gauss-Kruger zone 2 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 2 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",9],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",250000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5664\"]]");
    p = add_epsg_def (filter, first, last, 5665, "epsg", 5665,
        "Pulkovo 1942(83) / Gauss-Kruger zone 3 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 3 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4178\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",15],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",35000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5665\"]]");
    p = add_epsg_def (filter, first, last, 5666, "epsg", 5666,
        "PD/83 / 3-degree Gauss-Kruger zone 3 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 3 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",3500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5666\"]]");
    p = add_epsg_def (filter, first, last, 5667, "epsg", 5667,
        "PD/83 / 3-degree Gauss-Kruger zone 4 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 4 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",4500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5667\"]]");
    p = add_epsg_def (filter, first, last, 5668, "epsg", 5668,
        "RD/83 / 3-degree Gauss-Kruger zone 4 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 4 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4745\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",4500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5668\"]]");
    p = add_epsg_def (filter, first, last, 5669, "epsg", 5669,
        "RD/83 / 3-degree Gauss-Kruger zone 5 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 5 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4745\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",5500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5669\"]]");
    p = add_epsg_def (filter, first, last, 5670, "epsg", 5670,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359");
    add_srs_wkt (p, 4,
        ",-0.053,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",9],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",3500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"5670\"]]");
    p = add_epsg_def (filter, first, last, 5671, "epsg", 5671,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359");
    add_srs_wkt (p, 4,
        ",-0.053,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",12],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",4500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"5671\"]]");
    p = add_epsg_def (filter, first, last, 5672, "epsg", 5672,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359");
    add_srs_wkt (p, 4,
        ",-0.053,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",15],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",5500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"5672\"]]");
    p = add_epsg_def (filter, first, last, 5673, "epsg", 5673,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "78\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",9]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5673\"]]");
    p = add_epsg_def (filter, first, last, 5674, "epsg", 5674,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "78\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5674\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 5675, "epsg", 5675,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "78\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5675\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 5676, "epsg", 5676,
        "DHDN / 3-degree Gauss-Kruger zone 2 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 2 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",6],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",2500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"5676\"]]");
    p = add_epsg_def (filter, first, last, 5677, "epsg", 5677,
        "DHDN / 3-degree Gauss-Kruger zone 3 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 3 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",3500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"5677\"]]");
    p = add_epsg_def (filter, first, last, 5678, "epsg", 5678,
        "DHDN / 3-degree Gauss-Kruger zone 4 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 4 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",4500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5678\"]]");
    p = add_epsg_def (filter, first, last, 5679, "epsg", 5679,
        "DHDN / 3-degree Gauss-Kruger zone 5 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 5 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",5500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5679\"]]");
    p = add_epsg_def (filter, first, last, 5680, "epsg", 5680,
        "DHDN / 3-degree Gauss-Kruger zone 1 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +");
    add_proj4text (p, 1,
        "datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 1 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",3],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"5680\"]]");
    p = add_epsg_def (filter, first, last, 5681, "epsg", 5681,
        "DB_REF");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"5681\"]]");
    p = add_epsg_def (filter, first, last, 5682, "epsg", 5682,
        "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",6],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",2500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"5682\"]]");
    p = add_epsg_def (filter, first, last, 5683, "epsg", 5683,
        "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",9],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",3500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"5683\"]]");
    p = add_epsg_def (filter, first, last, 5684, "epsg", 5684,
        "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",12],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",4500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5684\"]]");
    p = add_epsg_def (filter, first, last, 5685, "epsg", 5685,
        "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",15],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",5500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5685\"]]");
    p = add_epsg_def (filter, first, last, 5700, "epsg", 5700,
        "NZGD2000 / UTM zone 1S");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / UTM zone 1S\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-177],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5700\"]]");
    p = add_epsg_def (filter, first, last, 5825, "epsg", 5825,
        "AGD66 / ACT Standard Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-35.31773627777778 +lon_0=149.0092948");
    add_proj4text (p, 1,
        "305555 +k=1.000086 +x_0=200000 +y_0=600000 +ellps=aust_S");
    add_proj4text (p, 2,
        "A +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0");
    add_proj4text (p, 3,
        ".29 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / ACT Standard Grid\",GEOGCS[\"AGD66\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Australian_Geodetic_Datum_1966\",SPHEROID[\"Austra");
    add_srs_wkt (p, 2,
        "lian National Spheroid\",6378160,298.25,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.4");
    add_srs_wkt (p, 4,
        "46,0.234,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",-35.3177362777777");
    add_srs_wkt (p, 9,
        "8],PARAMETER[\"central_meridian\",149.0092948305555],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1.000086],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",200000],PARAMETER[\"false_northing\",600000],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 14,
        "825\"]]");
    p = add_epsg_def (filter, first, last, 5836, "epsg", 5836,
        "Yemen NGN96 / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 37N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5836\"]]");
    p = add_epsg_def (filter, first, last, 5837, "epsg", 5837,
        "Yemen NGN96 / UTM zone 40N");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 40N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5837\"]]");
    p = add_epsg_def (filter, first, last, 5839, "epsg", 5839,
        "Peru96 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 17S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"53");
    add_srs_wkt (p, 6,
        "73\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5839\"]]");
    p = add_epsg_def (filter, first, last, 5842, "epsg", 5842,
        "WGS 84 / TM 12 SE");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 12 SE\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",12],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"5842\"]]");
    p = add_epsg_def (filter, first, last, 5844, "epsg", 5844,
        "RGRDC 2005 / Congo TM zone 30");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 30\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",30],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"5844\"]]");
    p = add_epsg_def (filter, first, last, 5858, "epsg", 5858,
        "SAD69(96) / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 22S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5858\"]]");
    p = add_epsg_def (filter, first, last, 5875, "epsg", 5875,
        "SAD69(96) / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 18S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5875\"]]");
    p = add_epsg_def (filter, first, last, 5876, "epsg", 5876,
        "SAD69(96) / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 19S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5876\"]]");
    p = add_epsg_def (filter, first, last, 5877, "epsg", 5877,
        "SAD69(96) / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 20S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5877\"]]");
    p = add_epsg_def (filter, first, last, 5879, "epsg", 5879,
        "Cadastre 1997 / UTM zone 38S");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=intl +towgs84=-381.788,");
    add_proj4text (p, 1,
        "-57.501,-256.673,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cadastre 1997 / UTM zone 38S\",GEOGCS[\"Cadastr");
    add_srs_wkt (p, 1,
        "e 1997\",DATUM[\"Cadastre_1997\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-381.788,-57.501,-256.673,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1037\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4475\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5879\"]]");
    p = add_epsg_def (filter, first, last, 5880, "epsg", 5880,
        "SIRGAS 2000 / Brazil Polyconic");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / Brazil Polyconic\",GEOGCS[\"SIRGA");
    add_srs_wkt (p, 1,
        "S 2000\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_");
    add_srs_wkt (p, 2,
        "las_AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4674\"]],PROJECTION[\"Polyconic\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-54]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",5000000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5880\"]]");
    p = add_epsg_def (filter, first, last, 5886, "epsg", 5886,
        "TGD2005");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TGD2005\",DATUM[\"Tonga_Geodetic_Datum_2005\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1095\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"5886\"]]");
    p = add_epsg_def (filter, first, last, 5887, "epsg", 5887,
        "TGD2005 / Tonga Map Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=1500000 ");
    add_proj4text (p, 1,
        "+y_0=5000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TGD2005 / Tonga Map Grid\",GEOGCS[\"TGD2005\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Tonga_Geodetic_Datum_2005\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1095\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 6,
        "86\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",1500000],PARAMETER[\"false_northing\",5000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5887\"]]");
    p = add_epsg_def (filter, first, last, 5890, "epsg", 5890,
        "JAXA Snow Depth Polar Stereographic North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=90 +k=1 +x_0=0 +");
    add_proj4text (p, 1,
        "y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAXA Snow Depth Polar Stereographic North\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Unspecified datum based upon the Hughes 1980 ellip");
    add_srs_wkt (p, 2,
        "soid\",DATUM[\"Not_specified_based_on_Hughes_1980_ellips");
    add_srs_wkt (p, 3,
        "oid\",SPHEROID[\"Hughes 1980\",6378273,298.279411123061,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"6054\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AUTHORITY[\"EPSG\",\"4054\"]],PROJECTION[\"Pola");
    add_srs_wkt (p, 8,
        "r_Stereographic\"],PARAMETER[\"latitude_of_origin\",70],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",90],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"5890\"]]");
    p = add_epsg_def (filter, first, last, 5921, "epsg", 5921,
        "WGS 84 / EPSG Arctic Regional zone A1");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",85],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",77],PARAMETER[\"latitude_of_origin\",81.317226],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-111],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5921\"]]");
    p = add_epsg_def (filter, first, last, 5922, "epsg", 5922,
        "WGS 84 / EPSG Arctic Regional zone A2");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",85],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",77],PARAMETER[\"latitude_of_origin\",81.317226],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-39],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5922\"]]");
    p = add_epsg_def (filter, first, last, 5923, "epsg", 5923,
        "WGS 84 / EPSG Arctic Regional zone A3");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",85],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",77],PARAMETER[\"latitude_of_origin\",81.317226],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",33],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5923\"]]");
    p = add_epsg_def (filter, first, last, 5924, "epsg", 5924,
        "WGS 84 / EPSG Arctic Regional zone A4");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",85],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",77],PARAMETER[\"latitude_of_origin\",81.317226],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",105],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5924\"]]");
    p = add_epsg_def (filter, first, last, 5925, "epsg", 5925,
        "WGS 84 / EPSG Arctic Regional zone A5");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",85],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",77],PARAMETER[\"latitude_of_origin\",81.317226],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",177],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5925\"]]");
    p = add_epsg_def (filter, first, last, 5926, "epsg", 5926,
        "WGS 84 / EPSG Arctic Regional zone B1");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",69],PARAMETER[\"latitude_of_origin\",73.155740861111");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"central_meridian\",-111],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5926");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 5927, "epsg", 5927,
        "WGS 84 / EPSG Arctic Regional zone B2");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",69],PARAMETER[\"latitude_of_origin\",73.155740861111");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"central_meridian\",-39],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5927\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5928, "epsg", 5928,
        "WGS 84 / EPSG Arctic Regional zone B3");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",69],PARAMETER[\"latitude_of_origin\",73.155740861111");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"central_meridian\",33],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5928\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5929, "epsg", 5929,
        "WGS 84 / EPSG Arctic Regional zone B4");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",69],PARAMETER[\"latitude_of_origin\",73.155740861111");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"central_meridian\",105],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5929\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5930, "epsg", 5930,
        "WGS 84 / EPSG Arctic Regional zone B5");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",69],PARAMETER[\"latitude_of_origin\",73.155740861111");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"central_meridian\",177],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5930\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5931, "epsg", 5931,
        "WGS 84 / EPSG Arctic Regional zone C1");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",69],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",61],PARAMETER[\"latitude_of_origin\",65.101270888888");
    add_srs_wkt (p, 9,
        "88],PARAMETER[\"central_meridian\",-111],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5931");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 5932, "epsg", 5932,
        "WGS 84 / EPSG Arctic Regional zone C2");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",69],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",61],PARAMETER[\"latitude_of_origin\",65.101270888888");
    add_srs_wkt (p, 9,
        "88],PARAMETER[\"central_meridian\",-39],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5932\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5933, "epsg", 5933,
        "WGS 84 / EPSG Arctic Regional zone C3");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",69],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",61],PARAMETER[\"latitude_of_origin\",65.101270888888");
    add_srs_wkt (p, 9,
        "88],PARAMETER[\"central_meridian\",33],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5933\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5934, "epsg", 5934,
        "WGS 84 / EPSG Arctic Regional zone C4");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",69],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",61],PARAMETER[\"latitude_of_origin\",65.101270888888");
    add_srs_wkt (p, 9,
        "88],PARAMETER[\"central_meridian\",105],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5934\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5935, "epsg", 5935,
        "WGS 84 / EPSG Arctic Regional zone C5");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",69],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 8,
        "2\",61],PARAMETER[\"latitude_of_origin\",65.101270888888");
    add_srs_wkt (p, 9,
        "88],PARAMETER[\"central_meridian\",177],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5935\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 5936, "epsg", 5936,
        "WGS 84 / EPSG Alaska Polar Stereographic");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-150 +k=0.994 +x");
    add_proj4text (p, 1,
        "_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Alaska Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",-150]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",2000000],PARAMETER[\"false_northing\",2000000],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5936\"]]");
    p = add_epsg_def (filter, first, last, 5937, "epsg", 5937,
        "WGS 84 / EPSG Canada Polar Stereographic");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-100 +k=0.994 +x");
    add_proj4text (p, 1,
        "_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Canada Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",-100]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",2000000],PARAMETER[\"false_northing\",2000000],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5937\"]]");
    p = add_epsg_def (filter, first, last, 5938, "epsg", 5938,
        "WGS 84 / EPSG Greenland Polar Stereographic");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-33 +k=0.994 +x_");
    add_proj4text (p, 1,
        "0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Greenland Polar Stereographic\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",");
    add_srs_wkt (p, 2,
        "6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "6\"]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",90],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",2000000],PARAMETER[\"false_northing\",2000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5938\"]]");
    p = add_epsg_def (filter, first, last, 5939, "epsg", 5939,
        "WGS 84 / EPSG Norway Polar Stereographic");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=18 +k=0.994 +x_0");
    add_proj4text (p, 1,
        "=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Norway Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",18],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",2000000],PARAMETER[\"false_northing\",2000000],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5939\"]]");
    p = add_epsg_def (filter, first, last, 5940, "epsg", 5940,
        "WGS 84 / EPSG Russia Polar Stereographic");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=105 +k=0.994 +x_");
    add_proj4text (p, 1,
        "0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Russia Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",105],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",2000000],PARAMETER[\"false_northing\",2000000],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 11,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5940\"]]");
    p = add_epsg_def (filter, first, last, 6050, "epsg", 6050,
        "GR96 / EPSG Arctic zone 1-25");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-30 +x_0=25500000 +y_0=1500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 1-25\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",87],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",83.66666666666667],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",85.43711833333333],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-30],PARAMETER[\"false_easting\",25500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",1500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6050\"]]");
    p = add_epsg_def (filter, first, last, 6051, "epsg", 6051,
        "GR96 / EPSG Arctic zone 2-18");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-52 +x_0=18500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 2-18\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",83.66666666666");
    add_srs_wkt (p, 8,
        "667],PARAMETER[\"standard_parallel_2\",80.33333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",82.05842488888888],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-52],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",18500000],PARAMETER[\"false_northing\",2500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6051\"]]");
    p = add_epsg_def (filter, first, last, 6052, "epsg", 6052,
        "GR96 / EPSG Arctic zone 2-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-12 +x_0=20500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 2-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",83.66666666666");
    add_srs_wkt (p, 8,
        "667],PARAMETER[\"standard_parallel_2\",80.33333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",82.05842488888888],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-12],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",20500000],PARAMETER[\"false_northing\",2500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6052\"]]");
    p = add_epsg_def (filter, first, last, 6053, "epsg", 6053,
        "GR96 / EPSG Arctic zone 3-29");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-29\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",80.33333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",78.70733752777778],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-69],PARAMETER[\"false_easting\",29500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",3500000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6053\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

