/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.selection;

import com.google.common.collect.Lists;
import java.util.List;
import net.miginfocom.layout.UnitValue;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.header.AbstractHeaderSelectionEditPolicy;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.ILocator;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.selection.ResizeHintFigure;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DimensionSelectionEditPolicy<T extends MigDimensionInfo>
extends AbstractHeaderSelectionEditPolicy {
    protected static final String REQ_RESIZE = "resize";
    private ResizeHintFigure.SizeElement m_resizeSizeElement;
    private String m_resizeSizeUnit;
    private Figure m_lineFeedback;
    private ResizeHintFigure m_feedback;
    private ChangeBoundsRequest m_lastResizeRequest;
    protected Command m_resizeCommand;

    public DimensionSelectionEditPolicy(LayoutEditPolicy mainPolicy) {
        super(mainPolicy);
    }

    protected List<Handle> createSelectionHandles() {
        List handles = Lists.newArrayList();
        MoveHandle moveHandle = new MoveHandle(this.getHost(), (ILocator)new HeaderMoveHandleLocator());
        moveHandle.setForeground(IColorConstants.red);
        handles.add(moveHandle);
        return handles;
    }

    protected List<Handle> createStaticHandles() {
        List handles = Lists.newArrayList();
        handles.add(this.createResizeHandle());
        return handles;
    }

    protected abstract Handle createResizeHandle();

    private DimensionHeaderEditPart<T> getHostHeader() {
        return (DimensionHeaderEditPart)this.getHost();
    }

    protected final MigLayoutInfo getLayout() {
        return this.getHostHeader().getLayout();
    }

    protected final T getDimension() {
        return this.getHostHeader().getDimension();
    }

    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == REQ_RESIZE;
    }

    public Command getCommand(Request request) {
        if (!this.getLayout().canChangeDimensions()) {
            return null;
        }
        return new Command(){

            public void execute() throws Exception {
                DimensionSelectionEditPolicy.this.getHost().getViewer().getEditDomain().executeCommand(DimensionSelectionEditPolicy.this.m_resizeCommand);
            }
        };
    }

    public void showSourceFeedback(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        this.m_resizeCommand = null;
        if (this.m_lineFeedback == null) {
            this.m_lineFeedback = new Figure();
            LineBorder border = new LineBorder(IColorConstants.red, 2);
            this.m_lineFeedback.setBorder((Border)border);
            this.addFeedback(this.m_lineFeedback);
        }
        Figure hostFigure = this.getHostFigure();
        Rectangle bounds = changeBoundsRequest.getTransformedRectangle(hostFigure.getBounds());
        FigureUtils.translateFigureToAbsolute((Figure)hostFigure, (Translatable)bounds);
        this.m_lineFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Top Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new ResizeHintFigure();
            feedbackLayer.add((Figure)this.m_feedback);
            this.prepareDefaultResizeElements();
        }
        Point mouseLocation = changeBoundsRequest.getLocation().getCopy();
        Point feedbackLocation = this.getTextFeedbackLocation(mouseLocation);
        FigureUtils.translateAbsoluteToFigure((Figure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_lastResizeRequest = changeBoundsRequest;
        this.updateFeedbackText((Request)changeBoundsRequest);
    }

    private void prepareDefaultResizeElements() {
        this.m_resizeSizeElement = ResizeHintFigure.SizeElement.PREF;
        this.m_resizeSizeUnit = "";
        T dimension = this.getDimension();
        UnitValue resizeValue = ((MigDimensionInfo)dimension).getPreferredSize();
        this.m_resizeSizeElement = ResizeHintFigure.SizeElement.PREF;
        if (resizeValue == null && (resizeValue = ((MigDimensionInfo)dimension).getMinimumSize()) != null) {
            this.m_resizeSizeElement = ResizeHintFigure.SizeElement.MIN;
        }
        if (resizeValue == null && (resizeValue = ((MigDimensionInfo)dimension).getMaximumSize()) != null) {
            this.m_resizeSizeElement = ResizeHintFigure.SizeElement.MAX;
        }
        if (resizeValue != null) {
            this.m_resizeSizeUnit = resizeValue.getUnitString();
        }
    }

    private void updateFeedbackText(Request request) {
        String text;
        int pixels = this.getPixelSize(this.m_lastResizeRequest.getSizeDelta());
        final String sizeString = ((MigDimensionInfo)this.getDimension()).toUnitString(pixels, this.m_resizeSizeUnit);
        switch (this.m_resizeSizeElement) {
            case MIN: {
                text = "min := ";
                break;
            }
            case PREF: {
                text = "pref := ";
                break;
            }
            case MAX: {
                text = "max := ";
                break;
            }
            default: {
                text = "";
            }
        }
        this.m_feedback.setText(String.valueOf(text) + sizeString);
        final MigLayoutInfo layout = this.getLayout();
        this.m_resizeCommand = new EditCommand((ObjectInfo)layout){

            protected void executeEdit() throws Exception {
                Object dimension = DimensionSelectionEditPolicy.this.getDimension();
                switch (DimensionSelectionEditPolicy.this.m_resizeSizeElement) {
                    case MIN: {
                        ((MigDimensionInfo)dimension).setMinimumSize(sizeString);
                        break;
                    }
                    case PREF: {
                        ((MigDimensionInfo)dimension).setPreferredSize(sizeString);
                        break;
                    }
                    case MAX: {
                        ((MigDimensionInfo)dimension).setMaximumSize(sizeString);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                layout.writeDimensions();
            }
        };
    }

    public void eraseSourceFeedback(Request request) {
        this.removeFeedback(this.m_lineFeedback);
        this.m_lineFeedback = null;
        FigureUtils.removeFigure((Figure)this.m_feedback);
        this.m_feedback = null;
    }

    public void performRequest(Request request) {
        if (request instanceof KeyRequest) {
            char c;
            KeyRequest keyRequest = (KeyRequest)request;
            if (this.m_feedback != null) {
                String newSizeUnit;
                c = keyRequest.getCharacter();
                ResizeHintFigure.SizeElement newSizeElement = ResizeHintFigure.getNewSizeElement(c);
                if (newSizeElement != null) {
                    this.m_resizeSizeElement = newSizeElement;
                    this.updateFeedbackText(request);
                }
                if ((newSizeUnit = ResizeHintFigure.getNewSizeUnit(c)) != null) {
                    this.m_resizeSizeUnit = newSizeUnit;
                    this.updateFeedbackText(request);
                }
            }
            if (keyRequest.isPressed() && (c = keyRequest.getCharacter()) == 'g') {
                this.flipGrow();
            }
        }
    }

    protected abstract Point getTextFeedbackLocation(Point var1);

    protected abstract int getPixelSize(Dimension var1);

    private void flipGrow() {
        final MigLayoutInfo layout = this.getLayout();
        ExecutionUtils.run((ObjectInfo)layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ((MigDimensionInfo)DimensionSelectionEditPolicy.this.getDimension()).flipGrow();
                layout.writeDimensions();
            }
        });
    }

    private class HeaderMoveHandleLocator
    implements ILocator {
        private HeaderMoveHandleLocator() {
        }

        public void relocate(Figure target) {
            Figure reference = DimensionSelectionEditPolicy.this.getHostFigure();
            Rectangle bounds = reference.getBounds().getCopy();
            FigureUtils.translateFigureToFigure((Figure)reference, (Figure)target, (Translatable)bounds);
            target.setBounds(bounds);
        }
    }
}

