/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;

public class PojoMapPropertyDecorator
extends MapProperty
implements IBeanMapProperty {
    private final IMapProperty delegate;
    private final PropertyDescriptor propertyDescriptor;

    public PojoMapPropertyDecorator(IMapProperty delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public Object getKeyType() {
        return this.delegate.getKeyType();
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    protected Map doGetMap(Object source) {
        return this.delegate.getMap(source);
    }

    protected void doSetMap(Object source, Map map) {
        this.delegate.setMap(source, map);
    }

    protected void doUpdateMap(Object source, MapDiff diff) {
        this.delegate.updateMap(source, diff);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public IBeanMapProperty values(String propertyName) {
        return this.values(propertyName, null);
    }

    @Override
    public IBeanMapProperty values(String propertyName, Class valueType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.values(PojoProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public IBeanMapProperty values(IBeanValueProperty property) {
        return new PojoMapPropertyDecorator(super.values((IValueProperty)property), property.getPropertyDescriptor());
    }

    public IObservableMap observe(Object source) {
        return new BeanObservableMapDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableMap observe(Realm realm, Object source) {
        return new BeanObservableMapDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public IObservableMap observeDetail(IObservableValue master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

