/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractCreateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArchetypePage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArchetypeParametersPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArtifactPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardLocationPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class MavenProjectWizard
extends AbstractMavenProjectWizard
implements INewWizard {
    protected MavenProjectWizardLocationPage locationPage;
    protected MavenProjectWizardArchetypePage archetypePage;
    protected MavenProjectWizardArtifactPage artifactPage;
    protected MavenProjectWizardArchetypeParametersPage parametersPage;
    protected Button simpleProject;

    public MavenProjectWizard() {
        this.setWindowTitle(Messages.wizardProjectTitle);
        this.setDefaultPageImageDescriptor(MavenImages.WIZ_NEW_PROJECT);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.locationPage = new MavenProjectWizardLocationPage(this.importConfiguration, Messages.wizardProjectPageProjectTitle, Messages.wizardProjectPageProjectDescription, this.workingSets){

            @Override
            protected void createAdditionalControls(Composite container) {
                MavenProjectWizard.this.simpleProject = new Button(container, 32);
                MavenProjectWizard.this.simpleProject.setText(Messages.wizardProjectPageProjectSimpleProject);
                MavenProjectWizard.this.simpleProject.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
                MavenProjectWizard.this.simpleProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.validate();
                    }
                });
                Label label = new Label(container, 0);
                GridData labelData = new GridData(4, 128, false, false, 3, 1);
                labelData.heightHint = 10;
                label.setLayoutData((Object)labelData);
            }

            public IWizardPage getNextPage() {
                return MavenProjectWizard.this.getPage(MavenProjectWizard.this.simpleProject.getSelection() ? "MavenProjectWizardArtifactPage" : "MavenProjectWizardArchetypePage");
            }
        };
        this.locationPage.setLocationPath(SelectionUtil.getSelectedLocation(this.selection));
        this.archetypePage = new MavenProjectWizardArchetypePage(this.importConfiguration);
        this.parametersPage = new MavenProjectWizardArchetypeParametersPage(this.importConfiguration);
        this.artifactPage = new MavenProjectWizardArtifactPage(this.importConfiguration);
        this.addPage((IWizardPage)this.locationPage);
        this.addPage((IWizardPage)this.archetypePage);
        this.addPage((IWizardPage)this.parametersPage);
        this.addPage((IWizardPage)this.artifactPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.simpleProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSimpleproject = MavenProjectWizard.this.simpleProject.getSelection();
                MavenProjectWizard.this.archetypePage.setUsed(!isSimpleproject);
                MavenProjectWizard.this.parametersPage.setUsed(!isSimpleproject);
                MavenProjectWizard.this.artifactPage.setUsed(isSimpleproject);
                MavenProjectWizard.this.getContainer().updateButtons();
            }
        });
        this.archetypePage.addArchetypeSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionchangedevent) {
                MavenProjectWizard.this.parametersPage.setArchetype(MavenProjectWizard.this.archetypePage.getArchetype());
                MavenProjectWizard.this.getContainer().updateButtons();
            }
        });
    }

    public Model getModel() {
        if (this.simpleProject.getSelection()) {
            return this.artifactPage.getModel();
        }
        return this.parametersPage.getModel();
    }

    public boolean performFinish() {
        AbstractCreateMavenProjectJob job;
        final Model model = this.getModel();
        final String projectName = this.importConfiguration.getProjectName(model);
        IStatus nameStatus = this.importConfiguration.validateProjectName(model);
        if (!nameStatus.isOK()) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)projectName), (String)nameStatus.getMessage());
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IPath location = this.locationPage.isInWorkspace() ? null : this.locationPage.getLocationPath();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject project = this.importConfiguration.getProject(root, model);
        boolean pomExists = (this.locationPage.isInWorkspace() ? root.getLocation().append(project.getName()) : location).append("pom.xml").toFile().exists();
        if (pomExists) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)projectName), (String)Messages.wizardProjectErrorPomAlreadyExists);
            return false;
        }
        if (this.simpleProject.getSelection()) {
            final String[] folders = this.artifactPage.getFolders();
            job = new AbstractCreateMavenProjectJob(NLS.bind((String)Messages.wizardProjectJobCreatingProject, (Object)projectName), this.workingSets){

                @Override
                protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                    MavenPlugin.getProjectConfigurationManager().createSimpleProject(project, location, model, folders, MavenProjectWizard.this.importConfiguration, monitor);
                    return Arrays.asList(project);
                }
            };
        } else {
            final Archetype archetype = this.archetypePage.getArchetype();
            final String groupId = model.getGroupId();
            final String artifactId = model.getArtifactId();
            final String version = model.getVersion();
            final String javaPackage = this.parametersPage.getJavaPackage();
            final Properties properties = this.parametersPage.getProperties();
            job = new AbstractCreateMavenProjectJob(NLS.bind((String)Messages.wizardProjectJobCreating, (Object)archetype.getArtifactId()), this.workingSets){

                @Override
                protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                    List projects = MavenPlugin.getProjectConfigurationManager().createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, MavenProjectWizard.this.importConfiguration, monitor);
                    return projects;
                }
            };
        }
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final IStatus result = event.getResult();
                if (!result.isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)MavenProjectWizard.this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)projectName), (String)result.getMessage());
                        }
                    });
                }
                MappingDiscoveryJob discoveryJob = new MappingDiscoveryJob(job.getCreatedProjects());
                discoveryJob.schedule();
            }
        });
        job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
        job.schedule();
        return true;
    }
}

