/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.draw2d.FigureCanvas;

public class RefreshManager
implements Runnable {
    private final FigureCanvas m_canvas;
    private final Rectangle m_dirtyRegion = new Rectangle();
    private boolean m_refreshWork;
    private boolean m_requestWork;

    public RefreshManager(FigureCanvas canvas) {
        this.m_canvas = canvas;
    }

    private synchronized void refresh() {
        if (this.m_refreshWork || this.m_canvas.isDisposed()) {
            return;
        }
        try {
            this.m_refreshWork = true;
            this.m_requestWork = false;
            this.m_canvas.handleRefresh(this.m_dirtyRegion.x, this.m_dirtyRegion.y, this.m_dirtyRegion.width, this.m_dirtyRegion.height);
            this.m_dirtyRegion.setBounds(0, 0, 0, 0);
        }
        finally {
            this.m_refreshWork = false;
        }
    }

    public synchronized void refreshRequest(int x, int y, int width, int height) {
        this.m_dirtyRegion.union(x, y, width, height);
        if (!this.m_requestWork) {
            Display.getCurrent().asyncExec((Runnable)this);
            this.m_requestWork = true;
        }
    }

    public void run() {
        this.refresh();
    }
}

