/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;

public class JustifyLabel
extends Figure {
    private String m_text = "";
    private int m_wrapChars = 50;
    private int m_lineWidth;
    private boolean m_isCharMode = true;
    private List<Line> m_lines = Collections.emptyList();
    private Dimension m_preferredSize = new Dimension();

    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
        this.updateContent();
    }

    public int getWrapChars() {
        return this.m_wrapChars;
    }

    public void setWrapChars(int wrapChars) {
        this.m_wrapChars = wrapChars;
        this.m_lineWidth = 0;
        this.m_isCharMode = true;
        this.updateContent();
    }

    public int getWrapPixels() {
        return this.m_lineWidth;
    }

    public void setWrapPixels(int width) {
        this.m_lineWidth = width;
        this.m_wrapChars = 0;
        this.m_isCharMode = false;
        this.updateContent();
    }

    public boolean isCharMode() {
        return this.m_isCharMode;
    }

    protected void paintClientArea(Graphics graphics) {
        for (Line line : this.m_lines) {
            float currentX = 0.0f;
            int i = 0;
            while (i < line.words.length) {
                graphics.drawString(line.words[i], Math.round(currentX), line.startY);
                currentX += line.wordsSeparatorWidth + (float)line.widths[i];
                ++i;
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateContent();
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        GC gc = FigureUtils.createGC();
        try {
            gc.setFont(this.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            int lineWidth = this.m_isCharMode ? fontMetrics.getAverageCharWidth() * this.m_wrapChars : this.m_lineWidth;
            int lineHeight = fontMetrics.getHeight();
            this.calculatePreferredSize(lineWidth, lineHeight);
        }
        finally {
            gc.dispose();
        }
    }

    private void updateContent() {
        this.m_lines = Lists.newArrayList();
        GC gc = FigureUtils.createGC();
        try {
            gc.setFont(this.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            int lineWidth = this.m_isCharMode ? fontMetrics.getAverageCharWidth() * this.m_wrapChars : this.m_lineWidth;
            int lineHeight = fontMetrics.getHeight();
            int wordsSeparatorWidth = gc.getAdvanceWidth(' ');
            int textLength = this.m_text.length();
            int lineIndex = 0;
            int startIndex = 0;
            while (startIndex < textLength) {
                int endIndex = this.m_text.indexOf(10, startIndex);
                if (startIndex == endIndex) {
                    ++startIndex;
                } else {
                    if (endIndex == -1) {
                        endIndex = textLength;
                    }
                    String[] words = StringUtils.split((String)this.m_text.substring(startIndex, endIndex));
                    int[] widths = new int[words.length];
                    int i = 0;
                    while (i < widths.length) {
                        widths[i] = gc.stringExtent((String)words[i]).x;
                        ++i;
                    }
                    int calculateLineWidth = 0;
                    int startWordIndex = 0;
                    boolean isStartWordIndex = true;
                    int i2 = 0;
                    while (i2 < widths.length) {
                        int nextWidth = isStartWordIndex ? widths[i2] : wordsSeparatorWidth + widths[i2];
                        isStartWordIndex = false;
                        int delta = lineWidth - calculateLineWidth - nextWidth;
                        if (delta > 0) {
                            calculateLineWidth += nextWidth;
                        } else if (delta == 0) {
                            Line line = new Line(words, widths, startWordIndex, i2 + 1 - startWordIndex);
                            line.wordsSeparatorWidth = wordsSeparatorWidth;
                            line.startY = lineIndex * lineHeight;
                            this.m_lines.add(line);
                            ++lineIndex;
                            calculateLineWidth = 0;
                            isStartWordIndex = true;
                            startWordIndex = i2 + 1;
                        } else {
                            Line line;
                            int length = i2 - startWordIndex;
                            if (widths[i2] > lineWidth) {
                                length = length == 0 ? 1 : ++length;
                                line = new Line(words, widths, startWordIndex, length);
                                line.startY = lineIndex * lineHeight;
                                this.m_lines.add(line);
                                int remainderWidth = lineWidth - calculateLineWidth;
                                if (length > 1) {
                                    remainderWidth -= wordsSeparatorWidth;
                                }
                                int lineLastIndex = line.widths.length - 1;
                                String splitWord = line.words[lineLastIndex];
                                String splitWordBeforePart = null;
                                int splitWordBeforeWidth = 0;
                                int splitCharCount = splitWord.length();
                                while (splitCharCount > 0) {
                                    splitWordBeforePart = splitWord.substring(0, splitCharCount);
                                    splitWordBeforeWidth = gc.stringExtent((String)splitWordBeforePart).x;
                                    if (splitWordBeforeWidth <= remainderWidth) break;
                                    --splitCharCount;
                                }
                                line.words[lineLastIndex] = splitWordBeforePart;
                                line.widths[lineLastIndex] = splitWordBeforeWidth;
                                words[i2] = words[i2].substring(splitCharCount);
                                widths[i2] = gc.stringExtent((String)words[i2]).x;
                                line.calculateWordsSeparatorWidth(lineWidth);
                                ++lineIndex;
                                calculateLineWidth = 0;
                                isStartWordIndex = true;
                                startWordIndex = i2--;
                            } else {
                                if (length == 0) {
                                    length = 1;
                                }
                                line = new Line(words, widths, startWordIndex, length);
                                line.calculateWordsSeparatorWidth(lineWidth);
                                line.startY = lineIndex * lineHeight;
                                this.m_lines.add(line);
                                ++lineIndex;
                                calculateLineWidth = 0;
                                isStartWordIndex = true;
                                startWordIndex = i2 == startWordIndex ? i2 + 1 : i2--;
                            }
                        }
                        ++i2;
                    }
                    if (calculateLineWidth > 0) {
                        Line line = new Line(words, widths, startWordIndex, widths.length - startWordIndex);
                        line.wordsSeparatorWidth = wordsSeparatorWidth;
                        line.startY = lineIndex * lineHeight;
                        this.m_lines.add(line);
                    }
                    startIndex = endIndex + 1;
                }
                ++lineIndex;
            }
            this.calculatePreferredSize(lineWidth, lineHeight);
        }
        finally {
            gc.dispose();
        }
    }

    private void calculatePreferredSize(int lineWidth, int lineHeight) {
        this.m_preferredSize = new Dimension();
        if (!this.m_lines.isEmpty()) {
            int size = this.m_lines.size();
            Line line = this.m_lines.get(size - 1);
            if (size == 1) {
                int length = line.widths.length;
                int i = 0;
                while (i < length) {
                    this.m_preferredSize.width += line.widths[i];
                    ++i;
                }
                this.m_preferredSize.width += Math.round(line.wordsSeparatorWidth * (float)(length - 1));
            } else {
                this.m_preferredSize.width = lineWidth;
            }
            this.m_preferredSize.height = line.startY + lineHeight;
        }
        Insets insets = this.getInsets();
        this.m_preferredSize.expand(insets.getWidth(), insets.getHeight());
    }

    private static final class Line {
        final String[] words;
        final int[] widths;
        int startY;
        float wordsSeparatorWidth;

        public Line(String[] words, int[] widths, int startIndex, int length) {
            this.words = new String[length];
            System.arraycopy(words, startIndex, this.words, 0, length);
            this.widths = new int[length];
            System.arraycopy(widths, startIndex, this.widths, 0, length);
        }

        public void calculateWordsSeparatorWidth(int lineWidth) {
            if (this.widths.length > 1) {
                float lineWordsSeparatorWidth = 0.0f;
                int i = 0;
                while (i < this.widths.length) {
                    lineWordsSeparatorWidth += (float)this.widths[i];
                    ++i;
                }
                this.wordsSeparatorWidth = ((float)lineWidth - lineWordsSeparatorWidth) / (float)(this.widths.length - 1);
            }
        }
    }
}

