/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public class ProxySettingDialog
extends Dialog {
    private static final String PROXY_SET = "http.proxySet";
    private static final String PROXY_HOST = "http.proxyHost";
    private static final String PROXY_PORT = "http.proxyPort";
    private Text m_portText;
    private Text m_addressText;

    public ProxySettingDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Label hintLabel = new Label(area, 0);
        hintLabel.setText(Messages.ProxySettingDialog_hint);
        Group group = new Group(area, 0);
        group.setText(Messages.ProxySettingDialog_groupText);
        GridDataFactory.modify((Control)group).grab().fill();
        GridLayoutFactory.create((Composite)group).columns(2);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.ProxySettingDialog_addressLabel);
        this.m_addressText = new Text((Composite)group, 2048);
        this.m_addressText.setText(ProxySettingDialog.getSystemProperty(PROXY_HOST));
        GridDataFactory.create((Control)this.m_addressText).grabH().fillH();
        label = new Label((Composite)group, 0);
        label.setText(Messages.ProxySettingDialog_portLabel);
        this.m_portText = new Text((Composite)group, 2048);
        this.m_portText.setText(ProxySettingDialog.getSystemProperty(PROXY_PORT));
        GridDataFactory.create((Control)this.m_portText).grabH().fillH();
        return area;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ProxySettingDialog_title);
    }

    protected void okPressed() {
        String addressString = this.m_addressText.getText().trim();
        String portString = this.m_portText.getText().trim();
        if (addressString.length() == 0 && portString.length() == 0) {
            ProxySettingDialog.setSystemProperty(PROXY_SET, null);
            ProxySettingDialog.setSystemProperty(PROXY_HOST, null);
            ProxySettingDialog.setSystemProperty(PROXY_PORT, null);
        } else {
            boolean allOK = false;
            try {
                int port = Integer.parseInt(portString);
                allOK = port > 0 && port < 65536;
            }
            catch (Throwable throwable) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ProxySettingDialog_errPortTitle, (String)Messages.ProxySettingDialog_errPortMessage);
                return;
            }
            boolean bl = allOK = addressString.length() > 0;
            if (!allOK) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ProxySettingDialog_errAddressTitle, (String)Messages.ProxySettingDialog_arrAddressMessage);
                return;
            }
            ProxySettingDialog.setSystemProperty(PROXY_SET, "true");
            ProxySettingDialog.setSystemProperty(PROXY_HOST, addressString);
            ProxySettingDialog.setSystemProperty(PROXY_PORT, portString);
        }
        super.okPressed();
    }

    private static String getSystemProperty(String key) {
        Object value = System.getProperties().get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static void setSystemProperty(String key, String value) {
        Properties properties = System.getProperties();
        if (value != null && value.length() > 0) {
            properties.setProperty(key, value);
        } else {
            properties.remove(key);
        }
    }
}

