/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.questionnaire;

import org.eclipse.oomph.setup.ui.questionnaire.AnimatedCanvas;
import org.eclipse.oomph.setup.ui.questionnaire.AnimatedShell;
import org.eclipse.oomph.setup.ui.questionnaire.GearAnimator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExitShell
extends AnimatedShell<Boolean> {
    public static final int NONE = -1;
    private static final int WIDTH = 550;
    private static final int HEIGHT = 450;
    private static final int BORDER = 30;
    private static final int BIG_FONT_PX = 48;
    private static final String[] LINES = new String[]{"This one-time questionnaire will not automatically pop up again.", "You can take the questionnaire later via the Oomph Setup preferences:"};
    private final GearAnimator gearAnimator;

    public ExitShell(GearAnimator gearAnimator) {
        super(gearAnimator.getCanvas().getShell(), 65536);
        this.gearAnimator = gearAnimator;
        Rectangle bounds = gearAnimator.getCanvas().getShell().getBounds();
        this.setLocation(bounds.x + (bounds.width - 550) / 2, bounds.y + (bounds.height - 450) / 2);
        this.setSize(550, 450);
    }

    @Override
    protected void init() {
        super.init();
        ExitAnimator animator = new ExitAnimator(this.getDisplay());
        this.getCanvas().addAnimator(animator);
    }

    private static boolean shouldShowOverlay() {
        return (System.currentTimeMillis() / 500L & 1L) == 1L;
    }

    public class ExitAnimator
    extends AnimatedCanvas.Animator {
        private boolean oldShowOverlay;
        private Font font;
        private int fontPx;
        private Color purple;
        private Image image;
        private Image image_ovr;
        private Rectangle[] boxes;
        private int hover;
        private int oldHover;
        private int choice;

        public ExitAnimator(Display display) {
            super(display);
            this.boxes = new Rectangle[2];
            this.hover = -1;
            this.oldHover = -1;
            this.choice = -1;
        }

        public final int getChoice() {
            return this.choice;
        }

        protected void init() {
            super.init();
            this.font = this.createFont(42, 490, LINES);
            this.fontPx = this.font.getFontData()[0].getHeight();
            this.purple = this.createColor(43, 34, 84);
            this.image = this.loadImage("exit_page.png");
            this.image_ovr = this.loadImage("exit_page_ovr.png");
        }

        protected boolean onKeyPressed(KeyEvent e) {
            if (e.character == '\r') {
                this.finish(true);
                return true;
            }
            if (e.keyCode == 27) {
                this.finish(false);
                return true;
            }
            return super.onKeyPressed(e);
        }

        protected boolean onMouseMove(int x, int y) {
            this.hover = this.getAnswer(x, y);
            if (this.hover != -1) {
                return true;
            }
            return super.onMouseMove(x, y);
        }

        protected boolean onMouseDown(int x, int y) {
            this.choice = this.getAnswer(x, y);
            if (this.choice != -1) {
                this.finish(this.choice == 0);
                return true;
            }
            return super.onMouseDown(x, y);
        }

        private void finish(boolean exit) {
            ExitShell shell = (ExitShell)this.getCanvas().getShell();
            shell.setResult(exit);
            shell.dispose();
        }

        protected boolean advance() {
            if (this.hover != this.oldHover) {
                return true;
            }
            return ExitShell.shouldShowOverlay() ^ this.oldShowOverlay;
        }

        protected void paint(GC gc, Image buffer) {
            int cX = 275;
            gc.setForeground(this.purple);
            gc.setFont(ExitShell.this.gearAnimator.getBigFont());
            ExitAnimator.drawText(gc, cX, 30 + this.fontPx, "Exit Questionnaire?");
            gc.setFont(this.font);
            ExitAnimator.drawText(gc, cX, 108.0, LINES[0]);
            ExitAnimator.drawText(gc, cX, 108 + this.fontPx + 8, LINES[1]);
            int x = cX - this.image.getBounds().width / 2;
            int y = 108 + 2 * (this.fontPx + 8);
            gc.drawImage(this.image, x, y);
            this.oldShowOverlay = ExitShell.shouldShowOverlay();
            if (this.oldShowOverlay) {
                gc.drawImage(this.image_ovr, x + 133, y + 105);
            }
            int answerY = 420 - this.fontPx;
            gc.setForeground(this.purple);
            gc.setFont(this.hover == 0 ? ExitShell.this.gearAnimator.getHoverFont() : ExitShell.this.gearAnimator.getBigFont());
            this.boxes[0] = ExitAnimator.drawText(gc, cX - 90, answerY, "Exit Now");
            gc.setFont(this.hover == 1 ? ExitShell.this.gearAnimator.getHoverFont() : ExitShell.this.gearAnimator.getBigFont());
            this.boxes[1] = ExitAnimator.drawText(gc, cX + 90, answerY, "Go Back");
            this.oldHover = this.hover;
        }

        private int getAnswer(int x, int y) {
            int i = 0;
            while (i < this.boxes.length) {
                Rectangle box = this.boxes[i];
                if (box != null && box.contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

