/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.epp.internal.mpc.core.ServiceHelperImpl;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class MarketplaceClientCorePlugin
implements BundleActivator {
    private static MarketplaceClientCorePlugin instance;
    private Bundle bundle;
    private List<ServiceRegistration<?>> serviceRegistrations;
    private ServiceHelperImpl serviceHelper;

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
        instance = this;
        ProxyHelper.acquireProxyService();
        this.registerServices(context);
        this.serviceHelper = new ServiceHelperImpl();
        this.serviceHelper.startTracking(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceHelper.stopTracking(context);
        this.serviceHelper = null;
        this.unregisterServices();
        ProxyHelper.releaseProxyService();
        instance = null;
    }

    private void registerServices(BundleContext context) {
        ArrayList serviceRegistrations = new ArrayList();
        this.serviceRegistrations = serviceRegistrations;
        List<ITransportFactory> factories = TransportFactory.listAvailableFactories();
        int prio = 100 * factories.size();
        for (ITransportFactory factory : factories) {
            Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
            properties.put("service.ranking", prio -= 100);
            ServiceRegistration registration = context.registerService(ITransportFactory.class, (Object)factory, properties);
            serviceRegistrations.add(registration);
        }
    }

    private void unregisterServices() {
        List<ServiceRegistration<?>> serviceRegistrations = this.serviceRegistrations;
        this.serviceRegistrations = null;
        if (serviceRegistrations != null) {
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }

    public ServiceHelperImpl getServiceHelper() {
        return this.serviceHelper;
    }

    public static MarketplaceClientCorePlugin getDefault() {
        return instance;
    }

    public static Bundle getBundle() {
        return instance == null ? null : MarketplaceClientCorePlugin.instance.bundle;
    }
}

