/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.gson;

import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.gson.FieldNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.FileTypeAdapter;
import org.eclipse.recommenders.utils.gson.ISO8601DateParser;
import org.eclipse.recommenders.utils.gson.MethodNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.MultimapTypeAdapter;
import org.eclipse.recommenders.utils.gson.MultisetTypeAdapterFactory;
import org.eclipse.recommenders.utils.gson.PackageNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.TypeNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.UuidTypeAdapter;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmFieldName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmPackageName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class GsonUtil {
    public static final Type T_LIST_STRING = new TypeToken<List<String>>(){}.getType();
    private static Gson gson;

    public static synchronized Gson getInstance() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(VmMethodName.class, (Object)new MethodNameTypeAdapter());
            builder.registerTypeAdapter(IMethodName.class, (Object)new MethodNameTypeAdapter());
            builder.registerTypeAdapter(VmTypeName.class, (Object)new TypeNameTypeAdapter());
            builder.registerTypeAdapter(ITypeName.class, (Object)new TypeNameTypeAdapter());
            builder.registerTypeAdapter(VmFieldName.class, (Object)new FieldNameTypeAdapter());
            builder.registerTypeAdapter(IFieldName.class, (Object)new FieldNameTypeAdapter());
            builder.registerTypeAdapter(VmPackageName.class, (Object)new PackageNameTypeAdapter());
            builder.registerTypeAdapter(IPackageName.class, (Object)new PackageNameTypeAdapter());
            builder.registerTypeAdapter(File.class, (Object)new FileTypeAdapter());
            builder.registerTypeAdapter(UUID.class, (Object)new UuidTypeAdapter());
            builder.registerTypeAdapter(Date.class, (Object)new ISO8601DateParser());
            builder.registerTypeAdapter(Multimap.class, (Object)new MultimapTypeAdapter());
            builder.registerTypeAdapterFactory((TypeAdapterFactory)new MultisetTypeAdapterFactory());
            builder.enableComplexMapKeySerialization();
            builder.setPrettyPrinting();
            gson = builder.create();
        }
        return gson;
    }

    public static <T> T deserialize(CharSequence json, Type classOfT) {
        return GsonUtil.deserialize(json.toString(), classOfT);
    }

    public static <T> T deserialize(String json, Type classOfT) {
        Objects.requireNonNull(json);
        Objects.requireNonNull(classOfT);
        try {
            return (T)GsonUtil.getInstance().fromJson(json, classOfT);
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
    }

    public static <T> T deserialize(File jsonFile, Type classOfT) {
        T t;
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(classOfT);
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(jsonFile));
            t = GsonUtil.deserialize(in, classOfT);
        }
        catch (Exception e) {
            try {
                throw Throws.throwUnhandledException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return t;
    }

    public static <T> T deserialize(InputStream jsonStream, Type classOfT) {
        Object object;
        Objects.requireNonNull(jsonStream);
        Objects.requireNonNull(classOfT);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(jsonStream, StandardCharsets.UTF_8);
            object = GsonUtil.getInstance().fromJson((Reader)reader, classOfT);
        }
        catch (Exception e) {
            try {
                throw Throws.throwUnhandledException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return (T)object;
    }

    public static String serialize(Object obj) {
        Objects.requireNonNull(obj);
        StringBuilder sb = new StringBuilder();
        GsonUtil.serialize(obj, sb);
        return sb.toString();
    }

    public static void serialize(Object obj, Appendable writer) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(writer);
        try {
            GsonUtil.getInstance().toJson(obj, writer);
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
    }

    public static void serialize(Object obj, File jsonFile) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(jsonFile);
        BufferedOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(jsonFile));
                GsonUtil.serialize(obj, out);
            }
            catch (Exception e) {
                throw Throws.throwUnhandledException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
    }

    public static void serialize(Object obj, OutputStream out) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(out);
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
                GsonUtil.getInstance().toJson(obj, (Appendable)writer);
            }
            catch (Exception e) {
                throw Throws.throwUnhandledException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
    }

    public static <T> List<T> deserializeZip(File zip, Class<T> classOfT) throws IOException {
        LinkedList<T> res = new LinkedList<T>();
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            InputSupplier fis = Files.newInputStreamSupplier((File)zip);
            zis = new ZipInputStream((InputStream)fis.getInput());
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                res.add(GsonUtil.deserialize(zis, classOfT));
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)true);
        return res;
    }
}

