/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.SearchExpression;
import org.eclipse.m2e.core.internal.index.SourcedSearchExpression;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaProjectConversionParticipant
extends AbstractProjectConversionParticipant {
    private static final Logger log = LoggerFactory.getLogger(JavaProjectConversionParticipant.class);
    private static final String DEFAULT_JAVA_SOURCE = "src/main/java";
    private static final String DEFAULT_RESOURCES = "src/main/resources";
    private static final String DEFAULT_JAVA_TEST_SOURCE = "src/test/java";
    private static final String DEFAULT_TEST_RESOURCES = "src/test/resources";
    private static final String DEFAULT_JAVA_VERSION = "1.5";
    private static final String COMPILER_GROUP_ID = "org.apache.maven.plugins";
    private static final String COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
    private static final String DEFAULT_COMPILER_VERSION = "3.3";
    private static final String TARGET_KEY = "target";
    private static final String SOURCE_KEY = "source";
    private static final String CONFIGURATION_KEY = "configuration";

    public boolean accept(IProject project) throws CoreException {
        boolean accepts = project != null && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        return accepts;
    }

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project)) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return;
        }
        log.debug("Applying Java conversion to " + project.getName());
        this.configureBuildSourceDirectories(model, javaProject);
        String source = javaProject.getOption("org.eclipse.jdt.core.compiler.source", false);
        String target = javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", false);
        if (DEFAULT_JAVA_VERSION.equals(source) && DEFAULT_JAVA_VERSION.equals(target)) {
            return;
        }
        boolean useProperties = false;
        if (useProperties) {
            this.configureProperties(model, source, target);
        } else {
            this.configureCompilerPlugin(model, source, target);
        }
    }

    private void configureProperties(Model model, String source, String target) {
        Properties properties = model.getProperties();
        if (properties == null) {
            properties = new Properties();
            model.setProperties(properties);
        }
        properties.setProperty("maven.compiler.source", source);
        properties.setProperty("maven.compiler.target", target);
    }

    private void configureCompilerPlugin(Model model, String source, String target) {
        Xpp3Dom sourceDom;
        Build build = this.getOrCreateBuild(model);
        model.setBuild(build);
        Plugin compiler = this.getOrCreateCompilerPlugin(build);
        Xpp3Dom configuration = (Xpp3Dom)compiler.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom(CONFIGURATION_KEY);
            compiler.setConfiguration((Object)configuration);
        }
        if ((sourceDom = configuration.getChild(SOURCE_KEY)) == null) {
            sourceDom = new Xpp3Dom(SOURCE_KEY);
            configuration.addChild(sourceDom);
        }
        sourceDom.setValue(source);
        Xpp3Dom targetDom = configuration.getChild(TARGET_KEY);
        if (targetDom == null) {
            targetDom = new Xpp3Dom(TARGET_KEY);
            configuration.addChild(targetDom);
        }
        targetDom.setValue(target);
        compiler.setConfiguration((Object)configuration);
    }

    private Plugin getOrCreateCompilerPlugin(Build build) {
        build.flushPluginMap();
        Plugin compiler = (Plugin)build.getPluginsAsMap().get("org.apache.maven.plugins:maven-compiler-plugin");
        if (compiler == null) {
            compiler = (Plugin)build.getPluginsAsMap().get(COMPILER_ARTIFACT_ID);
        }
        if (compiler == null) {
            compiler = new Plugin();
            compiler.setGroupId(COMPILER_GROUP_ID);
            compiler.setArtifactId(COMPILER_ARTIFACT_ID);
            compiler.setVersion(this.getCompilerVersion());
            build.addPlugin(compiler);
        }
        return compiler;
    }

    private void configureBuildSourceDirectories(Model model, IJavaProject javaProject) throws CoreException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        LinkedHashSet<String> potentialTestSources = new LinkedHashSet<String>();
        LinkedHashSet<String> potentialResourceDirectories = new LinkedHashSet<String>();
        LinkedHashSet<String> potentialTestResourceDirectories = new LinkedHashSet<String>();
        IPath projectPath = javaProject.getPath();
        int i = 0;
        while (i < entries.length) {
            IPath path;
            if (entries[i].getEntryKind() == 3 && !(path = entries[i].getPath().makeRelativeTo(projectPath)).isAbsolute()) {
                String portablePath = path.toPortableString();
                boolean isPotentialTestSource = this.isPotentialTestSource(path);
                boolean isResource = false;
                if (isPotentialTestSource) {
                    if (DEFAULT_TEST_RESOURCES.equals(portablePath)) {
                        isResource = potentialTestResourceDirectories.add(portablePath);
                    } else {
                        potentialTestSources.add(portablePath);
                    }
                } else if (DEFAULT_RESOURCES.equals(portablePath)) {
                    isResource = potentialResourceDirectories.add(portablePath);
                } else {
                    sources.add(portablePath);
                }
                if (!isResource) {
                    boolean hasNonJavaResources = false;
                    IFolder folder = javaProject.getProject().getFolder(path);
                    if (folder.isAccessible()) {
                        NonJavaResourceVisitor nonJavaResourceVisitor = new NonJavaResourceVisitor();
                        try {
                            folder.accept((IResourceVisitor)nonJavaResourceVisitor);
                        }
                        catch (NonJavaResourceFoundException nonJavaResourceFoundException) {
                            hasNonJavaResources = true;
                        }
                        catch (CoreException ex) {
                            if (ex.getCause() instanceof NonJavaResourceFoundException) {
                                hasNonJavaResources = true;
                            }
                            log.error("An error occured while analysing {} : {}", (Object)folder, (Object)ex.getMessage());
                        }
                    }
                    if (hasNonJavaResources) {
                        if (isPotentialTestSource) {
                            potentialTestResourceDirectories.add(portablePath);
                        } else {
                            potentialResourceDirectories.add(portablePath);
                        }
                    }
                }
            }
            ++i;
        }
        Build build = this.getOrCreateBuild(model);
        if (!sources.isEmpty()) {
            String sourceDirectory;
            if (sources.size() > 1) {
                log.warn("{} has multiple source entries, this is not supported yet", (Object)model.getArtifactId());
            }
            if (!DEFAULT_JAVA_SOURCE.equals(sourceDirectory = (String)sources.iterator().next())) {
                build.setSourceDirectory(sourceDirectory);
            }
            for (String resourceDirectory : potentialResourceDirectories) {
                if (DEFAULT_RESOURCES.equals(resourceDirectory) && potentialResourceDirectories.size() <= 1) continue;
                build.addResource(this.createResource(resourceDirectory));
            }
        }
        if (!potentialTestSources.isEmpty()) {
            String testSourceDirectory;
            if (potentialTestSources.size() > 1) {
                log.warn("{} has multiple test source entries, this is not supported yet", (Object)model.getArtifactId());
            }
            if (!DEFAULT_JAVA_TEST_SOURCE.equals(testSourceDirectory = (String)potentialTestSources.iterator().next())) {
                build.setTestSourceDirectory(testSourceDirectory);
            }
            for (String resourceDirectory : potentialTestResourceDirectories) {
                if (DEFAULT_TEST_RESOURCES.equals(resourceDirectory) && potentialTestResourceDirectories.size() <= 1) continue;
                build.addTestResource(this.createResource(resourceDirectory));
            }
        }
        if (build.getSourceDirectory() != null || build.getTestSourceDirectory() != null || !build.getResources().isEmpty() || !build.getTestResources().isEmpty()) {
            model.setBuild(build);
        }
    }

    private Resource createResource(String resourceDirectory) {
        Resource r = new Resource();
        r.setDirectory(resourceDirectory);
        r.addExclude("**/*.java");
        return r;
    }

    private boolean isPotentialTestSource(IPath path) {
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            String folderName = segment.toLowerCase();
            if (folderName.matches(".*tests?")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Build getOrCreateBuild(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
        }
        return build;
    }

    private String getCompilerVersion() {
        String version = System.getProperty("org.eclipse.m2e.jdt.conversion.compiler.version");
        if (version != null) {
            return version;
        }
        return this.getMostRecentPluginVersion(COMPILER_GROUP_ID, COMPILER_ARTIFACT_ID, DEFAULT_COMPILER_VERSION);
    }

    private String getMostRecentPluginVersion(String groupId, String artifactId, String referenceVersion) {
        Assert.isNotNull((Object)groupId, (String)"groupId can not be null");
        Assert.isNotNull((Object)artifactId, (String)"artifactId can not be null");
        String version = referenceVersion;
        String partialKey = String.valueOf(artifactId) + " : " + groupId;
        try {
            IIndex index = MavenPlugin.getIndexManager().getAllIndexes();
            SourcedSearchExpression a = new SourcedSearchExpression(artifactId);
            Map values = index.search((SearchExpression)a, "plugin");
            if (!values.isEmpty()) {
                TreeSet<ComparableVersion> versions = new TreeSet<ComparableVersion>();
                ComparableVersion referenceComparableVersion = referenceVersion == null ? null : new ComparableVersion(referenceVersion);
                for (Map.Entry e : values.entrySet()) {
                    if (!((String)e.getKey()).endsWith(partialKey)) continue;
                    for (IndexedArtifactFile f : ((IndexedArtifact)e.getValue()).getFiles()) {
                        if (!groupId.equals(f.group) || !artifactId.equals(f.artifact) || f.version.contains("SNAPSHOT")) continue;
                        ComparableVersion v = new ComparableVersion(f.version);
                        if (referenceComparableVersion != null && v.compareTo(referenceComparableVersion) <= 0) continue;
                        versions.add(v);
                    }
                    if (versions.isEmpty()) continue;
                    ArrayList<String> sorted = new ArrayList<String>(versions.size());
                    for (ComparableVersion v : versions) {
                        sorted.add(v.toString());
                    }
                    Collections.reverse(sorted);
                    version = (String)sorted.iterator().next();
                }
            }
        }
        catch (CoreException e) {
            log.error("Can not retrieve latest version of " + partialKey, (Throwable)e);
        }
        return version;
    }

    private static class NonJavaResourceFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class NonJavaResourceVisitor
    implements IResourceVisitor {
        private static final List<String> IGNORED_EXTENSIONS = Arrays.asList(".svn");

        public boolean visit(IResource resource) throws CoreException {
            IFile file;
            String resourceName = resource.getProjectRelativePath().lastSegment();
            if (resource.isHidden() || this.isIgnored(resourceName)) {
                return false;
            }
            if (resource instanceof IFile && !"java".equals((file = (IFile)resource).getFileExtension())) {
                throw new NonJavaResourceFoundException();
            }
            return true;
        }

        private boolean isIgnored(String resourceName) {
            for (String extension : IGNORED_EXTENSIONS) {
                if (!resourceName.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

