/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.editors;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.property.value.SelfValueProperty;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.injection.InjectionService;
import org.eclipse.recommenders.internal.models.rcp.ProjectCoordinateSelectionDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetEditorDiscoveryUtils;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.EditorUtils;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.DatabindingConverters;
import org.eclipse.recommenders.rcp.utils.ObjectToBooleanConverter;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.Browsers;
import org.eclipse.recommenders.utils.rcp.Selections;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SnippetMetadataPage
extends FormPage {
    private static final Location[] SNIPMATCH_LOCATIONS = new Location[]{Location.FILE, Location.JAVA_FILE, Location.JAVA, Location.JAVA_STATEMENTS, Location.JAVA_TYPE_MEMBERS, Location.JAVADOC};
    public static final String TEXT_SNIPPETNAME = "org.eclipse.recommenders.snipmatch.rcp.snippetmetadatapage.snippetname";
    private ISnippet snippet;
    private AbstractFormPart contentsPart;
    private Text txtName;
    private Text txtDescription;
    private ComboViewer comboLocation;
    private Text txtUuid;
    private ListViewer listViewerFilenameRestrictions;
    private ListViewer listViewerExtraSearchTerms;
    private ListViewer listViewerTags;
    private ListViewer listViewerDependencies;
    private Composite filenameRestrictionsButtonContainer;
    private Composite extraSearchTermsButtonContainer;
    private Composite tagsButtonContainer;
    private Composite dependenciesButtonContainer;
    private Button btnAddFilenameRestriction;
    private Button btnRemoveFilenameRestriction;
    private Button btnRemoveExtraSearchTerm;
    private Button btnRemoveTag;
    private Button btnRemoveDependency;
    private IObservableSet ppDependencies;
    private IObservableList ppExtraSearchTerms;
    private IObservableList ppFilenameRestrictions;
    private IObservableList ppTags;
    private DataBindingContext context;
    private final Image errorDecorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    private final Image infoDecorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();

    public SnippetMetadataPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        this.createHeader(form);
        Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(3, false));
        this.contentsPart = new AbstractFormPart(){

            public void initialize(IManagedForm managedForm) {
                super.initialize(managedForm);
                int horizontalIndent = ((SnippetMetadataPage)SnippetMetadataPage.this).errorDecorationImage.getBounds().width + 2;
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_NAME);
                SnippetMetadataPage.this.txtName = this.createTextField(managedForm, SnippetMetadataPage.this.snippet.getName(), Messages.EDITOR_TEXT_MESSAGE_SNIPPET_NAME, horizontalIndent);
                SnippetMetadataPage.this.txtName.setData("org.eclipse.swtbot.widget.key", (Object)SnippetMetadataPage.TEXT_SNIPPETNAME);
                final ControlDecoration nameDecoration = this.createDecoration((Control)SnippetMetadataPage.this.txtName, Messages.ERROR_SNIPPET_NAME_CANNOT_BE_EMPTY, SnippetMetadataPage.this.errorDecorationImage, 16384);
                SnippetMetadataPage.this.txtName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        if (Strings.isNullOrEmpty((String)SnippetMetadataPage.this.txtName.getText())) {
                            nameDecoration.show();
                        } else {
                            nameDecoration.hide();
                        }
                    }
                });
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_DESCRIPTION);
                SnippetMetadataPage.this.txtDescription = this.createTextField(managedForm, SnippetMetadataPage.this.snippet.getDescription(), Messages.EDITOR_TEXT_MESSAGE_SNIPPET_DESCRIPTION, horizontalIndent);
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_LOCATION);
                SnippetMetadataPage.this.comboLocation = new ComboViewer(managedForm.getForm().getBody(), 12);
                managedForm.getToolkit().adapt((Control)SnippetMetadataPage.this.comboLocation.getCombo(), true, true);
                SnippetMetadataPage.this.comboLocation.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                SnippetMetadataPage.this.comboLocation.setInput((Object)SNIPMATCH_LOCATIONS);
                SnippetMetadataPage.this.comboLocation.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof Location) {
                            Location location = (Location)element;
                            switch (location) {
                                case FILE: {
                                    return Messages.SNIPMATCH_LOCATION_FILE;
                                }
                                case JAVA_FILE: {
                                    return Messages.SNIPMATCH_LOCATION_JAVA_FILE;
                                }
                                case JAVA: {
                                    return Messages.SNIPMATCH_LOCATION_JAVA;
                                }
                                case JAVA_STATEMENTS: {
                                    return Messages.SNIPMATCH_LOCATION_JAVA_STATEMENTS;
                                }
                                case JAVA_TYPE_MEMBERS: {
                                    return Messages.SNIPMATCH_LOCATION_JAVA_MEMBERS;
                                }
                                case JAVADOC: {
                                    return Messages.SNIPMATCH_LOCATION_JAVADOC;
                                }
                            }
                        }
                        return super.getText(element);
                    }
                });
                SnippetMetadataPage.this.comboLocation.getCombo().setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).indent(horizontalIndent, 0).create());
                final ControlDecoration locationErrorDecoration = this.createDecoration((Control)SnippetMetadataPage.this.comboLocation.getCombo(), String.valueOf(Messages.ERROR_SNIPPET_LOCATION_CANNOT_BE_EMPTY) + "\n" + Messages.EDITOR_DESCRIPTION_LOCATION, SnippetMetadataPage.this.errorDecorationImage, 16384);
                final ControlDecoration locationDescriptionDecoration = this.createDecoration((Control)SnippetMetadataPage.this.comboLocation.getCombo(), Messages.EDITOR_DESCRIPTION_LOCATION, SnippetMetadataPage.this.infoDecorationImage, 16384);
                SnippetMetadataPage.this.comboLocation.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection().isEmpty()) {
                            locationErrorDecoration.show();
                            locationDescriptionDecoration.hide();
                        } else {
                            locationErrorDecoration.hide();
                            locationDescriptionDecoration.show();
                        }
                    }
                });
                SnippetMetadataPage.this.comboLocation.setSelection((ISelection)new StructuredSelection((Object)SnippetMetadataPage.this.snippet.getLocation()));
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_FILENAME_RESTRICTIONS);
                SnippetMetadataPage.this.listViewerFilenameRestrictions = this.createListViewer(managedForm, horizontalIndent);
                this.createDecoration((Control)SnippetMetadataPage.this.listViewerFilenameRestrictions.getList(), Messages.EDITOR_DESCRIPTION_FILENAME_RESTRICTIONS, SnippetMetadataPage.this.infoDecorationImage, 16512);
                SnippetMetadataPage.this.filenameRestrictionsButtonContainer = this.createButtonContainer(managedForm);
                SnippetMetadataPage.this.btnAddFilenameRestriction = this.createButton(managedForm, SnippetMetadataPage.this.filenameRestrictionsButtonContainer, Messages.EDITOR_BUTTON_ADD, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SnippetMetadataPage.this.createFilenameRestrictionInputDialog(SnippetMetadataPage.this.filenameRestrictionsButtonContainer.getShell()).open();
                    }
                });
                SnippetMetadataPage.this.btnAddFilenameRestriction.setEnabled(SnippetMetadataPage.this.snippet.getLocation() == Location.FILE);
                SnippetMetadataPage.this.btnRemoveFilenameRestriction = this.createButton(managedForm, SnippetMetadataPage.this.filenameRestrictionsButtonContainer, Messages.EDITOR_BUTTON_REMOVE, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerFilenameRestrictions);
                        if (o.isPresent()) {
                            SnippetMetadataPage.this.ppFilenameRestrictions.remove(o.get());
                        }
                    }
                });
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_EXTRA_SEARCH_TERMS);
                SnippetMetadataPage.this.listViewerExtraSearchTerms = this.createListViewer(managedForm, horizontalIndent);
                this.createDecoration((Control)SnippetMetadataPage.this.listViewerExtraSearchTerms.getList(), Messages.EDITOR_DESCRIPTION_EXTRA_SEARCH_TERMS, SnippetMetadataPage.this.infoDecorationImage, 16512);
                SnippetMetadataPage.this.extraSearchTermsButtonContainer = this.createButtonContainer(managedForm);
                this.createButton(managedForm, SnippetMetadataPage.this.extraSearchTermsButtonContainer, Messages.EDITOR_BUTTON_ADD, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SnippetMetadataPage.this.createExtraSearchTermInputDialog(SnippetMetadataPage.this.extraSearchTermsButtonContainer.getShell()).open();
                    }
                });
                SnippetMetadataPage.this.btnRemoveExtraSearchTerm = this.createButton(managedForm, SnippetMetadataPage.this.extraSearchTermsButtonContainer, Messages.EDITOR_BUTTON_REMOVE, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerExtraSearchTerms);
                        if (o.isPresent()) {
                            SnippetMetadataPage.this.ppExtraSearchTerms.remove(o.get());
                        }
                    }
                });
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_TAG);
                SnippetMetadataPage.this.listViewerTags = this.createListViewer(managedForm, horizontalIndent);
                this.createDecoration((Control)SnippetMetadataPage.this.listViewerTags.getList(), Messages.EDITOR_DESCRIPTION_TAGS, SnippetMetadataPage.this.infoDecorationImage, 16512);
                SnippetMetadataPage.this.tagsButtonContainer = this.createButtonContainer(managedForm);
                this.createButton(managedForm, SnippetMetadataPage.this.tagsButtonContainer, Messages.EDITOR_BUTTON_ADD, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SnippetMetadataPage.this.createTagInputDialog(SnippetMetadataPage.this.tagsButtonContainer.getShell()).open();
                    }
                });
                SnippetMetadataPage.this.btnRemoveTag = this.createButton(managedForm, SnippetMetadataPage.this.tagsButtonContainer, Messages.EDITOR_BUTTON_REMOVE, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerTags);
                        if (o.isPresent()) {
                            SnippetMetadataPage.this.ppTags.remove(o.get());
                        }
                    }
                });
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_DEPENDENCIES);
                SnippetMetadataPage.this.listViewerDependencies = this.createListViewer(managedForm, horizontalIndent);
                this.createDecoration((Control)SnippetMetadataPage.this.listViewerDependencies.getList(), Messages.EDITOR_DESCRIPTION_DEPENDENCIES, SnippetMetadataPage.this.infoDecorationImage, 16512);
                SnippetMetadataPage.this.dependenciesButtonContainer = this.createButtonContainer(managedForm);
                this.createButton(managedForm, SnippetMetadataPage.this.dependenciesButtonContainer, Messages.EDITOR_BUTTON_ADD, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = SnippetMetadataPage.this.dependenciesButtonContainer.getShell();
                        ProjectCoordinateSelectionDialog dialog = new ProjectCoordinateSelectionDialog(shell){
                            private final Set<String> alreadyAddedPcLabels;
                            {
                                this.alreadyAddedPcLabels = Sets.newHashSet();
                            }

                            public String createLabelForProjectCoordinate(ProjectCoordinate element) {
                                return SnippetMetadataPage.this.getStringForDependency(element);
                            }

                            public boolean filter(ProjectCoordinate pc) {
                                for (String dependencylistItem : SnippetMetadataPage.this.fetchDependencyListItems()) {
                                    if (!dependencylistItem.equals(SnippetMetadataPage.this.getStringForDependency(pc))) continue;
                                    return true;
                                }
                                String labelForPc = this.createLabelForProjectCoordinate(pc);
                                if (this.alreadyAddedPcLabels.contains(labelForPc)) {
                                    return true;
                                }
                                this.alreadyAddedPcLabels.add(labelForPc);
                                return false;
                            }
                        };
                        dialog.setInitialPattern("");
                        dialog.setTitle(Messages.DIALOG_TITLE_SELECT_DEPENDENCY);
                        dialog.setMessage(Messages.DIALOG_MESSAGE_SELECT_DEPENDENCY);
                        dialog.open();
                        Set selectedElements = SnippetMetadataPage.this.changeVersionsToZero(dialog.getSelectedElements());
                        SnippetMetadataPage.this.ppDependencies.addAll((Collection)selectedElements);
                    }
                });
                SnippetMetadataPage.this.btnRemoveDependency = this.createButton(managedForm, SnippetMetadataPage.this.dependenciesButtonContainer, Messages.EDITOR_BUTTON_REMOVE, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Optional o = Selections.getFirstSelected((Viewer)SnippetMetadataPage.this.listViewerDependencies);
                        if (o.isPresent()) {
                            SnippetMetadataPage.this.ppDependencies.remove(o.get());
                        }
                    }
                });
                this.createLabel(managedForm, Messages.EDITOR_LABEL_SNIPPET_UUID);
                SnippetMetadataPage.this.txtUuid = managedForm.getToolkit().createText(managedForm.getForm().getBody(), SnippetMetadataPage.this.snippet.getUuid().toString(), 8);
                SnippetMetadataPage.this.txtUuid.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(horizontalIndent, 0).create());
            }

            private void createLabel(IManagedForm managedForm, String text) {
                Label label = managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), text, 0);
                label.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
            }

            private Text createTextField(IManagedForm managedForm, String value, String message, int horizontalIndent) {
                Text text = managedForm.getToolkit().createText(managedForm.getForm().getBody(), value, 0);
                text.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).indent(horizontalIndent, 0).create());
                text.setMessage(message);
                return text;
            }

            private ControlDecoration createDecoration(Control control, String description, Image image, int style) {
                ControlDecoration decoration = new ControlDecoration(control, style);
                decoration.setDescriptionText(description);
                decoration.setImage(image);
                decoration.setMarginWidth(1);
                return decoration;
            }

            private ListViewer createListViewer(IManagedForm managedForm, int horizontalIndent) {
                ListViewer listViewer = new ListViewer(managedForm.getForm().getBody(), 2560);
                List lstFilenames = listViewer.getList();
                lstFilenames.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(horizontalIndent, 0).create());
                return listViewer;
            }

            private Composite createButtonContainer(IManagedForm managedForm) {
                Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
                container.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                managedForm.getToolkit().paintBordersFor(container);
                container.setLayout((Layout)new GridLayout(1, false));
                return container;
            }

            private Button createButton(IManagedForm managedForm, Composite parent, String label, SelectionListener listener) {
                Button button = managedForm.getToolkit().createButton(parent, label, 0);
                button.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
                button.addSelectionListener(listener);
                return button;
            }

            public void commit(boolean onSave) {
                if (onSave) {
                    super.commit(onSave);
                }
            }

            public void refresh() {
                SnippetMetadataPage.this.context.updateTargets();
                super.refresh();
            }
        };
        managedForm.addPart((IFormPart)this.contentsPart);
        this.context = this.createDataBindingContext();
    }

    private ScrolledForm createHeader(ScrolledForm form) {
        form.setText(Messages.EDITOR_TITLE_METADATA);
        SharedImages sharedImages = (SharedImages)InjectionService.getInstance().getInjector().getInstance(SharedImages.class);
        Action openDiscoveryAction = new Action(Messages.EDITOR_EXTENSIONS_HEADER_EXT_LINK, sharedImages.getDescriptor((SharedImages.ImageResource)SharedImages.Images.ELCL_INSTALL_EXTENSIONS)){

            public void run() {
                SnippetEditorDiscoveryUtils.openDiscoveryDialog();
            }
        };
        EditorUtils.addActionToForm(form, openDiscoveryAction, Messages.EDITOR_EXTENSIONS_HEADER_EXT_LINK);
        Action showHelpAction = new Action(Messages.EDITOR_TOOLBAR_ITEM_HELP, sharedImages.getDescriptor((SharedImages.ImageResource)SharedImages.Images.ELCL_HELP)){

            public void run() {
                Browsers.tryOpenInExternalBrowser((String)"https://www.eclipse.org/recommenders/manual/#snippet-editing-sharing");
            }
        };
        EditorUtils.addActionToForm(form, showHelpAction, Messages.EDITOR_TOOLBAR_ITEM_HELP);
        return form;
    }

    private Collection<String> fetchDependencyListItems() {
        final ArrayList items = Lists.newArrayList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = SnippetMetadataPage.this.listViewerDependencies.getList().getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    items.add(string);
                    ++n2;
                }
            }
        });
        return items;
    }

    private Set<ProjectCoordinate> changeVersionsToZero(Set<ProjectCoordinate> resolved) {
        HashSet result = Sets.newHashSet();
        for (ProjectCoordinate projectCoordinate : resolved) {
            result.add(new ProjectCoordinate(projectCoordinate.getGroupId(), projectCoordinate.getArtifactId(), "0.0.0"));
        }
        return result;
    }

    private InputDialog createFilenameRestrictionInputDialog(Shell shell) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null) {
                    return "";
                }
                if (StringUtils.isBlank((CharSequence)newText)) {
                    return "";
                }
                if (newText.contains("*")) {
                    return MessageFormat.format(Messages.DIALOG_VALIDATOR_FILENAME_RESTRICTION_CONTAINS_ILLEGAL_CHARACTER, "*");
                }
                if (SnippetMetadataPage.this.snippet.getFilenameRestrictions().contains(newText.trim().toLowerCase())) {
                    return Messages.DIALOG_VALIDATOR_FILENAME_RESTRICTION_ALREADY_ADDED;
                }
                return null;
            }
        };
        return new InputDialog(shell, Messages.DIALOG_TITLE_ENTER_NEW_FILENAME_RESTRICTION, Messages.DIALOG_MESSAGE_ENTER_NEW_FILENAME_RESTRICTION, "", validator){

            protected void okPressed() {
                SnippetMetadataPage.this.ppFilenameRestrictions.add((Object)this.getValue().toLowerCase());
                super.okPressed();
            }
        };
    }

    private InputDialog createExtraSearchTermInputDialog(Shell shell) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (Strings.isNullOrEmpty((String)newText)) {
                    return "";
                }
                if (SnippetMetadataPage.this.snippet.getExtraSearchTerms().contains(newText)) {
                    return Messages.DIALOG_VALIDATOR_EXTRA_SEARCH_TERM_ALREADY_ADDED;
                }
                return null;
            }
        };
        return new InputDialog(shell, Messages.DIALOG_TITLE_ENTER_NEW_EXTRA_SEARCH_TERM, Messages.DIALOG_MESSAGE_ENTER_NEW_EXTRA_SEARCH_TERM, "", validator){

            protected void okPressed() {
                SnippetMetadataPage.this.ppExtraSearchTerms.add((Object)this.getValue());
                super.okPressed();
            }
        };
    }

    private InputDialog createTagInputDialog(Shell shell) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (Strings.isNullOrEmpty((String)newText)) {
                    return "";
                }
                if (SnippetMetadataPage.this.snippet.getTags().contains(newText)) {
                    return Messages.DIALOG_VALIDATOR_TAG_ALREADY_ADDED;
                }
                return null;
            }
        };
        return new InputDialog(shell, Messages.DIALOG_TITLE_ENTER_NEW_TAG, Messages.DIALOG_MESSAGE_ENTER_NEW_TAG, "", validator){

            protected void okPressed() {
                SnippetMetadataPage.this.ppTags.add((Object)this.getValue());
                super.okPressed();
            }
        };
    }

    private DataBindingContext createDataBindingContext() {
        DataBindingContext context = new DataBindingContext();
        ISWTObservableValue wpTxtNameText = WidgetProperties.text((int)24).observe((Widget)this.txtName);
        IObservableValue ppName = BeanProperties.value(Snippet.class, (String)"name", String.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpTxtNameText, ppName);
        ppName.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        ISWTObservableValue wpTxtDescriptionText = WidgetProperties.text((int)24).observe((Widget)this.txtDescription);
        IObservableValue ppDescription = BeanProperties.value(Snippet.class, (String)"description", String.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpTxtDescriptionText, ppDescription);
        ppDescription.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        IViewerObservableValue wpTxtLocation = ViewerProperties.singleSelection().observe((Viewer)this.comboLocation);
        IObservableValue ppLocation = BeanProperties.value(Snippet.class, (String)"location", Location.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpTxtLocation, ppLocation);
        ppLocation.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        this.ppFilenameRestrictions = BeanProperties.list(Snippet.class, (String)"filenameRestrictions", String.class).observe((Object)this.snippet);
        this.ppFilenameRestrictions.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        ViewerSupport.bind((StructuredViewer)this.listViewerFilenameRestrictions, (IObservableList)this.ppFilenameRestrictions, (IValueProperty)new FilenameRestrictionLabelProperty());
        this.ppExtraSearchTerms = BeanProperties.list(Snippet.class, (String)"extraSearchTerms", String.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerExtraSearchTerms, (IObservableList)this.ppExtraSearchTerms, (IValueProperty)new SelfValueProperty(String.class));
        this.ppExtraSearchTerms.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        this.ppTags = BeanProperties.list(Snippet.class, (String)"tags", String.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerTags, (IObservableList)this.ppTags, (IValueProperty)new SelfValueProperty(String.class));
        this.ppTags.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        this.ppDependencies = BeanProperties.set(Snippet.class, (String)"neededDependencies", ProjectCoordinate.class).observe((Object)this.snippet);
        ViewerSupport.bind((StructuredViewer)this.listViewerDependencies, (IObservableSet)this.ppDependencies, (IValueProperty)new SimpleValueProperty(){

            public Object getValueType() {
                return ProjectCoordinate.class;
            }

            protected Object doGetValue(Object source) {
                if (source != null) {
                    ProjectCoordinate pc = (ProjectCoordinate)Checks.cast((Object)source);
                    return SnippetMetadataPage.this.getStringForDependency(pc);
                }
                return "";
            }

            protected void doSetValue(Object source, Object value) {
            }

            public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
                return null;
            }
        });
        this.ppDependencies.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        UpdateValueStrategy stringToUuidStrategy = new UpdateValueStrategy();
        DatabindingConverters.StringToUuidConverter stringToUuidConverter = new DatabindingConverters.StringToUuidConverter();
        stringToUuidStrategy.setConverter((IConverter)stringToUuidConverter);
        ISWTObservableValue wpUuidText = WidgetProperties.text((int)24).observe((Widget)this.txtUuid);
        IObservableValue ppUuid = BeanProperties.value(Snippet.class, (String)"uuid", UUID.class).observe((Object)this.snippet);
        context.bindValue((IObservableValue)wpUuidText, ppUuid, stringToUuidStrategy, null);
        ppUuid.addChangeListener((IChangeListener)new ContentsPartDirtyListener());
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new ObjectToBooleanConverter());
        IViewerObservableValue vpFilenamesSelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerFilenameRestrictions);
        ISWTObservableValue wpBtnRemoveFilenamesEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveFilenameRestriction);
        IViewerObservableValue vpLocationSelection = ViewersObservables.observeSingleSelection((Viewer)this.comboLocation);
        ISWTObservableValue wpListViewerFilenamesEnabled = WidgetProperties.enabled().observe((Widget)this.listViewerFilenameRestrictions.getControl());
        ISWTObservableValue wpBtnAddFilenamesEnabled = WidgetProperties.enabled().observe((Widget)this.btnAddFilenameRestriction);
        UpdateValueStrategy locationEnablementStrategy = new UpdateValueStrategy();
        DatabindingConverters.EnumToBooleanConverter locationToBooleanConverter = new DatabindingConverters.EnumToBooleanConverter((Enum[])new Location[]{Location.FILE});
        locationEnablementStrategy.setConverter((IConverter)locationToBooleanConverter);
        context.bindValue((IObservableValue)vpLocationSelection, (IObservableValue)wpListViewerFilenamesEnabled, locationEnablementStrategy, null);
        context.bindValue((IObservableValue)vpLocationSelection, (IObservableValue)wpBtnAddFilenamesEnabled, locationEnablementStrategy, null);
        ComputedValue computedRemoveButtonEnablement = new ComputedValue((IObservableValue)wpBtnAddFilenamesEnabled, (IObservableValue)vpFilenamesSelection){
            private final /* synthetic */ IObservableValue val$wpBtnAddFilenamesEnabled;
            private final /* synthetic */ IObservableValue val$vpFilenamesSelection;
            {
                this.val$wpBtnAddFilenamesEnabled = iObservableValue;
                this.val$vpFilenamesSelection = iObservableValue2;
            }

            protected Object calculate() {
                boolean addButtonEnabled = (Boolean)this.val$wpBtnAddFilenamesEnabled.getValue();
                if (this.val$vpFilenamesSelection.getValue() != null && addButtonEnabled) {
                    return true;
                }
                return false;
            }
        };
        context.bindValue((IObservableValue)wpBtnRemoveFilenamesEnable, (IObservableValue)computedRemoveButtonEnablement);
        IViewerObservableValue vpExtraSearchTermsSelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerExtraSearchTerms);
        ISWTObservableValue wpBtnRemoveExtraSearchTermEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveExtraSearchTerm);
        context.bindValue((IObservableValue)vpExtraSearchTermsSelection, (IObservableValue)wpBtnRemoveExtraSearchTermEnable, strategy, null);
        IViewerObservableValue vpTagSelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerTags);
        ISWTObservableValue wpBtnRemoveTagsEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveTag);
        context.bindValue((IObservableValue)vpTagSelection, (IObservableValue)wpBtnRemoveTagsEnable, strategy, null);
        IViewerObservableValue vpDependencySelection = ViewerProperties.singleSelection().observe((Viewer)this.listViewerDependencies);
        ISWTObservableValue wpBtnRemoveDependenciesEnable = WidgetProperties.enabled().observe((Widget)this.btnRemoveDependency);
        context.bindValue((IObservableValue)vpDependencySelection, (IObservableValue)wpBtnRemoveDependenciesEnable, strategy, null);
        context.updateModels();
        return context;
    }

    String getStringForDependency(ProjectCoordinate pc) {
        return String.valueOf(pc.getGroupId()) + ":" + pc.getArtifactId();
    }

    public void setFocus() {
        super.setFocus();
        this.txtName.setFocus();
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        this.registerEditorInputListener();
        super.init(site, input);
    }

    private void registerEditorInputListener() {
        this.getEditor().addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    SnippetMetadataPage.this.setInputWithNotify(SnippetMetadataPage.this.getEditor().getEditorInput());
                }
            }
        });
    }

    protected void setInputWithNotify(IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        this.context.dispose();
        this.context = this.createDataBindingContext();
        super.setInputWithNotify(input);
    }

    public void dispose() {
        this.context.dispose();
        super.dispose();
    }

    private final class ContentsPartDirtyListener
    implements IChangeListener {
        private ContentsPartDirtyListener() {
        }

        public void handleChange(ChangeEvent event) {
            SnippetMetadataPage.this.contentsPart.markDirty();
        }
    }

    private static class FilenameRestrictionLabelProperty
    extends SimpleValueProperty {
        private FilenameRestrictionLabelProperty() {
        }

        public Object getValueType() {
            return String.class;
        }

        protected Object doGetValue(Object source) {
            String text = (String)source;
            if (text.startsWith(".")) {
                return "*" + text;
            }
            return text;
        }

        protected void doSetValue(Object source, Object value) {
        }

        public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
            return null;
        }
    }
}

