/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.recommenders.internal.types.rcp.IIndexProvider;
import org.eclipse.recommenders.internal.types.rcp.IProjectTypesIndex;
import org.eclipse.recommenders.internal.types.rcp.ProjectTypesIndex;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class IndexProvider
implements IIndexProvider {
    @VisibleForTesting
    static final String INDEX_DIR = "indexes";
    private final LoadingCache<IJavaProject, IProjectTypesIndex> cache = CacheBuilder.newBuilder().build((CacheLoader)new ProjectTypesIndexCacheLoader());

    @Override
    public Optional<IProjectTypesIndex> findIndex(IJavaProject project) {
        return Optional.fromNullable((Object)((IProjectTypesIndex)this.cache.getIfPresent((Object)project)));
    }

    @Override
    public IProjectTypesIndex findOrCreateIndex(IJavaProject project) {
        return (IProjectTypesIndex)this.cache.getUnchecked((Object)project);
    }

    @Override
    public void deleteIndex(IJavaProject project) {
        IProjectTypesIndex index = (IProjectTypesIndex)this.findIndex(project).orNull();
        if (index == null) {
            return;
        }
        index.delete();
        this.cache.invalidate((Object)project);
    }

    @Override
    public void close() throws IOException {
        for (IProjectTypesIndex index : this.cache.asMap().values()) {
            index.close();
        }
    }

    @VisibleForTesting
    static final class ProjectTypesIndexCacheLoader
    extends CacheLoader<IJavaProject, IProjectTypesIndex> {
        ProjectTypesIndexCacheLoader() {
        }

        public IProjectTypesIndex load(IJavaProject project) throws Exception {
            return new ProjectTypesIndex(project, ProjectTypesIndexCacheLoader.computeIndexDir(project));
        }

        @VisibleForTesting
        static File computeIndexDir(IJavaProject project) {
            Bundle bundle = FrameworkUtil.getBundle(IndexProvider.class);
            File location = Platform.getStateLocation((Bundle)bundle).toFile();
            String mangledProjectName = project.getElementName().replaceAll("\\W", "_");
            File indexDir = new File(new File(location, IndexProvider.INDEX_DIR), mangledProjectName);
            return indexDir;
        }
    }
}

