/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tracwiki.core.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class ListBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 4;
    static final Pattern startPattern = Pattern.compile("(?:(\\s*)(?:(\\*|-)|(?:(\\d+)\\.)))\\s+(.*+)");
    static final Pattern nextLinePattern = Pattern.compile("(\\s+)(.*+)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private final Stack<ListState> listState = new Stack();

    public int processLineContent(String line, int offset) {
        ListAttributes attributes;
        if (this.blockLineCount == 0) {
            attributes = new ListAttributes();
            String spaces = this.matcher.group(1);
            String listSpec = this.matcher.group(2);
            String numericListSpec = this.matcher.group(3);
            if (numericListSpec != null && !"1".equals(numericListSpec)) {
                attributes.setStart(numericListSpec);
            }
            int level = this.calculateLevel(spaces);
            DocumentBuilder.BlockType type = listSpec == null ? DocumentBuilder.BlockType.NUMERIC_LIST : DocumentBuilder.BlockType.BULLETED_LIST;
            offset = this.matcher.start(4);
            this.listState.push(new ListState(level, spaces.length(), offset, type));
            this.builder.beginBlock(type, (Attributes)attributes);
        } else {
            attributes = new ListAttributes();
            Matcher matcher = startPattern.matcher(line);
            if (!matcher.matches()) {
                String spaces;
                Matcher nextLineMatcher = nextLinePattern.matcher(line);
                ListState listState = this.listState.peek();
                if (listState.openItem && nextLineMatcher.matches() && (spaces = nextLineMatcher.group(1)).length() > 0 && spaces.length() >= listState.numSpaces && spaces.length() <= listState.lineRemainderStart) {
                    ++this.blockLineCount;
                    offset = nextLineMatcher.start(2) - 1;
                    this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
                    return -1;
                }
                this.setClosed(true);
                return 0;
            }
            String spaces = matcher.group(1);
            String listSpec = matcher.group(2);
            String numericListSpec = matcher.group(3);
            if (numericListSpec != null && !"1".equals(numericListSpec)) {
                attributes.setStart(numericListSpec);
            }
            int level = this.calculateLevel(spaces);
            DocumentBuilder.BlockType type = listSpec == null ? DocumentBuilder.BlockType.NUMERIC_LIST : DocumentBuilder.BlockType.BULLETED_LIST;
            offset = matcher.start(4);
            ListState listState = this.listState.peek();
            while (listState.level != level || listState.type != type) {
                if (listState.level > level || listState.level == level && listState.type != type) {
                    this.closeOne();
                    if (this.listState.isEmpty()) {
                        this.listState.push(new ListState(1, spaces.length(), offset, type));
                        this.builder.beginBlock(type, (Attributes)attributes);
                    }
                } else {
                    this.listState.push(new ListState(level, spaces.length(), offset, type));
                    this.builder.beginBlock(type, (Attributes)attributes);
                }
                listState = this.listState.peek();
            }
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (listState.openItem) {
            this.builder.endBlock();
        }
        listState.openItem = true;
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private int calculateLevel(String spaces) {
        int length = spaces.length();
        int level = 1;
        int x = 1;
        while (x < this.listState.size()) {
            ListState state = (ListState)this.listState.get(x);
            if (state.numSpaces > length) break;
            level = state.level;
            ++x;
        }
        if (!this.listState.isEmpty()) {
            ListState outerState = this.listState.peek();
            if (level == outerState.level && length > outerState.numSpaces) {
                level = outerState.level + 1;
            }
        }
        return level;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (!this.listState.isEmpty()) {
                this.closeOne();
            }
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class ListState {
        int level;
        int numSpaces;
        int lineRemainderStart;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(int level, int numSpaces, int lineRemainderStart, DocumentBuilder.BlockType type) {
            this.level = level;
            this.numSpaces = numSpaces;
            this.lineRemainderStart = lineRemainderStart;
            this.type = type;
        }
    }
}

