/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Assignment;
import org.mvel2.compiler.CompiledAccExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;

public class IndexedAssignmentNode
extends ASTNode
implements Assignment {
    private String name;
    private int register;
    private transient CompiledAccExpression accExpr;
    private char[] indexTarget;
    private char[] index;
    private char[] stmt;
    private ExecutableStatement statement;
    private boolean col = false;

    public IndexedAssignmentNode(char[] expr, int fields, int operation, String name, int register, ParserContext pCtx) {
        super(pCtx);
        ((ASTNode)this).name = expr;
        this.register = register;
        if (operation != -1) {
            this.name = name;
            ParseTools.checkNameSafety(this.name);
            this.stmt = ParseTools.createShortFormOperativeAssignment(name, expr, operation);
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, pCtx);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int assignStart = ParseTools.find(expr, '=');
            if (assignStart != -1) {
                this.name = ParseTools.createStringTrimmed(expr, 0, assignStart);
                this.stmt = ParseTools.subset(expr, assignStart + 1);
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, pCtx);
                this.egressType = this.statement.getKnownEgressType();
                this.indexTarget = this.name.toCharArray();
                short s = (short)ArrayTools.findFirst('[', this.indexTarget);
                this.endOfName = s;
                this.col = s > 0;
                if (this.col) {
                    if (((this.fields |= 0x100) & 0x10) != 0) {
                        this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget, pCtx);
                    }
                    this.name = new String(expr, 0, this.endOfName);
                    this.index = ParseTools.subset(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
                }
                ParseTools.checkNameSafety(this.name);
            } else {
                this.name = new String(expr);
                ParseTools.checkNameSafety(this.name);
            }
        }
        if ((fields & 0x10) != 0) {
            pCtx.addVariable(name, this.egressType);
        }
    }

    public IndexedAssignmentNode(char[] expr, int fields, int register, ParserContext pCtx) {
        this(expr, fields, -1, null, register, pCtx);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accExpr == null) {
            this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            Object object = ctx;
            ctx = this.statement.getValue(ctx, thisValue, factory);
            this.accExpr.setValue(object, thisValue, factory, ctx);
        } else if (this.statement != null) {
            if (factory.isIndexedFactory()) {
                ctx = this.statement.getValue(ctx, thisValue, factory);
                factory.createIndexedVariable(this.register, this.name, ctx);
            } else {
                ctx = this.statement.getValue(ctx, thisValue, factory);
                factory.createVariable(this.name, ctx);
            }
        } else {
            if (factory.isIndexedFactory()) {
                factory.createIndexedVariable(this.register, this.name, null);
            } else {
                factory.createVariable(this.name, this.statement.getValue(ctx, thisValue, factory));
            }
            return Void.class;
        }
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ParseTools.checkNameSafety(this.name);
        if (this.col) {
            ctx = MVEL.eval(this.stmt, ctx, factory);
            MVEL.setProperty(factory.getIndexedVariableResolver(this.register).getValue(), new String(this.index), ctx);
        } else {
            ctx = MVEL.eval(this.stmt, ctx, factory);
            factory.createIndexedVariable(this.register, this.name, ctx);
        }
        return ctx;
    }

    public String getAssignmentVar() {
        return this.name;
    }

    public char[] getExpression() {
        return this.stmt;
    }

    public int getRegister() {
        return this.register;
    }

    public void setRegister(int register) {
        this.register = register;
    }

    public boolean isAssignment() {
        return true;
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

