/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.commands.AbstractCommand;
import org.eclipse.wb.internal.core.nls.commands.AddKeyCommand;
import org.eclipse.wb.internal.core.nls.commands.AddLocaleCommand;
import org.eclipse.wb.internal.core.nls.commands.CreateSourceCommand;
import org.eclipse.wb.internal.core.nls.commands.ExternalizePropertyCommand;
import org.eclipse.wb.internal.core.nls.commands.InternalizeKeyCommand;
import org.eclipse.wb.internal.core.nls.commands.RemoveLocaleCommand;
import org.eclipse.wb.internal.core.nls.commands.RenameKeyCommand;
import org.eclipse.wb.internal.core.nls.commands.SetValuesCommand;
import org.eclipse.wb.internal.core.nls.edit.EditableSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyRenameStrategy;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NlsSupport {
    private static final String NLS_SUPPORT = "NLS_SUPPORT";
    private static final String POINT_NLS_SOURCES = "org.eclipse.wb.core.nlsSources";
    private static Map<String, SourceDescription> m_idToDescription = Maps.newTreeMap();
    private static Map<String, SourceDescription[]> m_toolkitToDescriptions = Maps.newTreeMap();
    private final JavaInfo m_root;
    private final SourceDescription[] m_sourceDescriptions;
    private final List<AbstractSource> m_sources = Lists.newArrayList();
    private static final String NLS_SOURCE = "NLS_SOURCE";
    private static final String NLS_BAD_EXPRESSION = "NLS_BAD_EXPRESSION";

    public static NlsSupport get(JavaInfo component) throws Exception {
        AstEditor editor = component.getEditor();
        NlsSupport support = (NlsSupport)editor.getGlobalValue(NLS_SUPPORT);
        if (support == null) {
            support = new NlsSupport(component.getRootJava());
            editor.putGlobalValue(NLS_SUPPORT, support);
        }
        return support;
    }

    public static String getValue(JavaInfo component, Expression expression) throws Exception {
        SourceDescription[] sourceDescriptionArray = NlsSupport.getSourceDescriptions(component);
        int n = sourceDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SourceDescription sourceDescription = sourceDescriptionArray[n2];
            try {
                List sources = Lists.newArrayList();
                AbstractSource source = sourceDescription.getSource(component, null, expression, sources);
                if (source != null) {
                    NlsSupport.setSource(expression, source);
                    return source.getValue(expression);
                }
            }
            catch (Throwable throwable) {}
            ++n2;
        }
        return null;
    }

    private static SourceDescription getSourceDescription(String id) throws Exception {
        SourceDescription description = m_idToDescription.get(id);
        if (description == null) {
            List elements = ExternalFactoriesHelper.getElements((String)POINT_NLS_SOURCES, (String)"description");
            for (IConfigurationElement element : elements) {
                if (!id.equals(element.getAttribute("id"))) continue;
                Bundle bundle = ExternalFactoriesHelper.getExtensionBundle((IConfigurationElement)element);
                Class sourceClass = bundle.loadClass(element.getAttribute("source"));
                Class compositeClass = bundle.loadClass(element.getAttribute("composite"));
                description = new SourceDescription(sourceClass, compositeClass);
                m_idToDescription.put(id, description);
            }
        }
        return description;
    }

    public static SourceDescription[] getSourceDescriptions(JavaInfo component) throws Exception {
        String toolkitId = component.getDescription().getToolkit().getId();
        SourceDescription[] descriptions = m_toolkitToDescriptions.get(toolkitId);
        if (descriptions == null) {
            List descriptionList = Lists.newArrayList();
            List elements = ExternalFactoriesHelper.getElements((String)POINT_NLS_SOURCES, (String)"binding");
            for (IConfigurationElement element : elements) {
                String descriptionId;
                SourceDescription description;
                if (!toolkitId.equals(element.getAttribute("toolkit")) || (description = NlsSupport.getSourceDescription(descriptionId = element.getAttribute("description"))) == null) continue;
                descriptionList.add(description);
            }
            descriptions = descriptionList.toArray(new SourceDescription[descriptionList.size()]);
        }
        return descriptions;
    }

    private NlsSupport(JavaInfo root) throws Exception {
        this.m_root = root;
        this.m_sourceDescriptions = NlsSupport.getSourceDescriptions(this.m_root);
        this.prepareSources(this.m_root);
        this.setDefaultLocaleDuringRefresh();
        this.renameKeysOnVariableNameChange();
    }

    private void setDefaultLocaleDuringRefresh() {
        this.m_root.addBroadcastListener(new ObjectEventListener(){
            private Locale m_oldDefaultLocale;

            public void refreshBeforeCreate() throws Exception {
                Locale locale;
                LocaleInfo localeInfo = AbstractSource.getLocaleInfo(NlsSupport.this.m_root);
                if (localeInfo != null && (locale = localeInfo.getLocale()) != null) {
                    this.m_oldDefaultLocale = Locale.getDefault();
                    Locale.setDefault(locale);
                }
            }

            public void refreshFinallyRefresh() {
                if (this.m_oldDefaultLocale != null) {
                    Locale.setDefault(this.m_oldDefaultLocale);
                    this.m_oldDefaultLocale = null;
                }
            }
        });
    }

    private void renameKeysOnVariableNameChange() {
        this.m_root.addBroadcastListener(new JavaEventListener(){

            public void variable_setName(AbstractNamedVariableSupport variableSupport, String oldName, String newName) throws Exception {
                IPreferenceStore preferences = NlsSupport.this.m_root.getDescription().getToolkit().getPreferences();
                if (oldName != null && newName != null && preferences.getBoolean("nls.renameKeysWithVariables")) {
                    IEditableSupport editable = NlsSupport.this.getEditable();
                    AbstractSource[] abstractSourceArray = NlsSupport.this.getSources();
                    int n = abstractSourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractSource source = abstractSourceArray[n2];
                        IKeyRenameStrategy keyRenameStrategy = source.getKeyRenameStrategy();
                        IEditableSource editableSource = editable.getEditableSource(source);
                        Set<String> keys = source.getKeys();
                        for (String oldKey : keys) {
                            String newKey = keyRenameStrategy.getNewKey(oldName, newName, oldKey);
                            if (keys.contains(newKey)) continue;
                            editableSource.renameKey(oldKey, newKey);
                        }
                        ++n2;
                    }
                    NlsSupport.this.applyEditable(editable);
                }
            }
        });
    }

    public static boolean isStringProperty(Property property) {
        return property instanceof GenericProperty && property.getEditor() instanceof StringPropertyEditor;
    }

    public static void autoExternalize(GenericProperty property) throws Exception {
        NlsSupport support;
        JavaInfo javaInfo;
        IPreferenceStore preferences;
        if (NlsSupport.isStringProperty((Property)property) && (preferences = (javaInfo = property.getJavaInfo()).getDescription().getToolkit().getPreferences()).getBoolean("nls.automaticallyExternalize") && (support = NlsSupport.get(javaInfo)).getSources() != null) {
            support.externalize(javaInfo, property);
        }
    }

    private void prepareSources(JavaInfo component) throws Exception {
        Property[] properties;
        Property[] propertyArray = properties = component.getProperties();
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            GenericProperty stringProperty;
            Expression expression;
            Property property = propertyArray[n2];
            if (NlsSupport.isStringProperty(property) && (expression = (stringProperty = (GenericProperty)property).getExpression()) != null) {
                SourceDescription[] sourceDescriptionArray = this.m_sourceDescriptions;
                int n3 = this.m_sourceDescriptions.length;
                int n4 = 0;
                while (n4 < n3) {
                    SourceDescription sourceDescription = sourceDescriptionArray[n4];
                    try {
                        AbstractSource source = sourceDescription.getSource(component, stringProperty, expression, this.m_sources);
                        if (source != null) {
                            NlsSupport.setSource(expression, source);
                            if (this.m_sources.contains(source)) break;
                            this.m_sources.add(source);
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        NlsSupport.markAsBadExpression(expression);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        for (JavaInfo child : component.getChildrenJava()) {
            this.prepareSources(child);
        }
    }

    public JavaInfo getRoot() {
        return this.m_root;
    }

    public AbstractSource[] getSources() {
        return this.m_sources.toArray(new AbstractSource[this.m_sources.size()]);
    }

    public boolean isExternalized(Expression expression) {
        return expression != null && NlsSupport.getSource(expression) != null;
    }

    public AbstractSource getKeySource(String key) throws Exception {
        AbstractSource[] abstractSourceArray = this.getSources();
        int n = abstractSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSource source = abstractSourceArray[n2];
            Set<String> keys = source.getKeys();
            if (keys.contains(key)) {
                return source;
            }
            ++n2;
        }
        return null;
    }

    public String getValue(Expression expression) throws Exception {
        AbstractSource source = NlsSupport.getSource(expression);
        if (source != null) {
            return source.getValue(expression);
        }
        return null;
    }

    public void setValue(Expression expression, String value) throws Exception {
        AbstractSource source = NlsSupport.getSource(expression);
        source.setValue(expression, value);
    }

    public void externalize(JavaInfo component, GenericProperty property) throws Exception {
        if (!this.m_sources.isEmpty()) {
            AbstractSource source = this.m_sources.get(0);
            String value = (String)property.getValue();
            source.externalize(component, property, value);
            source.setValue(property.getExpression(), value);
        }
    }

    public boolean isExternallyChanged() throws Exception {
        for (AbstractSource source : this.m_sources) {
            if (!source.isExternallyChanged()) continue;
            return true;
        }
        return false;
    }

    public LocaleInfo[] getLocales() throws Exception {
        Set locales = Sets.newHashSet();
        for (AbstractSource source : this.m_sources) {
            Collections.addAll(locales, source.getLocales());
        }
        this.addAlwaysVisibleLocales(locales);
        return locales.toArray(new LocaleInfo[locales.size()]);
    }

    private void addAlwaysVisibleLocales(Set<LocaleInfo> locales) {
        IPreferenceStore preferences = this.m_root.getDescription().getToolkit().getPreferences();
        String localesString = preferences.getString("nls.alwaysVisibleLocales");
        String[] stringArray = StringUtils.split((String)localesString, (String)", ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String localeString = stringArray[n2];
            try {
                LocaleInfo locale = LocaleInfo.create(localeString, localeString);
                locales.add(locale);
            }
            catch (Throwable throwable) {}
            ++n2;
        }
    }

    public IEditableSupport getEditable() throws Exception {
        return new EditableSupport(this);
    }

    public void applyEditable(IEditableSupport editableSupport) throws Exception {
        EditableSupport editable = (EditableSupport)editableSupport;
        List<AbstractCommand> commands = editable.getCommands();
        for (AbstractCommand command : commands) {
            AbstractCommand cmd;
            IEditableSource editableSource = command.getEditableSource();
            if (command instanceof CreateSourceCommand) {
                CreateSourceCommand cmd2 = (CreateSourceCommand)command;
                AbstractSource newSource = cmd2.getSourceDescription().createNewSource(editableSource, this.m_root, cmd2.getParameters());
                editable.addEditableToSourceMapping(editableSource, newSource);
                this.m_sources.add(newSource);
                continue;
            }
            AbstractSource source = this.getAttachedSource(editable, editableSource);
            if (command instanceof SetValuesCommand) {
                cmd = (SetValuesCommand)command;
                source.apply_setValues(((SetValuesCommand)cmd).getLocale(), ((SetValuesCommand)cmd).getValues());
            }
            if (command instanceof RenameKeyCommand) {
                cmd = (RenameKeyCommand)command;
                source.apply_renameKeys(((RenameKeyCommand)cmd).getOldToNewMap());
            }
            if (command instanceof AddKeyCommand) {
                cmd = (AddKeyCommand)command;
                source.apply_addKey(((AddKeyCommand)cmd).getKey());
            }
            if (command instanceof ExternalizePropertyCommand) {
                cmd = (ExternalizePropertyCommand)command;
                source.apply_externalizeProperty(((ExternalizePropertyCommand)cmd).getProperty(), ((ExternalizePropertyCommand)cmd).getKey());
            }
            if (command instanceof InternalizeKeyCommand) {
                cmd = (InternalizeKeyCommand)command;
                source.apply_internalizeKeys(((InternalizeKeyCommand)cmd).getKeys());
            }
            if (command instanceof AddLocaleCommand) {
                cmd = (AddLocaleCommand)command;
                source.apply_addLocale(((AddLocaleCommand)cmd).getLocale(), ((AddLocaleCommand)cmd).getValues());
            }
            if (!(command instanceof RemoveLocaleCommand)) continue;
            cmd = (RemoveLocaleCommand)command;
            source.apply_removeLocale(((RemoveLocaleCommand)cmd).getLocale());
        }
        JavaInfoUtils.scheduleSave(this.m_root);
    }

    public AbstractSource getAttachedSource(IEditableSupport editable, IEditableSource editableSource) throws Exception {
        EditableSupport editableImpl = (EditableSupport)editable;
        AbstractSource source = editableImpl.getSource(editableSource);
        if (source == null) {
            source = editableImpl.getPossibleSource(editableSource);
            source.attachPossible();
            editableImpl.addEditableToSourceMapping(editableSource, source);
            this.m_sources.add(source);
        }
        return source;
    }

    public static void setSource(Expression expression, AbstractSource source) {
        expression.setProperty(NLS_SOURCE, (Object)source);
    }

    public static AbstractSource getSource(Expression expression) {
        return (AbstractSource)expression.getProperty(NLS_SOURCE);
    }

    private static void markAsBadExpression(Expression expression) {
        expression.setProperty(NLS_BAD_EXPRESSION, (Object)expression);
    }

    public static boolean isBadExpression(Expression expression) {
        return expression.getProperty(NLS_BAD_EXPRESSION) != null;
    }
}

