10 PRINT "PROGRAM FILE 166: COMPOUND EXPRESSIONS USED WITH CONTROL"
20 PRINT "        STATEMENTS AND FOR-STATEMENTS."
30 PRINT "    ANSI STANDARD 7.2, 7.4, 10.2, 10.4, 11.2, 11.4"
40 PRINT
50 PRINT "THIS PROGRAM TESTS THE USE OF NUMERIC EXPRESSIONS WITHIN"
60 PRINT "THE CONTEXT OF THE CONTROL STATEMENTS IF-THEN AND ON-GOTO,"
70 PRINT "AND ALSO WITHIN THE FOR-STATEMENT."
80 PRINT
90 PRINT "SECTION 166.1: NUMERIC EXPRESSIONS AND"
100 PRINT "        THE IF-THEN-STATEMENT."
110 PRINT
120 PRINT "                       BEGIN TEST."
130 PRINT
140 DEF FNA(X)=X^2+2*X+1
150 DEF FNC(X1)=LOG(X1)/LOG(10)
160 LET P1=3.14159265
170 LET R(0)=0
180 LET R(1)=1
190 FOR I=2 TO 10
200 LET R(I)=R(I-1)+R(I-2)
210 NEXT I
220 LET A1=3.5
230 LET B1=1.625
240 LET C1=.815
250 LET D1=-4.5
260 LET F=0
270 IF A1+B1<5.13 THEN 300
280 LET K$=" 1ST "
290 GOSUB 520
300 IF -.99>A1-ABS(D1) THEN 330
310 LET K$=" 2ND "
320 GOSUB 520
330 IF INT(SQR(ABS(D1)))=2 THEN 360
340 LET K$=" 3RD "
350 GOSUB 520
360 IF FNA(A1)+5<=ABS(D1)+A1^3 THEN 390
370 LET K$=" 4TH "
380 GOSUB 520
390 IF EXP(A1)+D1>=(A1-.36)^2+D1 THEN 420
400 LET K$=" 5TH "
410 GOSUB 520
420 IF TAN(C1)+A1<>ATN(C1)+A1 THEN 450
430 LET K$=" 6TH "
440 GOSUB 520
450 IF -FNC(SQR(10^(SIN(P1/3)^2*R(6)))) < (R(5)-R(9))/10-.09 THEN 480
460 LET K$=" 7TH "
470 GOSUB 520
480 IF -FNC(SQR(10^(SIN(P1/3)^2*R(6)))) > (R(5)-R(9))/10-.11 THEN 510
490 LET K$=" 8TH "
500 GOSUB 520
510 GOTO 580
520 REM SUBROUTINE TO HANDLE ERRORS
530 PRINT "EVALUATION OF THE RELATION BETWEEN THE";K$;"PAIR OF"
540 PRINT "EXPRESSIONS FAILED."
550 LET F=F+1
560 PRINT
570 RETURN
580 IF F=0 THEN 610
590 PRINT "*** TEST FAILED IN ";F;" CASE(S)  ***"
600 GOTO 620
610 PRINT "*** TEST PASSED ***"
620 PRINT
630 PRINT "                        END TEST."
640 PRINT
660 PRINT "SECTION 166.2: NUMERIC EXPRESSIONS AND"
670 PRINT "        THE ON-GOTO-STATEMENT."
680 PRINT
690 PRINT "                     BEGIN TEST."
700 PRINT
710 LET F=0
720 REM ON-GOTO SHOULD BRANCH TO 1ST, 4TH, AND 3RD BRANCH POINT FOR
730 REM X = 1, 3, AND 5 RESPECTIVELY.
740 FOR X=1 TO 5 STEP 2
750 ON -(X*20*X+(R(8)-5*R(9))*X+SQR(11449))/40 GOTO 870,910,830,790
760 PRINT "*** TEST FAILURE: ON GOTO FELL THROUGH FOR X = ";X
770 LET F=F+1
780 GOTO 980
790 REM 4TH ROUTINE
800 IF X=3 THEN 980
810 LET K$="4TH"
820 GOTO 940
830 REM 3RD ROUTINE
840 IF X=5 THEN 980
850 LET K$="3RD"
860 GOTO 940
870 REM 1ST ROUTINE
880 IF X=1 THEN 980
890 GOTO 940
910 REM 2ND ROUTINE
920 LET K$="2ND"
930 GOTO 940
940 PRINT "*** TEST FAILURE: ON-GOTO BRANCHED TO ";K$;" ROUTINE"
950 PRINT "    FOR X = ";X
960 PRINT
970 LET F=F+1
980 NEXT X
990 IF F=0 THEN 1020
1000 PRINT "*** TEST FAILED IN ";F;" CASE(S) ***"
1010 GOTO 1030
1020 PRINT "*** TEST PASSED ***"
1030 PRINT
1040 PRINT "                        END TEST."
1050 PRINT
1060 PRINT "SECTION 166.3: NUMERIC EXPRESSIONS AND"
1070 PRINT "        THE FOR-NEXT-STATEMENT."
1080 PRINT
1090 PRINT "                       BEGIN TEST."
1100 PRINT
1110 REM CORRECT EXECUTION PARAMETERS:
1120 REM   CTL. VAR.       FROM      T0      STEP    NO. LOOPS
1130 REM     I0              3        6        1       4
1140 REM     I1             10        4       -1       7
1150 REM     I2            228     1000      100       8
1160 REM     I3              2      -20       -2      12
1200 LET N1=3
1210 LET M1=6
1220 LET N(M1)=10
1230 LET M(M1)=4
1240 LET O=-1
1250 LET K=0
1260 LET J0=3
1270 FOR I0=N1 TO M1
1280 LET J1=10
1290 FOR I1=N(M1) TO M(M1) STEP O
1300 LET J2=228
1310 FOR I2=M1^2+2*M1*M(M1)^2 TO (N(M1)^3-1)+ABS(O) STEP 20*N(M1)/2
1320 LET J3=2
1330 FOR I3=ABS(M(M1)-M1) TO M(M1)^2-M1^2 STEP 2*SGN(M(M1)^2-M1^2)
1340 IF I0<>J0 THEN 1520
1350 IF I1<>J1 THEN 1520
1360 IF I2<>J2 THEN 1520
1370 IF I3<>J3 THEN 1520
1380 LET K=K+1
1390 LET M1 = M1 + 1
1400 LET J3=J3-2
1410 NEXT I3
1420 LET M1=6
1430 LET J2=J2+100
1440 NEXT I2
1450 LET J1=J1-1
1460 NEXT I1
1470 LET J0=J0+1
1480 NEXT I0
1490 IF K<>2688 THEN 1600
1500 PRINT "*** TEST PASSED ***"
1510 GOTO 1640
1520 PRINT "*** TEST FAILED ***"
1530 PRINT
1540 PRINT "CTL. VAR.","SHOULD BE","ACTUAL"
1550 PRINT "I0",J0,I0
1560 PRINT "I1",J1,I1
1570 PRINT "I2",J2,I2
1580 PRINT "I3",J3,I3
1590 GOTO 1640
1600 PRINT "*** TEST FAILED ***"
1610 PRINT
1620 PRINT "INNERMOST LOOP SHOULD HAVE BEEN EXECUTED 2688 TIMES."
1630 PRINT "ACTUAL COUNT = ";K
1640 PRINT
1650 PRINT "                        END TEST."
1660 PRINT
1670 PRINT "END PROGRAM 166."
1680 END
