/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.wagon;

import java.io.File;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.observers.AbstractTransferListener;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.connector.wagon.WagonCancelledException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;

class WagonTransferListenerAdapter
extends AbstractTransferListener {
    private final TransferResource resource;
    private final TransferListener delegate;
    private final TransferEvent.Builder eventBuilder;

    public WagonTransferListenerAdapter(TransferListener delegate, String repositoryUrl, String resourceName, File file, RequestTrace trace, TransferEvent.RequestType requestType, RepositorySystemSession session) {
        this.delegate = delegate;
        this.resource = new TransferResource(repositoryUrl, resourceName, file, trace);
        this.eventBuilder = new TransferEvent.Builder(session, this.resource).setRequestType(requestType);
    }

    public void transferStarted(TransferEvent event) {
        this.eventBuilder.setTransferredBytes(0L);
        this.resource.setContentLength(event.getResource().getContentLength());
        try {
            this.delegate.transferStarted(this.newEvent(TransferEvent.EventType.STARTED).build());
        }
        catch (TransferCancelledException transferCancelledException) {
            // empty catch block
        }
    }

    public void transferProgress(TransferEvent event, byte[] buffer, int length) {
        this.eventBuilder.addTransferredBytes((long)length);
        try {
            this.delegate.transferProgressed(this.newEvent(TransferEvent.EventType.PROGRESSED).setDataBuffer(buffer, 0, length).build());
        }
        catch (TransferCancelledException e) {
            throw new WagonCancelledException(e);
        }
    }

    public TransferEvent.Builder newEvent(TransferEvent.EventType type) {
        return this.eventBuilder.copy().setType(type);
    }
}

