/*************************************************************************
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
************************************************************************/

#ifndef UCB_UCPEXT_RESULT_SET_HXX
#define UCB_UCPEXT_RESULT_SET_HXX

#include <rtl/ref.hxx>
#include <ucbhelper/resultsethelper.hxx>

//......................................................................................................................
namespace ucb { namespace ucp { namespace ext
{
//......................................................................................................................

    class Content;

    //==================================================================================================================
    //= ResultSet
    //==================================================================================================================
    class ResultSet : public ::ucbhelper::ResultSetImplHelper
    {
    public:
	    ResultSet(
		    const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& i_rORB,
	  	    const rtl::Reference< Content >& i_rContent,
		    const com::sun::star::ucb::OpenCommandArgument2& i_rCommand,
	  	    const com::sun::star::uno::Reference< com::sun::star::ucb::XCommandEnvironment >& i_rEnv
        );

    private:
        ::com::sun::star::uno::Reference< ::com::sun::star::ucb::XCommandEnvironment >  m_xEnvironment;
        ::rtl::Reference< Content >                                                     m_xContent;

    private:
	    virtual void initStatic();
	    virtual void initDynamic();
    };

//......................................................................................................................
} } }   // namespace ucp::ext
//......................................................................................................................

#endif  // UCB_UCPEXT_RESULT_SET_HXX
