#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2000, 2010 Oracle and/or its affiliates.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

PRJ = ..$/..
PRJNAME = cli_ure

TARGET = climaker
TARGETTYPE = CUI
LIBTARGET = NO
ENABLE_EXCEPTIONS = TRUE

# disable caching to avoid stale objects
# on version changes
CCACHE_DISABLE=TRUE
.EXPORT : CCACHE_DISABLE

.INCLUDE :  settings.mk
.INCLUDE : $(PRJ)$/util$/makefile.pmk

.IF "$(BUILD_FOR_CLI)" != ""

NO_OFFUH=TRUE
CPPUMAKERFLAGS =

UNOTYPES = \
	com.sun.star.uno.TypeClass					\
	com.sun.star.uno.XAggregation					\
	com.sun.star.uno.XWeak						\
	com.sun.star.uno.XComponentContext				\
	com.sun.star.lang.XTypeProvider					\
	com.sun.star.lang.XInitialization				\
	com.sun.star.lang.XComponent					\
	com.sun.star.lang.XMultiComponentFactory			\
	com.sun.star.lang.XMultiServiceFactory			\
	com.sun.star.lang.XSingleComponentFactory			\
	com.sun.star.container.XSet					\
	com.sun.star.container.XHierarchicalNameAccess			\
	com.sun.star.loader.XImplementationLoader			\
	com.sun.star.registry.XSimpleRegistry				\
	com.sun.star.registry.XRegistryKey				\
	com.sun.star.reflection.XTypeDescriptionEnumerationAccess	\
	com.sun.star.reflection.XConstantTypeDescription		\
	com.sun.star.reflection.XConstantsTypeDescription		\
	com.sun.star.reflection.XIndirectTypeDescription		\
	com.sun.star.reflection.XEnumTypeDescription			\
	com.sun.star.reflection.XInterfaceTypeDescription2		\
	com.sun.star.reflection.XInterfaceMethodTypeDescription		\
	com.sun.star.reflection.XInterfaceAttributeTypeDescription2	\
	com.sun.star.reflection.XCompoundTypeDescription		\
	com.sun.star.reflection.XServiceTypeDescription2		\
	com.sun.star.reflection.XSingletonTypeDescription2		\
	com.sun.star.reflection.XStructTypeDescription

CFLAGSCXX +=-AI$(BIN)


# When compiling for CLR, disable "warning C4339: use of undefined type detected
# in CLR meta-data - use of this type may lead to a runtime exception":
.IF "$(COMEX)"=="10"
CFLAGSCXX += -clr:noAssembly -wd4339
.ELSE
CFLAGSCXX += -clr:oldSyntax -LN -wd4339 -wd4715
.ENDIF

OBJFILES = \
	$(OBJ)$/climaker_app.obj	\
	$(OBJ)$/climaker_emit.obj

APP1TARGET = $(TARGET)
APP1OBJS = $(OBJFILES)


APP1STDLIBS = \
	$(CPPUHELPERLIB)		\
	$(CPPULIB)			\
	$(SALLIB)			\
	mscoree.lib

.IF "$(CCNUMVER)" >= "001399999999"
APP1STDLIBS += \
	msvcmrt.lib
.ENDIF

.ENDIF



.INCLUDE : $(PRJ)$/util$/target.pmk
.INCLUDE :  target.mk

CLIMAKER_CONFIG = $(BIN)$/climaker.exe.config

ALLTAR: \
    $(CLIMAKER_CONFIG)
    


#Create the config file that is used with the policy assembly
$(CLIMAKER_CONFIG): climaker.exe.config
    $(COPY) $< $@
    chmod +x $@


.IF "$(BUILD_FOR_CLI)" != ""

$(OBJFILES): $(BIN)$/cli_basetypes.dll


.ENDIF




