// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: amdgpu-registered-target
// RUN: %clang_cc1 -triple amdgcn-unknown-unknown -S -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -triple r600-unknown-unknown -S -emit-llvm -o - %s | FileCheck %s

typedef __attribute__(( ext_vector_type(2) )) char char2;
typedef __attribute__(( ext_vector_type(3) )) char char3;
typedef __attribute__(( ext_vector_type(4) )) char char4;

typedef __attribute__(( ext_vector_type(2) )) short short2;
typedef __attribute__(( ext_vector_type(3) )) short short3;
typedef __attribute__(( ext_vector_type(4) )) short short4;

typedef __attribute__(( ext_vector_type(2) )) int int2;
typedef __attribute__(( ext_vector_type(3) )) int int3;
typedef __attribute__(( ext_vector_type(4) )) int int4;
typedef __attribute__(( ext_vector_type(16) )) int int16;
typedef __attribute__(( ext_vector_type(32) )) int int32;

typedef struct empty_struct
{
} empty_struct;

typedef struct single_element_struct_arg
{
    int i;
} single_element_struct_arg_t;

typedef struct nested_single_element_struct_arg
{
  single_element_struct_arg_t i;
} nested_single_element_struct_arg_t;

typedef struct struct_arg
{
    int i1;
    float f;
    int i2;
} struct_arg_t;

typedef struct struct_padding_arg
{
  char i1;
  long f;
} struct_padding_arg;

typedef struct struct_of_arrays_arg
{
    int i1[2];
    float f1;
    int i2[4];
    float f2[3];
    int i3;
} struct_of_arrays_arg_t;

typedef struct struct_of_structs_arg
{
    int i1;
    float f1;
    struct_arg_t s1;
    int i2;
} struct_of_structs_arg_t;

typedef union
{
  int b1;
  float b2;
} transparent_u __attribute__((__transparent_union__));

typedef struct single_array_element_struct_arg
{
    int i[4];
} single_array_element_struct_arg_t;

typedef struct single_struct_element_struct_arg
{
  struct inner {
    int a;
    long b;
  } s;
} single_struct_element_struct_arg_t;

typedef struct different_size_type_pair {
  long l;
  int i;
} different_size_type_pair;

typedef struct flexible_array
{
  int i;
  int flexible[];
} flexible_array;

typedef struct struct_arr16
{
    int arr[16];
} struct_arr16;

typedef struct struct_arr32
{
    int arr[32];
} struct_arr32;

typedef struct struct_arr33
{
    int arr[33];
} struct_arr33;

typedef struct struct_char_arr32
{
  char arr[32];
} struct_char_arr32;

typedef struct struct_char_x8 {
  char x, y, z, w;
  char a, b, c, d;
} struct_char_x8;

typedef struct struct_char_x4 {
  char x, y, z, w;
} struct_char_x4;

typedef struct struct_char_x3 {
  char x, y, z;
} struct_char_x3;

typedef struct struct_char_x2 {
  char x, y;
} struct_char_x2;

typedef struct struct_char_x1 {
  char x;
} struct_char_x1;

// 4 registers from fields, 5 if padding included.
typedef struct num_regs_nested_struct {
  int x;
  struct nested {
    char z;
    long y;
  } inner;
} num_regs_nested_struct;

typedef struct double_nested_struct {
  int x;
  struct double_nested {
    struct inner_inner {
      char y;
      int q;
      char z;
    } inner_inner;
  } inner;

  short w;
} double_nested_struct;

// This is a large struct, but uses fewer registers than the limit.
typedef struct large_struct_padding {
  char e0;
  int e1;
  char e2;
  int e3;
  char e4;
  char e5;
  short e6;
  short e7;
  char e8[3];
  long e9;
  int e10;
  char e11;
  int e12;
  short e13;
  char e14;
} large_struct_padding;

// The number of registers computed should be 6, not 8.
typedef struct int3_pair {
	int3 dx;
	int3 dy;
} int3_pair;

typedef struct struct_4regs
{
  int x;
  int y;
  int z;
  int w;
} struct_4regs;

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_empty_struct_arg
// CHECK-SAME: ([[STRUCT_EMPTY_STRUCT:%.*]] [[S_COERCE:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !7 !kernel_arg_base_type !8 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_empty_struct_arg(empty_struct s) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_single_element_struct_arg
// CHECK-SAME: (i32 [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !10 !kernel_arg_base_type !11 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_single_element_struct_arg(single_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_nested_single_element_struct_arg
// CHECK-SAME: (i32 [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !12 !kernel_arg_base_type !13 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_nested_single_element_struct_arg(nested_single_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_struct_arg
// CHECK-SAME: ([[STRUCT_STRUCT_ARG:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !14 !kernel_arg_base_type !15 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_struct_arg(struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_struct_padding_arg
// CHECK-SAME: ([[STRUCT_STRUCT_PADDING_ARG:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !16 !kernel_arg_base_type !17 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_struct_padding_arg(struct_padding_arg arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_test_struct_of_arrays_arg
// CHECK-SAME: ([[STRUCT_STRUCT_OF_ARRAYS_ARG:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !18 !kernel_arg_base_type !19 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_test_struct_of_arrays_arg(struct_of_arrays_arg_t arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_struct_of_structs_arg
// CHECK-SAME: ([[STRUCT_STRUCT_OF_STRUCTS_ARG:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !20 !kernel_arg_base_type !21 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_struct_of_structs_arg(struct_of_structs_arg_t arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @test_kernel_transparent_union_arg
// CHECK-SAME: (i32 [[U_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !22 !kernel_arg_base_type !22 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void test_kernel_transparent_union_arg(transparent_u u) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_single_array_element_struct_arg
// CHECK-SAME: ([[STRUCT_SINGLE_ARRAY_ELEMENT_STRUCT_ARG:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !23 !kernel_arg_base_type !24 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_single_array_element_struct_arg(single_array_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_single_struct_element_struct_arg
// CHECK-SAME: ([[STRUCT_SINGLE_STRUCT_ELEMENT_STRUCT_ARG:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !25 !kernel_arg_base_type !26 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_single_struct_element_struct_arg(single_struct_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local amdgpu_kernel void @kernel_different_size_type_pair_arg
// CHECK-SAME: ([[STRUCT_DIFFERENT_SIZE_TYPE_PAIR:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] !kernel_arg_addr_space !5 !kernel_arg_access_qual !6 !kernel_arg_type !27 !kernel_arg_base_type !28 !kernel_arg_type_qual !9 {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
__kernel void kernel_different_size_type_pair_arg(different_size_type_pair arg1) { }

// CHECK-LABEL: define dso_local void @func_f32_arg
// CHECK-SAME: (float noundef [[ARG:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_f32_arg(float arg) { }

// CHECK-LABEL: define dso_local void @func_v2i16_arg
// CHECK-SAME: (<2 x i16> noundef [[ARG:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_v2i16_arg(short2 arg) { }

// CHECK-LABEL: define dso_local void @func_v3i32_arg
// CHECK-SAME: (<3 x i32> noundef [[ARG:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_v3i32_arg(int3 arg) { }

// CHECK-LABEL: define dso_local void @func_v4i32_arg
// CHECK-SAME: (<4 x i32> noundef [[ARG:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_v4i32_arg(int4 arg) { }

// CHECK-LABEL: define dso_local void @func_v16i32_arg
// CHECK-SAME: (<16 x i32> noundef [[ARG:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_v16i32_arg(int16 arg) { }

// CHECK-LABEL: define dso_local void @func_v32i32_arg
// CHECK-SAME: (<32 x i32> noundef [[ARG:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_v32i32_arg(int32 arg) { }

// CHECK-LABEL: define dso_local void @func_empty_struct_arg
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_empty_struct_arg(empty_struct empty) { }

// CHECK-LABEL: define dso_local void @func_single_element_struct_arg
// CHECK-SAME: (i32 [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_single_element_struct_arg(single_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local void @func_nested_single_element_struct_arg
// CHECK-SAME: (i32 [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_nested_single_element_struct_arg(nested_single_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local void @func_struct_arg
// CHECK-SAME: (i32 [[ARG1_COERCE0:%.*]], float [[ARG1_COERCE1:%.*]], i32 [[ARG1_COERCE2:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_struct_arg(struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local void @func_struct_padding_arg
// CHECK-SAME: (i8 [[ARG1_COERCE0:%.*]], i64 [[ARG1_COERCE1:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_struct_padding_arg(struct_padding_arg arg1) { }

// CHECK-LABEL: define dso_local void @func_struct_char_x8
// CHECK-SAME: ([2 x i32] [[ARG_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_struct_char_x8(struct_char_x8 arg) { }

// CHECK-LABEL: define dso_local void @func_struct_char_x4
// CHECK-SAME: (i32 [[ARG_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_struct_char_x4(struct_char_x4 arg) { }

// CHECK-LABEL: define dso_local void @func_struct_char_x3
// CHECK-SAME: (i32 [[ARG_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_struct_char_x3(struct_char_x3 arg) { }

// CHECK-LABEL: define dso_local void @func_struct_char_x2
// CHECK-SAME: (i16 [[ARG_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_struct_char_x2(struct_char_x2 arg) { }

// CHECK-LABEL: define dso_local void @func_struct_char_x1
// CHECK-SAME: (i8 [[ARG_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_struct_char_x1(struct_char_x1 arg) { }

// CHECK-LABEL: define dso_local void @func_transparent_union_arg
// CHECK-SAME: (i32 [[U_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_transparent_union_arg(transparent_u u) { }

// CHECK-LABEL: define dso_local void @func_single_array_element_struct_arg
// CHECK-SAME: ([4 x i32] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_single_array_element_struct_arg(single_array_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local void @func_single_struct_element_struct_arg
// CHECK-SAME: ([[STRUCT_INNER:%.*]] [[ARG1_COERCE:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_single_struct_element_struct_arg(single_struct_element_struct_arg_t arg1) { }

// CHECK-LABEL: define dso_local void @func_different_size_type_pair_arg
// CHECK-SAME: (i64 [[ARG1_COERCE0:%.*]], i32 [[ARG1_COERCE1:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_different_size_type_pair_arg(different_size_type_pair arg1) { }

// CHECK-LABEL: define dso_local void @func_flexible_array_arg
// CHECK-SAME: (ptr addrspace(5) nocapture noundef readnone byval([[STRUCT_FLEXIBLE_ARRAY:%.*]]) align 4 [[ARG:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_flexible_array_arg(flexible_array arg) { }

// CHECK-LABEL: define dso_local float @func_f32_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret float 0.000000e+00
//
float func_f32_ret()
{
  return 0.0f;
}

// CHECK-LABEL: define dso_local void @func_empty_struct_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
empty_struct func_empty_struct_ret()
{
  empty_struct s = {};
  return s;
}

// CHECK-LABEL: define dso_local i32 @single_element_struct_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
single_element_struct_arg_t single_element_struct_ret()
{
  single_element_struct_arg_t s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local i32 @nested_single_element_struct_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
nested_single_element_struct_arg_t nested_single_element_struct_ret()
{
  nested_single_element_struct_arg_t s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local %struct.struct_arg @func_struct_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret [[STRUCT_STRUCT_ARG:%.*]] zeroinitializer
//
struct_arg_t func_struct_ret()
{
  struct_arg_t s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local %struct.struct_padding_arg @func_struct_padding_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret [[STRUCT_STRUCT_PADDING_ARG:%.*]] zeroinitializer
//
struct_padding_arg func_struct_padding_ret()
{
  struct_padding_arg s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local [2 x i32] @func_struct_char_x8_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret [2 x i32] zeroinitializer
//
struct_char_x8 func_struct_char_x8_ret()
{
  struct_char_x8 s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local i32 @func_struct_char_x4_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
struct_char_x4 func_struct_char_x4_ret()
{
  struct_char_x4 s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local i32 @func_struct_char_x3_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
struct_char_x3 func_struct_char_x3_ret()
{
  struct_char_x3 s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local i16 @func_struct_char_x2_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i16 0
//
struct_char_x2 func_struct_char_x2_ret()
{
  struct_char_x2 s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local i8 @func_struct_char_x1_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i8 0
//
struct_char_x1 func_struct_char_x1_ret()
{
  struct_char_x1 s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local %struct.struct_arr16 @func_ret_struct_arr16
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret [[STRUCT_STRUCT_ARR16:%.*]] zeroinitializer
//
struct_arr16 func_ret_struct_arr16()
{
  struct_arr16 s = { 0 };
  return s;
}

struct_arr32 func_ret_struct_arr32()
{
  struct_arr32 s = { 0 };
  return s;
}

struct_arr33 func_ret_struct_arr33()
{
  struct_arr33 s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local %struct.struct_char_arr32 @func_ret_struct_char_arr32
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret [[STRUCT_STRUCT_CHAR_ARR32:%.*]] zeroinitializer
//
struct_char_arr32 func_ret_struct_char_arr32()
{
  struct_char_arr32 s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local i32 @func_transparent_union_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
transparent_u func_transparent_union_ret()
{
  transparent_u u = { 0 };
  return u;
}

// CHECK-LABEL: define dso_local %struct.different_size_type_pair @func_different_size_type_pair_ret
// CHECK-SAME: () local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret [[STRUCT_DIFFERENT_SIZE_TYPE_PAIR:%.*]] zeroinitializer
//
different_size_type_pair func_different_size_type_pair_ret()
{
  different_size_type_pair s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local void @func_flexible_array_ret
// CHECK-SAME: (ptr addrspace(5) noalias nocapture writeonly sret([[STRUCT_FLEXIBLE_ARRAY:%.*]]) align 4 [[AGG_RESULT:%.*]]) local_unnamed_addr #[[ATTR3:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[AGG_RESULT]], align 4
// CHECK-NEXT:    ret void
//
flexible_array func_flexible_array_ret()
{
  flexible_array s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local void @func_reg_state_lo
// CHECK-SAME: (<4 x i32> noundef [[ARG0:%.*]], <4 x i32> noundef [[ARG1:%.*]], <4 x i32> noundef [[ARG2:%.*]], i32 noundef [[ARG3:%.*]], i32 [[S_COERCE0:%.*]], float [[S_COERCE1:%.*]], i32 [[S_COERCE2:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_reg_state_lo(int4 arg0, int4 arg1, int4 arg2, int arg3, struct_arg_t s) { }

// CHECK-LABEL: define dso_local void @func_reg_state_hi
// CHECK-SAME: (<4 x i32> noundef [[ARG0:%.*]], <4 x i32> noundef [[ARG1:%.*]], <4 x i32> noundef [[ARG2:%.*]], i32 noundef [[ARG3:%.*]], i32 noundef [[ARG4:%.*]], ptr addrspace(5) nocapture noundef readnone byval([[STRUCT_STRUCT_ARG:%.*]]) align 4 [[S:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_reg_state_hi(int4 arg0, int4 arg1, int4 arg2, int arg3, int arg4, struct_arg_t s) { }

// XXX - Why don't the inner structs flatten?
// CHECK-LABEL: define dso_local void @func_reg_state_num_regs_nested_struct
// CHECK-SAME: (<4 x i32> noundef [[ARG0:%.*]], i32 noundef [[ARG1:%.*]], i32 [[ARG2_COERCE0:%.*]], [[STRUCT_NESTED:%.*]] [[ARG2_COERCE1:%.*]], i32 [[ARG3_COERCE0:%.*]], [[STRUCT_NESTED]] [[ARG3_COERCE1:%.*]], ptr addrspace(5) nocapture noundef readnone byval([[STRUCT_NUM_REGS_NESTED_STRUCT:%.*]]) align 8 [[ARG4:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_reg_state_num_regs_nested_struct(int4 arg0, int arg1, num_regs_nested_struct arg2, num_regs_nested_struct arg3, num_regs_nested_struct arg4) { }

// CHECK-LABEL: define dso_local void @func_double_nested_struct_arg
// CHECK-SAME: (<4 x i32> noundef [[ARG0:%.*]], i32 noundef [[ARG1:%.*]], i32 [[ARG2_COERCE0:%.*]], [[STRUCT_DOUBLE_NESTED:%.*]] [[ARG2_COERCE1:%.*]], i16 [[ARG2_COERCE2:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_double_nested_struct_arg(int4 arg0, int arg1, double_nested_struct arg2) { }

// CHECK-LABEL: define dso_local %struct.double_nested_struct @func_double_nested_struct_ret
// CHECK-SAME: (<4 x i32> noundef [[ARG0:%.*]], i32 noundef [[ARG1:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret [[STRUCT_DOUBLE_NESTED_STRUCT:%.*]] zeroinitializer
//
double_nested_struct func_double_nested_struct_ret(int4 arg0, int arg1) {
  double_nested_struct s = { 0 };
  return s;
}

// CHECK-LABEL: define dso_local void @func_large_struct_padding_arg_direct
// CHECK-SAME: (i8 [[ARG_COERCE0:%.*]], i32 [[ARG_COERCE1:%.*]], i8 [[ARG_COERCE2:%.*]], i32 [[ARG_COERCE3:%.*]], i8 [[ARG_COERCE4:%.*]], i8 [[ARG_COERCE5:%.*]], i16 [[ARG_COERCE6:%.*]], i16 [[ARG_COERCE7:%.*]], [3 x i8] [[ARG_COERCE8:%.*]], i64 [[ARG_COERCE9:%.*]], i32 [[ARG_COERCE10:%.*]], i8 [[ARG_COERCE11:%.*]], i32 [[ARG_COERCE12:%.*]], i16 [[ARG_COERCE13:%.*]], i8 [[ARG_COERCE14:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void func_large_struct_padding_arg_direct(large_struct_padding arg) { }

void func_large_struct_padding_arg_store(global large_struct_padding* out, large_struct_padding arg) {
  *out = arg;
}

// CHECK-LABEL: define dso_local void @v3i32_reg_count
// CHECK-SAME: (<3 x i32> noundef [[ARG1:%.*]], <3 x i32> noundef [[ARG2:%.*]], <3 x i32> noundef [[ARG3:%.*]], <3 x i32> noundef [[ARG4:%.*]], i32 [[ARG5_COERCE0:%.*]], float [[ARG5_COERCE1:%.*]], i32 [[ARG5_COERCE2:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v3i32_reg_count(int3 arg1, int3 arg2, int3 arg3, int3 arg4, struct_arg_t arg5) { }

// Function signature from blender, nothing should be passed byval. The v3i32
// should not count as 4 passed registers.
// CHECK-LABEL: define dso_local void @v3i32_pair_reg_count
// CHECK-SAME: (ptr addrspace(5) nocapture noundef readnone [[ARG0:%.*]], <3 x i32> [[ARG1_COERCE0:%.*]], <3 x i32> [[ARG1_COERCE1:%.*]], <3 x i32> noundef [[ARG2:%.*]], <3 x i32> [[ARG3_COERCE0:%.*]], <3 x i32> [[ARG3_COERCE1:%.*]], <3 x i32> noundef [[ARG4:%.*]], float noundef [[ARG5:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v3i32_pair_reg_count(int3_pair *arg0, int3_pair arg1, int3 arg2, int3_pair arg3, int3 arg4, float arg5) { }

// Each short4 should fit pack into 2 registers.
// CHECK-LABEL: define dso_local void @v4i16_reg_count
// CHECK-SAME: (<4 x i16> noundef [[ARG0:%.*]], <4 x i16> noundef [[ARG1:%.*]], <4 x i16> noundef [[ARG2:%.*]], <4 x i16> noundef [[ARG3:%.*]], <4 x i16> noundef [[ARG4:%.*]], <4 x i16> noundef [[ARG5:%.*]], i32 [[ARG6_COERCE0:%.*]], i32 [[ARG6_COERCE1:%.*]], i32 [[ARG6_COERCE2:%.*]], i32 [[ARG6_COERCE3:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v4i16_reg_count(short4 arg0, short4 arg1, short4 arg2, short4 arg3,
                     short4 arg4, short4 arg5, struct_4regs arg6) { }

// CHECK-LABEL: define dso_local void @v4i16_pair_reg_count_over
// CHECK-SAME: (<4 x i16> noundef [[ARG0:%.*]], <4 x i16> noundef [[ARG1:%.*]], <4 x i16> noundef [[ARG2:%.*]], <4 x i16> noundef [[ARG3:%.*]], <4 x i16> noundef [[ARG4:%.*]], <4 x i16> noundef [[ARG5:%.*]], <4 x i16> noundef [[ARG6:%.*]], ptr addrspace(5) nocapture noundef readnone byval([[STRUCT_STRUCT_4REGS:%.*]]) align 4 [[ARG7:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v4i16_pair_reg_count_over(short4 arg0, short4 arg1, short4 arg2, short4 arg3,
                               short4 arg4, short4 arg5, short4 arg6, struct_4regs arg7) { }

// CHECK-LABEL: define dso_local void @v3i16_reg_count
// CHECK-SAME: (<3 x i16> noundef [[ARG0:%.*]], <3 x i16> noundef [[ARG1:%.*]], <3 x i16> noundef [[ARG2:%.*]], <3 x i16> noundef [[ARG3:%.*]], <3 x i16> noundef [[ARG4:%.*]], <3 x i16> noundef [[ARG5:%.*]], i32 [[ARG6_COERCE0:%.*]], i32 [[ARG6_COERCE1:%.*]], i32 [[ARG6_COERCE2:%.*]], i32 [[ARG6_COERCE3:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v3i16_reg_count(short3 arg0, short3 arg1, short3 arg2, short3 arg3,
                     short3 arg4, short3 arg5, struct_4regs arg6) { }

// CHECK-LABEL: define dso_local void @v3i16_reg_count_over
// CHECK-SAME: (<3 x i16> noundef [[ARG0:%.*]], <3 x i16> noundef [[ARG1:%.*]], <3 x i16> noundef [[ARG2:%.*]], <3 x i16> noundef [[ARG3:%.*]], <3 x i16> noundef [[ARG4:%.*]], <3 x i16> noundef [[ARG5:%.*]], <3 x i16> noundef [[ARG6:%.*]], ptr addrspace(5) nocapture noundef readnone byval([[STRUCT_STRUCT_4REGS:%.*]]) align 4 [[ARG7:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v3i16_reg_count_over(short3 arg0, short3 arg1, short3 arg2, short3 arg3,
                          short3 arg4, short3 arg5, short3 arg6, struct_4regs arg7) { }

// CHECK-LABEL: define dso_local void @v2i16_reg_count
// CHECK-SAME: (<2 x i16> noundef [[ARG0:%.*]], <2 x i16> noundef [[ARG1:%.*]], <2 x i16> noundef [[ARG2:%.*]], <2 x i16> noundef [[ARG3:%.*]], <2 x i16> noundef [[ARG4:%.*]], <2 x i16> noundef [[ARG5:%.*]], <2 x i16> noundef [[ARG6:%.*]], <2 x i16> noundef [[ARG7:%.*]], <2 x i16> noundef [[ARG8:%.*]], <2 x i16> noundef [[ARG9:%.*]], <2 x i16> noundef [[ARG10:%.*]], <2 x i16> noundef [[ARG11:%.*]], i32 [[ARG13_COERCE0:%.*]], i32 [[ARG13_COERCE1:%.*]], i32 [[ARG13_COERCE2:%.*]], i32 [[ARG13_COERCE3:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v2i16_reg_count(short2 arg0, short2 arg1, short2 arg2, short2 arg3,
                     short2 arg4, short2 arg5, short2 arg6, short2 arg7,
                     short2 arg8, short2 arg9, short2 arg10, short2 arg11,
                     struct_4regs arg13) { }

// CHECK-LABEL: define dso_local void @v2i16_reg_count_over
// CHECK-SAME: (<2 x i16> noundef [[ARG0:%.*]], <2 x i16> noundef [[ARG1:%.*]], <2 x i16> noundef [[ARG2:%.*]], <2 x i16> noundef [[ARG3:%.*]], <2 x i16> noundef [[ARG4:%.*]], <2 x i16> noundef [[ARG5:%.*]], <2 x i16> noundef [[ARG6:%.*]], <2 x i16> noundef [[ARG7:%.*]], <2 x i16> noundef [[ARG8:%.*]], <2 x i16> noundef [[ARG9:%.*]], <2 x i16> noundef [[ARG10:%.*]], <2 x i16> noundef [[ARG11:%.*]], <2 x i16> noundef [[ARG12:%.*]], ptr addrspace(5) nocapture noundef readnone byval([[STRUCT_STRUCT_4REGS:%.*]]) align 4 [[ARG13:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v2i16_reg_count_over(short2 arg0, short2 arg1, short2 arg2, short2 arg3,
                          short2 arg4, short2 arg5, short2 arg6, short2 arg7,
                          short2 arg8, short2 arg9, short2 arg10, short2 arg11,
                          short2 arg12, struct_4regs arg13) { }

// CHECK-LABEL: define dso_local void @v2i8_reg_count
// CHECK-SAME: (<2 x i8> noundef [[ARG0:%.*]], <2 x i8> noundef [[ARG1:%.*]], <2 x i8> noundef [[ARG2:%.*]], <2 x i8> noundef [[ARG3:%.*]], <2 x i8> noundef [[ARG4:%.*]], <2 x i8> noundef [[ARG5:%.*]], i32 [[ARG6_COERCE0:%.*]], i32 [[ARG6_COERCE1:%.*]], i32 [[ARG6_COERCE2:%.*]], i32 [[ARG6_COERCE3:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v2i8_reg_count(char2 arg0, char2 arg1, char2 arg2, char2 arg3,
                    char2 arg4, char2 arg5, struct_4regs arg6) { }

// CHECK-LABEL: define dso_local void @v2i8_reg_count_over
// CHECK-SAME: (<2 x i8> noundef [[ARG0:%.*]], <2 x i8> noundef [[ARG1:%.*]], <2 x i8> noundef [[ARG2:%.*]], <2 x i8> noundef [[ARG3:%.*]], <2 x i8> noundef [[ARG4:%.*]], <2 x i8> noundef [[ARG5:%.*]], i32 noundef [[ARG6:%.*]], ptr addrspace(5) nocapture noundef readnone byval([[STRUCT_STRUCT_4REGS:%.*]]) align 4 [[ARG7:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void v2i8_reg_count_over(char2 arg0, char2 arg1, char2 arg2, char2 arg3,
                         char2 arg4, char2 arg5, int arg6, struct_4regs arg7) { }

// CHECK-LABEL: define dso_local void @num_regs_left_64bit_aggregate
// CHECK-SAME: (<4 x i32> noundef [[ARG0:%.*]], <4 x i32> noundef [[ARG1:%.*]], <4 x i32> noundef [[ARG2:%.*]], <3 x i32> noundef [[ARG3:%.*]], [2 x i32] [[ARG4_COERCE:%.*]], i32 noundef [[ARG5:%.*]]) local_unnamed_addr #[[ATTR1]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
void num_regs_left_64bit_aggregate(int4 arg0, int4 arg1, int4 arg2, int3 arg3, struct_char_x8 arg4, int arg5) { }
