{-# LANGUAGE DeriveDataTypeable #-}

-- | A newtype around a list of Strings which represent the MXes whose
--   remote forwards we don't report. This is all to avoid an orphan
--   instance of Configured for [String] if we had defined one in
--   e.g. 'OptionalConfiguration'.
--
module MxList (
  MxList( MxList, get_mxs ) )
where

-- DC is needed only for the DCT.Configured instance of String.
import qualified Data.Configurator as DC()
import qualified Data.Configurator.Types as DCT (
  Configured,
  Value( List ),
  convert )
import Data.Data (Data)
import System.Console.CmdArgs.Default ( Default( def ) )


-- | A (wrapper around a) list of MX hostnames.
--
newtype MxList =
  MxList { get_mxs :: [String] }
    deriving (Data, Show)


-- | The default (empty) list of MXes.
--
instance Default MxList where
  def = MxList []


instance DCT.Configured MxList where
  -- | This allows us to read a MxList object out of a Configurator
  --   config file. By default Configurator wouldn't know what to do,
  --   so we have to tell it that we expect a list, and if that list
  --   has strings in it, we can apply the MxList constructor to
  --   it.
  convert (DCT.List xs) =
    -- mapM gives us a Maybe [String] here.
    fmap MxList (mapM convert_string xs)
    where
      convert_string :: DCT.Value -> Maybe String
      convert_string = DCT.convert

  -- If we read anything other than a list of values out of the file,
  -- fail.
  convert _ = Nothing
