/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IGraphicalViewer;

public class ScrollingSynchronizer {
    private boolean horizontal;
    private List<ViewportHook> hooks = new ArrayList<ViewportHook>();

    public ScrollingSynchronizer() {
        this(false);
    }

    public ScrollingSynchronizer(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public void add(IGraphicalViewer viewer) {
        this.hooks.add(new ViewportHook(viewer.getCanvas().getViewport()));
    }

    public void add(Viewport viewport) {
        this.hooks.add(new ViewportHook(viewport));
    }

    private void syncScroll(Viewport source, int delta) {
        for (ViewportHook hook : this.hooks) {
            if (hook.getViewport() == source) continue;
            hook.scroll(delta);
        }
    }

    private void readjustViewports() {
        for (ViewportHook hook : this.hooks) {
            hook.readjustViewport();
        }
    }

    private class ViewportHook
    implements PropertyChangeListener {
        private Viewport viewport;
        private boolean ignorePropertyChange = false;

        public ViewportHook(Viewport viewport) {
            this.viewport = viewport;
            this.init();
        }

        private void init() {
            if (ScrollingSynchronizer.this.horizontal) {
                this.viewport.getHorizontalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                this.viewport.getVerticalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public Viewport getViewport() {
            return this.viewport;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.ignorePropertyChange) {
                return;
            }
            if ("value".equals(evt.getPropertyName())) {
                int oldValue = (Integer)evt.getOldValue();
                int newValue = (Integer)evt.getNewValue();
                ScrollingSynchronizer.this.syncScroll(this.getViewport(), newValue - oldValue);
            } else {
                ScrollingSynchronizer.this.readjustViewports();
            }
        }

        public void scroll(int delta) {
            this.ignorePropertyChange = true;
            Point loc = this.viewport.getViewLocation();
            if (ScrollingSynchronizer.this.horizontal) {
                this.viewport.setViewLocation(loc.x + delta, loc.y);
            } else {
                this.viewport.setViewLocation(loc.x, loc.y + delta);
            }
            this.ignorePropertyChange = false;
        }

        public void readjustViewport() {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ViewportHook.this.getViewport().revalidate();
                }
            });
        }
    }
}

