/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponentRefManager;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.dom.WorkbookImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookComponentRefCounter
implements IWorkbookComponentRefManager,
ICoreEventSource {
    private static final Collection<String> EMPTY = Collections.emptySet();
    private WorkbookImpl workbook;
    private Map<String, Collection<String>> source2targets;
    private Map<String, Collection<String>> target2sources;

    public WorkbookComponentRefCounter(WorkbookImpl workbook) {
        this.workbook = workbook;
    }

    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public void increaseRef(String source, String target) {
        Collection<String> sources;
        Collection<String> targets;
        if (this.source2targets == null) {
            this.source2targets = new HashMap<String, Collection<String>>();
        }
        if ((targets = this.source2targets.get(source)) == null) {
            targets = new HashSet<String>();
            this.source2targets.put(source, targets);
        }
        targets.add(target);
        if (this.target2sources == null) {
            this.target2sources = new HashMap<String, Collection<String>>();
        }
        if ((sources = this.target2sources.get(target)) == null) {
            sources = new HashSet<String>();
            this.target2sources.put(target, sources);
        }
        sources.add(target);
    }

    @Override
    public void decreaseRef(String source, String target) {
        Collection<String> sources;
        Collection<String> targets;
        if (this.source2targets != null && (targets = this.source2targets.get(source)) != null) {
            targets.remove(target);
            if (targets.isEmpty()) {
                this.source2targets.remove(source);
            }
        }
        if (this.target2sources != null && (sources = this.target2sources.get(target)) != null) {
            sources.remove(source);
            if (sources.isEmpty()) {
                this.target2sources.remove(target);
            }
        }
    }

    @Override
    public Collection<String> getSources() {
        return this.source2targets == null ? EMPTY : this.source2targets.keySet();
    }

    @Override
    public Collection<String> getSources(String target) {
        Collection<String> sources;
        if (this.target2sources != null && (sources = this.target2sources.get(target)) != null) {
            return sources;
        }
        return EMPTY;
    }

    @Override
    public Collection<String> getTargets() {
        return this.target2sources == null ? EMPTY : this.target2sources.keySet();
    }

    @Override
    public Collection<String> getTargets(String source) {
        Collection<String> targets;
        if (this.source2targets != null && (targets = this.source2targets.get(source)) != null) {
            return targets;
        }
        return EMPTY;
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.workbook.getCoreEventSupport();
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }
}

