/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmind.core.Core;
import org.xmind.core.internal.dom.MarkerResource;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerResourceAllocator;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.util.FileUtils;

public class MarkerResourceProvider
implements IMarkerResourceProvider,
IMarkerResourceAllocator {
    private IInputSource source;
    private IOutputTarget target;
    private boolean permanent;

    public MarkerResourceProvider(IInputSource source, IOutputTarget target) {
        this(source, target, false);
    }

    public MarkerResourceProvider(IInputSource source, IOutputTarget target, boolean permanent) {
        this.source = source;
        this.target = target;
        this.permanent = permanent;
    }

    public IMarkerResource getMarkerResource(IMarker marker) {
        if ("".equals(marker.getResourcePath())) {
            return null;
        }
        return new MarkerResource(marker, this.source, this.target);
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public String allocateMarkerResource(InputStream input, String suggestedPath) throws IOException {
        if (this.target == null) {
            return null;
        }
        String ext = suggestedPath == null ? ".png" : FileUtils.getExtension(suggestedPath);
        String path = String.valueOf(Core.getIdFactory().createId()) + ext;
        if (!this.target.isEntryAvaialble(path)) {
            return null;
        }
        OutputStream output = this.target.openEntryStream(path);
        try {
            FileUtils.transfer(input, output, false);
        }
        finally {
            output.close();
        }
        return path;
    }
}

