/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.remote.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.xmind.core.command.remote.ICommandServer;
import org.xmind.core.command.remote.ICommandServiceDomain;
import org.xmind.core.command.remote.ICommandServiceInfo;
import org.xmind.core.command.remote.socket.IncomingSocketCommandHandler;
import org.xmind.core.command.remote.socket.SocketAddress;
import org.xmind.core.command.remote.socket.SocketCommandServiceInfo;
import org.xmind.core.command.remote.socket.SocketPool;
import org.xmind.core.internal.command.remote.Messages;
import org.xmind.core.internal.command.remote.RemoteCommandPlugin;

public class SocketCommandServer
implements ICommandServer {
    private ICommandServiceDomain domain;
    private int defaultPort;
    private int defaultBacklog;
    private boolean triesEphemeralPort;
    private ServerSocket server = null;
    private Thread thread = null;
    private SocketCommandServiceInfo info = null;
    private Object lock = new Object();
    private Runnable serverRunner = new Runnable(){

        public void run() {
            ServerSocket theServer = SocketCommandServer.this.server;
            if (theServer == null) {
                return;
            }
            try {
                try {
                    while (true) {
                        Socket socket = theServer.accept();
                        SocketCommandServer.this.socketPool.addSocket(socket);
                        SocketCommandServer.this.runIncomingCommandHandler(socket);
                    }
                }
                catch (IOException e) {
                    if (SocketCommandServer.this.thread != null || SocketCommandServer.this.server != null) {
                        RemoteCommandPlugin.log("Error occurred while handling local command server.", e);
                    }
                    try {
                        theServer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                try {
                    theServer.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
    };
    private SocketPool socketPool = new SocketPool();

    public SocketCommandServer() {
        this(0, 50, false);
    }

    public SocketCommandServer(int defaultPort, int defaultBacklog, boolean triesEphemeralPort) {
        if (defaultPort < 0) {
            defaultPort = 0;
        }
        this.defaultPort = defaultPort;
        this.defaultBacklog = defaultBacklog;
        this.triesEphemeralPort = triesEphemeralPort;
    }

    public void init(ICommandServiceDomain domain) {
        this.domain = domain;
    }

    public ICommandServiceDomain getDomain() {
        return this.domain;
    }

    public int getDefaultBacklog() {
        return this.defaultBacklog;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public ServerSocket getServer() {
        return this.server;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus deploy(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.SocketCommandServer_OperationLock);
        Object object = this.lock;
        synchronized (object) {
            monitor.subTask(Messages.SocketCommandServer_OpenCommandServerSocket);
            if (this.server == null || this.server.isClosed()) {
                try {
                    this.server = new ServerSocket();
                }
                catch (IOException e) {
                    return new Status(4, "org.xmind.core.command.remote", null, (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(20);
                InetAddress localAddress = null;
                int port = this.defaultPort;
                try {
                    this.server.bind(new InetSocketAddress(localAddress, port), this.defaultBacklog);
                }
                catch (IOException e) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (port != 0 && this.triesEphemeralPort) {
                        try {
                            this.server.bind(new InetSocketAddress(localAddress, 0), this.defaultBacklog);
                        }
                        catch (IOException iOException) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            return new Status(4, "org.xmind.core.command.remote", null, (Throwable)e);
                        }
                    }
                    return new Status(4, "org.xmind.core.command.remote", null, (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(60);
            } else {
                monitor.worked(70);
            }
            if (this.info == null) {
                this.info = new SocketCommandServiceInfo();
                this.info.setAddress(new SocketAddress(this.server.getInetAddress().getHostName(), this.server.getLocalPort()));
                this.info.setName(System.getProperty("user.name"));
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(10);
            if (this.thread == null) {
                this.thread = new Thread(this.serverRunner, this.getLoopThreadName());
                this.thread.setDaemon(true);
                this.thread.setPriority(1);
                this.thread.start();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(10);
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus undeploy(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.SocketCommandServer_OperationLock);
        Object object = this.lock;
        synchronized (object) {
            monitor.subTask(Messages.SocketCommandServer_CloseCommandServerSocket);
            Thread oldThread = this.thread;
            ServerSocket oldServer = this.server;
            this.thread = null;
            this.server = null;
            this.info = null;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(10);
            if (oldThread != null) {
                oldThread.interrupt();
            }
            if (oldServer != null) {
                try {
                    oldServer.close();
                }
                catch (IOException e) {
                    RemoteCommandPlugin.log("Could not stop local command server socket.", e);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(90);
            this.socketPool.clear();
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    public ICommandServiceInfo getRegisteringInfo() {
        return this.info;
    }

    public SocketPool getSocketPool() {
        return this.socketPool;
    }

    protected void runIncomingCommandHandler(Socket socket) {
        this.createIncomingCommandHandler(socket).schedule();
    }

    protected Job createIncomingCommandHandler(Socket socket) {
        IncomingSocketCommandHandler handler = new IncomingSocketCommandHandler(socket);
        handler.setSocketPool(this.getSocketPool());
        return handler;
    }

    protected String getLoopThreadName() {
        return "SocketCommandServerLoop";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SocketPool.class) {
            return this.getSocketPool();
        }
        return null;
    }
}

