/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.merging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.mindmap.merging.MapMergePlugin;
import org.xmind.ui.internal.mindmap.merging.MergeMessages;
import org.xmind.ui.mindmap.IMindMap;

public class MapChooseDialog
extends TitleAreaDialog {
    private static final String SECTION_NAME = "org.xmind.ui.MergeDialog";
    private IWorkbench workbench;
    private IMindMap sourceMap;
    private IMindMap targetMap;
    private TreeViewer viewer;

    public MapChooseDialog(Shell parentShell, IWorkbench workbench, IMindMap targetMap) {
        super(parentShell);
        this.workbench = workbench;
        this.targetMap = targetMap;
        this.setBlockOnOpen(true);
        this.setShellStyle(2160);
    }

    public void create() {
        super.create();
        this.setTitle(MergeMessages.MergeDialog_title);
        this.setTitleImage(null);
        this.setMessage(MergeMessages.MergeDialog_description);
        this.setSourceMapSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MergeMessages.MergeDialog_windowTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.viewer = new TreeViewer(composite, 2820);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new OpenedMapContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OpenedMapLabelProvider());
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)this.workbench);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new OpenedMapSelectionChangedListener());
        this.viewer.addOpenListener((IOpenListener)new OpenedMapOpenListener());
        return composite;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings ds = MapMergePlugin.getDefault().getDialogSettings();
        IDialogSettings section = ds.getSection(SECTION_NAME);
        if (section == null) {
            section = ds.addNewSection(SECTION_NAME);
        }
        return section;
    }

    public IMindMap getSourceMap() {
        return this.sourceMap;
    }

    private boolean hasSourceSheet() {
        return this.sourceMap != null && !this.targetMap.equals(this.sourceMap);
    }

    private void setSourceMapSelection(ISelection selection) {
        this.sourceMap = this.getMap(selection);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.hasSourceSheet());
        }
        if (this.sourceMap != null && this.sourceMap.equals(this.targetMap)) {
            this.setMessage(MergeMessages.MergeDialog_SameAsSource_message, 2);
        } else {
            this.setMessage(MergeMessages.MergeDialog_description);
        }
    }

    private IMindMap getMap(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IGraphicalEditorPage) {
            return (IMindMap)((IGraphicalEditorPage)element).getAdapter(IMindMap.class);
        }
        return null;
    }

    private class OpenedMapContentProvider
    implements ITreeContentProvider {
        private List<IGraphicalEditor> editors = new ArrayList<IGraphicalEditor>();
        private Map<IGraphicalEditor, List<IGraphicalEditorPage>> pages = new HashMap<IGraphicalEditor, List<IGraphicalEditorPage>>();

        private OpenedMapContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            List<IGraphicalEditorPage> list = this.pages.get(parentElement);
            return list == null ? new Object[]{} : list.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof IGraphicalEditor) {
                return ((IGraphicalEditor)element).getSite().getWorkbenchWindow().getWorkbench();
            }
            if (element instanceof IGraphicalEditorPage) {
                return ((IGraphicalEditorPage)element).getParentEditor();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IWorkbench) {
                return true;
            }
            if (element instanceof IGraphicalEditor) {
                List<IGraphicalEditorPage> list = this.pages.get(element);
                return list != null && !list.isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.editors.toArray();
        }

        public void dispose() {
            this.editors.clear();
            this.pages.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.editors.clear();
            this.pages.clear();
            if (newInput instanceof IWorkbench) {
                IWorkbench workbench = (IWorkbench)newInput;
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference ref = iEditorReferenceArray[n6];
                            IEditorPart editor = ref.getEditor(false);
                            if (editor instanceof IGraphicalEditor) {
                                this.add((IGraphicalEditor)editor);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }

        private void add(IGraphicalEditor editor) {
            ArrayList<IGraphicalEditorPage> list = new ArrayList<IGraphicalEditorPage>(editor.getPageCount());
            IGraphicalEditorPage[] iGraphicalEditorPageArray = editor.getPages();
            int n = iGraphicalEditorPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
                IMindMap sheet = (IMindMap)page.getAdapter(IMindMap.class);
                if (sheet != null) {
                    list.add(page);
                }
                ++n2;
            }
            if (!list.isEmpty()) {
                this.editors.add(editor);
                this.pages.put(editor, list);
            }
        }
    }

    private static class OpenedMapLabelProvider
    extends LabelProvider {
        private OpenedMapLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IGraphicalEditor) {
                return ((IGraphicalEditor)element).getTitle();
            }
            if (element instanceof IGraphicalEditorPage) {
                return ((IGraphicalEditorPage)element).getPageTitle();
            }
            return super.getText(element);
        }
    }

    private class OpenedMapOpenListener
    implements IOpenListener {
        private OpenedMapOpenListener() {
        }

        public void open(OpenEvent event) {
            MapChooseDialog.this.setSourceMapSelection(event.getSelection());
            if (MapChooseDialog.this.hasSourceSheet()) {
                MapChooseDialog.this.close();
            }
        }
    }

    private class OpenedMapSelectionChangedListener
    implements ISelectionChangedListener {
        private OpenedMapSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            MapChooseDialog.this.setSourceMapSelection(event.getSelection());
        }
    }
}

