/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.zen;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.CoreException;
import org.xmind.core.IDeserializer;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.AbstractSerializingBase;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.io.CoreIOException;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.io.InvalidChecksumException;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IProgressReporter;
import org.xmind.ui.internal.zen.ManifestDeserializer;
import org.xmind.ui.internal.zen.WorkbookDeserializer;

public class ZenDeserializer
extends AbstractSerializingBase
implements IDeserializer {
    private IWorkbook workbook;
    private IStorage storage;
    private IInputSource inputSource;
    private InputStream inputStream;
    private boolean usesWorkbookStorageAsInputSource;
    private IManifest manifest;
    private final Map<String, JSONObject> loadedJsons;
    private final Map<String, JSONArray> loadedJsonArrays;

    public ZenDeserializer(IStorage storage) {
        this.workbook = new WorkbookImpl(DOMUtils.createDocument(), storage);
        this.storage = storage;
        this.inputSource = null;
        this.inputStream = null;
        this.usesWorkbookStorageAsInputSource = false;
        this.manifest = null;
        this.loadedJsons = new HashMap<String, JSONObject>();
        this.loadedJsonArrays = new HashMap<String, JSONArray>();
    }

    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbookStorage(IStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.storage = storage;
    }

    public IStorage getWorkbookStorage() {
        return this.storage;
    }

    public void setInputSource(IInputSource source) {
        if (source == null) {
            throw new IllegalArgumentException("input source is null");
        }
        this.inputSource = source;
        this.inputStream = null;
        this.usesWorkbookStorageAsInputSource = false;
    }

    public void setInputStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        this.inputStream = stream;
        this.inputSource = null;
        this.usesWorkbookStorageAsInputSource = false;
    }

    public void setWorkbookStorageAsInputSource() {
        this.usesWorkbookStorageAsInputSource = true;
        this.inputSource = null;
        this.inputStream = null;
    }

    public boolean hasInputSource() {
        return this.inputSource != null || this.inputStream != null || this.usesWorkbookStorageAsInputSource;
    }

    public IManifest getManifest() {
        return this.manifest;
    }

    public void deserialize(IProgressReporter reporter) throws IOException, CoreException, IllegalStateException {
        if (this.manifest == null) {
            this.deserializeManifest(reporter);
        }
        try {
            this.loadWorkbook();
            this.purgeStorage();
        }
        catch (InvalidChecksumException e) {
            throw new CoreException(17, (Throwable)e);
        }
        catch (CoreIOException e) {
            CoreException ce = e.getCoreException();
            throw new CoreException(ce.getType(), ce.getCodeInfo(), (Throwable)e);
        }
    }

    public void deserializeManifest(IProgressReporter reporter) throws IOException, CoreException, IllegalStateException {
        if (this.inputStream != null) {
            ZipInputStream zin = new ZipInputStream(this.inputStream);
            try {
                FileUtils.extractZipFile((ZipInputStream)zin, (IOutputTarget)this.storage.getOutputTarget());
            }
            finally {
                zin.close();
            }
        } else if (this.inputSource != null) {
            FileUtils.transfer((IInputSource)this.inputSource, (IOutputTarget)this.storage.getOutputTarget());
        } else if (!this.usesWorkbookStorageAsInputSource) {
            throw new IllegalStateException("no input source available");
        }
        JSONObject manifestJson = this.forceLoadJsonFromEntry("manifest.json");
        this.manifest = this.workbook.getManifest();
        new ManifestDeserializer().deserialize(this.manifest, manifestJson);
        ((ManifestImpl)this.manifest).setStreamNormalizer(this.getEntryStreamNormalizer());
    }

    private void loadWorkbook() throws IOException, CoreException {
        JSONArray contentArray = this.forceLoadJsonArrayFromEntry("content.json");
        new WorkbookDeserializer().deserialize(this.workbook, contentArray);
        for (ISheet sheet : this.workbook.getSheets()) {
            ((SheetImpl)sheet).addNotify((WorkbookImpl)this.workbook);
        }
    }

    private JSONObject forceLoadJsonFromEntry(String entryPath) throws CoreException {
        JSONObject json;
        try {
            json = this.loadJsonFromEntry(entryPath);
        }
        catch (IOException iOException) {
            json = null;
        }
        if (json == null) {
            json = new JSONObject();
            this.loadedJsons.put(entryPath, json);
        }
        return json;
    }

    private JSONObject loadJsonFromEntry(String entryPath) throws IOException, CoreException {
        JSONObject json;
        JSONObject cache = this.loadedJsons.get(entryPath);
        if (cache != null) {
            return cache;
        }
        InputStream stream = this.openEntryInputStream(entryPath);
        if (stream == null) {
            return null;
        }
        try {
            try {
                json = this.loadJsonFromStream(stream);
            }
            catch (IOException e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
            catch (Error e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        if (json != null) {
            this.loadedJsons.put(entryPath, json);
        }
        return json;
    }

    private InputStream openEntryInputStream(String entryPath) throws IOException, CoreException {
        IInputSource source;
        IFileEntry entry;
        if (this.manifest == null && this.storage == null) {
            throw new IllegalStateException("No manifest or input source available");
        }
        if (this.manifest != null && (entry = this.manifest.getFileEntry(entryPath)) != null) {
            if (!entry.canRead()) {
                return null;
            }
            return entry.openInputStream();
        }
        if (this.storage != null && (source = this.storage.getInputSource()) != null && source.hasEntry(entryPath) && source.isEntryAvailable(entryPath)) {
            return source.openEntryStream(entryPath);
        }
        return null;
    }

    private JSONObject loadJsonFromStream(InputStream stream) throws IOException {
        BufferedReader reader = null;
        try {
            JSONObject json;
            String read;
            reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
            StringBuilder sb = new StringBuilder();
            while ((read = reader.readLine()) != null) {
                sb.append(read).append('\n');
            }
            JSONObject jSONObject = json = new JSONObject(sb.toString());
            return jSONObject;
        }
        finally {
            reader.close();
        }
    }

    private boolean hasEncryptionData(String entryPath) {
        if (this.manifest != null) {
            IFileEntry entry = this.manifest.getFileEntry(entryPath);
            return entry != null && entry.getEncryptionData() != null;
        }
        return false;
    }

    private JSONArray forceLoadJsonArrayFromEntry(String entryPath) throws CoreException {
        JSONArray json;
        try {
            json = this.loadJsonArrayFromEntry(entryPath);
        }
        catch (IOException iOException) {
            json = null;
        }
        if (json == null) {
            json = new JSONArray();
            this.loadedJsonArrays.put(entryPath, json);
        }
        return json;
    }

    private JSONArray loadJsonArrayFromEntry(String entryPath) throws IOException, CoreException {
        JSONArray json;
        JSONArray cache = this.loadedJsonArrays.get(entryPath);
        if (cache != null) {
            return cache;
        }
        InputStream stream = this.openEntryInputStream(entryPath);
        if (stream == null) {
            return null;
        }
        try {
            try {
                json = this.loadJsonArrayFromStream(stream);
            }
            catch (IOException e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
            catch (Error e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        if (json != null) {
            this.loadedJsonArrays.put(entryPath, json);
        }
        return json;
    }

    private JSONArray loadJsonArrayFromStream(InputStream stream) throws IOException {
        BufferedReader reader = null;
        try {
            JSONArray json;
            String read;
            reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
            StringBuilder sb = new StringBuilder();
            while ((read = reader.readLine()) != null) {
                sb.append(read).append('\n');
            }
            JSONArray jSONArray = json = new JSONArray(sb.toString());
            return jSONArray;
        }
        finally {
            reader.close();
        }
    }

    private void purgeStorage() {
        String rootPath = this.storage.getFullPath();
        File[] children = new File(rootPath).listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.getName().endsWith(".json")) {
                    child.delete();
                }
                ++n2;
            }
        }
    }
}

