/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.ui.blackbox.BlackBox;
import org.xmind.ui.blackbox.BlackBoxManager;
import org.xmind.ui.blackbox.IBlackBoxMap;
import org.xmind.ui.blackbox.IBlackBoxVersion;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.SWTUtils;

public class BlackBoxView
extends ViewPart
implements ICoreEventListener {
    private static final String MAP_REMOVE = "mapRemove";
    private static final String VERSION_REMOVE = "versionRemove";
    private static final String VERSION_ADD = "versionAdd";
    private TreeViewer viewer;
    private MenuManager contextMenu;
    private CoreEventRegister coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
    private List<IAction> actions = new ArrayList<IAction>();

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label top = new Label(composite, 64);
        top.setText(Messages.BlackBoxView_Description_text);
        top.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Control viewerControl = this.createViewer(composite);
        viewerControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fillAndRegisterMenu();
        this.registerCoreEvent();
    }

    private void registerCoreEvent() {
        this.coreEventRegister.setNextSourceFrom((Object)BlackBoxManager.getInstance().getLibrary());
        this.coreEventRegister.register(VERSION_ADD);
        this.coreEventRegister.register(VERSION_REMOVE);
        this.coreEventRegister.register(MAP_REMOVE);
    }

    private Control createViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 66306);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new BlackBoxContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BlackBoxLabelProvide());
        TreeViewerColumn col0 = new TreeViewerColumn(this.viewer, 16384);
        col0.getColumn().setText(Messages.BlackBoxView_Versions);
        col0.getColumn().setWidth(200);
        col0.setLabelProvider((CellLabelProvider)new VersionsLabelProvider());
        TreeViewerColumn col1 = new TreeViewerColumn(this.viewer, 16384);
        col1.getColumn().setText(Messages.BlackBoxView_Info);
        col1.getColumn().setWidth(300);
        col1.setLabelProvider((CellLabelProvider)new VersionsInfoLabelProvider());
        this.viewer.setInput((Object)BlackBox.getMaps());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setSorter((ViewerSorter)new BlackBoxSorter());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new VersionOpenListener());
        this.viewer.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (SWTUtils.matchKey((int)e.stateMask, (int)e.keyCode, (int)0, (int)32)) {
                    BlackBoxView.this.handleOpen(BlackBoxView.this.viewer.getSelection());
                }
            }
        });
        return this.viewer.getControl();
    }

    private void fillAndRegisterMenu() {
        OpenReversionAction openAction = new OpenReversionAction();
        openAction.setText(Messages.BlackBoxView_OpenVersion);
        openAction.setToolTipText(Messages.BlackBoxView_OpenVersion);
        openAction.setImageDescriptor(MindMapUI.getImages().get("fldr_obj.gif", true));
        openAction.setDisabledImageDescriptor(MindMapUI.getImages().get("fldr_obj.gif", false));
        this.addAction((IAction)openAction);
        DeleteBackupsAction deleteAction = new DeleteBackupsAction();
        deleteAction.setText(Messages.BlackBoxView_DeleteBackups);
        deleteAction.setToolTipText(Messages.BlackBoxView_DeleteBackups);
        deleteAction.setImageDescriptor(MindMapUI.getImages().get("remove.png", true));
        deleteAction.setDisabledImageDescriptor(MindMapUI.getImages().get("remove.png", false));
        this.addAction((IAction)deleteAction);
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)openAction);
        menu.add((IAction)deleteAction);
        menu.add((IContributionItem)new Separator("additions"));
        this.getViewSite().getActionBars().updateActionBars();
        this.contextMenu = new MenuManager("#PopupMenu");
        this.contextMenu.add((IAction)openAction);
        this.contextMenu.add((IAction)deleteAction);
        this.viewer.getControl().setMenu(this.contextMenu.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(this.contextMenu, (ISelectionProvider)this.viewer);
    }

    private void addAction(IAction action) {
        this.actions.add(action);
        if (action.getId() != null) {
            this.getViewSite().getActionBars().setGlobalActionHandler(action.getId(), action);
        }
        if (action instanceof ISelectionChangedListener) {
            this.getViewSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)action);
        }
    }

    public void setDamagedFile(File damagedFile) {
        if (damagedFile == null) {
            return;
        }
        String source = damagedFile.getAbsolutePath();
        IBlackBoxMap map = BlackBox.findMapBySource(source);
        if (map != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)map), true);
        }
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        for (IAction action : this.actions) {
            if (!(action instanceof ISelectionChangedListener)) continue;
            this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)action);
        }
        this.actions.clear();
        this.coreEventRegister.unregisterAll();
        super.dispose();
    }

    private void handleOpen(ISelection selection) {
        IStructuredSelection ss;
        File reversionFile = null;
        IBlackBoxMap map = null;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object element = ss.getFirstElement();
            if (element instanceof IBlackBoxVersion) {
                reversionFile = ((IBlackBoxVersion)element).getFile();
                map = ((IBlackBoxVersion)element).getMap();
            } else if (element instanceof IBlackBoxMap) {
                if (this.viewer.getExpandedState(element)) {
                    this.viewer.collapseToLevel(element, 2);
                } else {
                    this.viewer.expandToLevel(element, 2);
                }
            }
        }
        if (reversionFile == null || !reversionFile.exists() || map == null) {
            return;
        }
        this.handleOpen(reversionFile, map);
    }

    private void handleOpen(File reversionFile, IBlackBoxMap map) {
        try {
            IWorkbook workbook = Core.getWorkbookBuilder().loadFromFile(reversionFile);
            IEditorInput input = MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, new File(map.getSource()).getName());
            this.getSite().getPage().openEditor(input, "org.xmind.ui.MindMapEditor");
            if (workbook instanceof ICoreEventSource2) {
                ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        final String type = event.getType();
        this.getSite().getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BlackBoxView.VERSION_REMOVE.equals(type)) {
                    BlackBoxView.this.viewer.refresh(true);
                } else if (BlackBoxView.VERSION_ADD.equals(type) || BlackBoxView.MAP_REMOVE.equals(type)) {
                    BlackBoxView.this.viewer.setInput((Object)BlackBox.getMaps());
                }
            }
        });
    }

    private static class BlackBoxContentProvider
    implements ITreeContentProvider {
        private BlackBoxContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (IBlackBoxMap[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IBlackBoxMap) {
                return ((IBlackBoxMap)parentElement).getVersions().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IBlackBoxVersion) {
                return ((IBlackBoxVersion)element).getMap();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IBlackBoxMap) {
                return !((IBlackBoxMap)element).getVersions().isEmpty();
            }
            return false;
        }
    }

    private static class BlackBoxLabelProvide
    extends LabelProvider {
        private BlackBoxLabelProvide() {
        }

        public String getText(Object element) {
            if (element instanceof IBlackBoxMap) {
                String filePath = ((IBlackBoxMap)element).getSource();
                int index = filePath.lastIndexOf(File.separatorChar);
                String fileName = index <= 0 ? filePath : filePath.substring(index + 1);
                index = fileName.lastIndexOf(46);
                String fileNoExtension = index <= 0 ? fileName : fileName.substring(0, index);
                return fileNoExtension;
            }
            if (element instanceof IBlackBoxVersion) {
                return ((IBlackBoxVersion)element).getTimestamp();
            }
            return null;
        }
    }

    private class BlackBoxSorter
    extends ViewerSorter {
        private BlackBoxSorter() {
        }

        public int category(Object element) {
            if (element instanceof IBlackBoxMap) {
                return 0;
            }
            if (element instanceof IBlackBoxVersion) {
                return 1;
            }
            return 2;
        }
    }

    private class DeleteBackupsAction
    extends Action
    implements ISelectionChangedListener {
        private List<IBlackBoxMap> mapsToDelete = new ArrayList<IBlackBoxMap>();
        private List<IBlackBoxVersion> versionsToDelete = new ArrayList<IBlackBoxVersion>();

        public DeleteBackupsAction() {
            this.setEnabled(false);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            this.mapsToDelete.clear();
            this.versionsToDelete.clear();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                for (Object element : (IStructuredSelection)selection) {
                    if (element instanceof IBlackBoxVersion) {
                        this.versionsToDelete.add((IBlackBoxVersion)element);
                        continue;
                    }
                    if (!(element instanceof IBlackBoxMap)) continue;
                    this.mapsToDelete.add((IBlackBoxMap)element);
                }
            }
            this.setEnabled(!this.mapsToDelete.isEmpty() || !this.versionsToDelete.isEmpty());
        }

        public void run() {
            if (this.versionsToDelete.isEmpty() && this.mapsToDelete.isEmpty()) {
                return;
            }
            if (!this.versionsToDelete.isEmpty()) {
                for (IBlackBoxVersion version : this.versionsToDelete) {
                    IBlackBoxMap map = version.getMap();
                    BlackBox.removeVersion(map, version.getTimestamp());
                }
            }
            if (!this.mapsToDelete.isEmpty()) {
                for (IBlackBoxMap blackBoxMap : this.mapsToDelete) {
                    BlackBox.removeMap(blackBoxMap);
                }
            }
        }
    }

    private class OpenReversionAction
    extends Action
    implements ISelectionChangedListener {
        private File reversionFile;
        private IBlackBoxMap map = null;

        public OpenReversionAction() {
            this.setEnabled(false);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element;
            IStructuredSelection ss;
            ISelection selection = event.getSelection();
            this.reversionFile = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IBlackBoxVersion) {
                this.reversionFile = ((IBlackBoxVersion)element).getFile();
                this.map = ((IBlackBoxVersion)element).getMap();
            }
            this.setEnabled(this.reversionFile != null);
        }

        public void run() {
            if (this.reversionFile == null || !this.reversionFile.exists() || this.map == null) {
                return;
            }
            BlackBoxView.this.handleOpen(this.reversionFile, this.map);
        }
    }

    private class VersionOpenListener
    implements IDoubleClickListener {
        private VersionOpenListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            BlackBoxView.this.handleOpen(event.getSelection());
        }
    }

    private class VersionsInfoLabelProvider
    extends ColumnLabelProvider {
        private VersionsInfoLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBlackBoxMap) {
                return ((IBlackBoxMap)element).getSource();
            }
            if (element instanceof IBlackBoxVersion) {
                float fileSize = (float)((IBlackBoxVersion)element).getFile().length() / 1024.0f;
                String fss = String.valueOf(fileSize);
                int index = fss.indexOf(46);
                if (index < 0) {
                    return String.valueOf(fss) + "KB";
                }
                return String.valueOf(fss.substring(0, index + 2)) + "KB";
            }
            return null;
        }
    }

    private class VersionsLabelProvider
    extends ColumnLabelProvider {
        private VersionsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBlackBoxMap) {
                String path = ((IBlackBoxMap)element).getSource();
                int index = path.lastIndexOf(File.separatorChar);
                String mapName = index <= 0 ? path : path.substring(index + 1);
                return mapName;
            }
            if (element instanceof IBlackBoxVersion) {
                Long timestamp = Long.valueOf(((IBlackBoxVersion)element).getTimestamp());
                return String.format("%tF %tT", timestamp, timestamp);
            }
            return null;
        }

        public Image getImage(Object element) {
            ImageDescriptor image;
            if (element instanceof IBlackBoxMap && (image = MindMapUI.getImages().get("icons/xmind_file.16.png")) != null) {
                return image.createImage();
            }
            return null;
        }
    }
}

