/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.PartTextSelection;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.editor.MindMapEditorPage;
import org.xmind.ui.mindmap.ITitleTextPart;

public class IMESupport
implements ISelectionChangedListener,
Listener,
ControlListener,
SelectionListener,
FigureListener,
PaintListener {
    public static final String PROP_IGNORE_KEY_DOWN = "org.xmind.ui.ignoreKeyDown";
    private static final int DEFAULT_CARET_WIDTH = 2;
    private MindMapEditorPage page;
    private IGraphicalViewer viewer;
    private Canvas canvas;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private IME ime;
    private Caret caret;
    private boolean imeNeedDispose;
    private boolean caretNeedDispose;
    private int caretWidth;
    private int caretHeight;
    private IPart focus;
    private IFigure focusFigure = null;
    private TextLayout composition = null;
    private int compositionLeft = 0;
    private int compositionTop = 0;
    private StringBuilder composedCache = null;

    public IMESupport(MindMapEditorPage page, IGraphicalViewer viewer) {
        this.page = page;
        this.viewer = viewer;
        this.canvas = viewer.getCanvas();
        this.canvas.addControlListener((ControlListener)this);
        this.canvas.addPaintListener((PaintListener)this);
        this.hBar = this.canvas.getHorizontalBar();
        if (this.hBar != null) {
            this.hBar.addSelectionListener((SelectionListener)this);
        }
        this.vBar = this.canvas.getVerticalBar();
        if (this.vBar != null) {
            this.vBar.addSelectionListener((SelectionListener)this);
        }
        this.ime = this.canvas.getIME();
        if (this.ime == null) {
            this.ime = new IME(this.canvas, 0);
            this.imeNeedDispose = true;
        } else {
            this.imeNeedDispose = false;
        }
        this.ime.addListener(43, (Listener)this);
        this.caret = this.canvas.getCaret();
        if (this.caret == null) {
            this.caret = new Caret(this.canvas, 0);
            this.caretNeedDispose = true;
        } else {
            this.caretNeedDispose = false;
        }
        this.caret.setVisible(false);
        this.caretWidth = 2;
        this.caretHeight = -1;
        viewer.addFocusedPartChangedListener((ISelectionChangedListener)this);
    }

    public void dispose() {
        this.deactivateContext();
        if (this.composition != null) {
            this.composition.dispose();
            this.composition = null;
        }
        this.setFocusFigure(null);
        this.viewer.removeFocusedPartChangedListener((ISelectionChangedListener)this);
        if (this.ime != null) {
            if (!this.ime.isDisposed()) {
                this.ime.removeListener(43, (Listener)this);
            }
            if (this.imeNeedDispose) {
                this.ime.dispose();
            }
            this.ime = null;
        }
        if (this.caret != null) {
            if (this.caretNeedDispose) {
                this.caret.dispose();
            }
            this.caret = null;
        }
        if (this.vBar != null && !this.vBar.isDisposed()) {
            this.vBar.removeSelectionListener((SelectionListener)this);
        }
        if (this.hBar != null && !this.hBar.isDisposed()) {
            this.hBar.removeSelectionListener((SelectionListener)this);
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.removeControlListener((ControlListener)this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.focus = event.getSelection() instanceof IStructuredSelection ? this.viewer.findPart(((IStructuredSelection)event.getSelection()).getFirstElement()) : (event.getSelection() instanceof PartTextSelection ? ((PartTextSelection)event.getSelection()).getPart() : null);
        ITextFigure figure = null;
        if (this.focus instanceof ITitleTextPart) {
            figure = ((ITitleTextPart)this.focus).getTextFigure();
        } else if (this.focus != null) {
            ITitleTextPart title = (ITitleTextPart)this.focus.getAdapter(ITitleTextPart.class);
            if (title != null) {
                figure = title.getTextFigure();
            } else if (this.focus instanceof IGraphicalPart) {
                figure = ((IGraphicalPart)this.focus).getFigure();
            }
        }
        this.setFocusFigure((IFigure)figure);
    }

    private void setFocusFigure(IFigure figure) {
        if (figure != this.focusFigure) {
            if (this.focusFigure != null) {
                this.focusFigure.removeFigureListener((FigureListener)this);
            }
            if (figure != null) {
                figure.addFigureListener((FigureListener)this);
            }
            this.focusFigure = figure;
        }
        this.updateCompositionLocation();
    }

    private void updateCompositionLocation() {
        if (this.focusFigure != null) {
            Point pos = this.focusFigure.getBounds().getTopLeft();
            Insets border = this.focusFigure.getInsets();
            pos.translate(border.left, border.top);
            this.focusFigure.translateToAbsolute((Translatable)pos);
            this.setCompositionLocation(pos.x, pos.y);
        } else if (!this.canvas.isDisposed()) {
            Rectangle r = this.canvas.getBounds();
            this.setCompositionLocation(Math.max(0, r.width / 2 - 100), Math.max(0, Math.min(r.height / 2 + 100, r.height - this.caretHeight)));
        }
    }

    private void setCompositionLocation(int x, int y) {
        this.compositionLeft = x;
        this.compositionTop = y;
        this.updateCaretLocation();
    }

    private void updateCaretLocation() {
        if (this.caret == null || this.caret.isDisposed()) {
            return;
        }
        int x = this.compositionLeft;
        int y = this.compositionTop;
        this.caretWidth = 2;
        this.caretHeight = 10;
        if (this.ime.getCompositionOffset() >= 0 && this.composition != null && !this.composition.isDisposed()) {
            int cacheLength = this.composedCache == null ? 0 : this.composedCache.length();
            int caretOffset = cacheLength + this.ime.getCaretOffset();
            org.eclipse.swt.graphics.Point p = this.composition.getLocation(caretOffset, false);
            x = this.compositionLeft + p.x;
            y = this.compositionTop + p.y;
            if (this.ime.getWideCaret()) {
                Rectangle size = this.composition.getBounds(cacheLength, caretOffset);
                this.caretWidth = size.width;
                this.caretHeight = size.height;
            } else {
                this.caretWidth = 2;
                Rectangle size = this.composition.getBounds(caretOffset, caretOffset);
                this.caretHeight = size.height;
            }
        }
        this.caret.setBounds(x, y, this.caretWidth, this.caretHeight);
    }

    public void handleEvent(Event event) {
        if (event.type == 43) {
            switch (event.detail) {
                case 1: {
                    this.handleCompositionChanged(event);
                    break;
                }
                case 3: {
                    this.handleCompositionSelection(event);
                    break;
                }
                case 2: {
                    this.handleCompositionOffset(event);
                }
            }
        }
    }

    public void controlMoved(ControlEvent e) {
        this.updateCompositionLocation();
    }

    public void controlResized(ControlEvent e) {
        this.updateCompositionLocation();
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateCompositionLocation();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateCompositionLocation();
    }

    public void figureMoved(IFigure source) {
        this.updateCompositionLocation();
    }

    public void paintControl(PaintEvent e) {
        this.paintComposition(e.gc);
    }

    private void handleCompositionChanged(Event event) {
        String text = event.text;
        int length = text.length();
        if (length == this.ime.getCommitCount()) {
            if (length > 0) {
                if (this.composedCache == null) {
                    this.composedCache = new StringBuilder();
                }
                this.composedCache.append(text);
            }
            int ignoreCount = this.viewer.getProperties().getInteger(PROP_IGNORE_KEY_DOWN, 0);
            this.viewer.getProperties().set(PROP_IGNORE_KEY_DOWN, ignoreCount + text.length());
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (IMESupport.this.canvas == null || IMESupport.this.canvas.isDisposed()) {
                        return;
                    }
                    if (IMESupport.this.ime.getCompositionOffset() < 0) {
                        if (IMESupport.this.composedCache != null && IMESupport.this.composedCache.length() > 0) {
                            EditDomain domain = IMESupport.this.viewer.getEditDomain();
                            Request request = new Request("edit").setPrimaryTarget(IMESupport.this.focus).setDomain(domain).setViewer((IViewer)IMESupport.this.viewer).setParameter("text", (Object)IMESupport.this.composedCache.toString());
                            domain.handleRequest(request);
                        }
                        IMESupport.this.composedCache = null;
                        IMESupport.this.removeCompositionFeedback();
                    } else {
                        IMESupport.this.showCompositionFeedback(IMESupport.this.ime.getText());
                    }
                }
            });
        } else {
            this.showCompositionFeedback(text);
        }
    }

    private void handleCompositionSelection(Event event) {
        event.start = this.ime.getCompositionOffset() < 0 ? 0 : this.ime.getCaretOffset();
        event.end = this.ime.getCompositionOffset() < 0 ? 0 : this.ime.getCaretOffset();
        event.text = "";
    }

    private void handleCompositionOffset(Event event) {
        if (this.ime.getCompositionOffset() < 0 || this.composition == null || this.composition.isDisposed()) {
            event.index = 0;
            event.count = 0;
        } else {
            int offset;
            int x = event.x - this.compositionLeft;
            int y = event.y - this.compositionTop;
            int[] trailing = new int[1];
            event.index = offset = this.composition.getOffset(x, y, trailing);
            event.count = trailing[0];
        }
    }

    private void showCompositionFeedback(String text) {
        if (this.focusFigure == null) {
            this.removeCompositionFeedback();
            return;
        }
        if (this.composition == null || this.composition.isDisposed()) {
            this.composition = new TextLayout((Device)Display.getCurrent());
        }
        this.composition.setFont(this.focusFigure.getFont());
        if (this.composedCache != null) {
            text = String.valueOf(this.composedCache.toString()) + text;
        }
        this.composition.setText(text);
        this.canvas.redraw();
        this.updateCaretLocation();
        this.caret.setVisible(true);
        this.activateContext();
    }

    private void removeCompositionFeedback() {
        this.deactivateContext();
        if (this.composition != null) {
            this.composition.dispose();
            this.composition = null;
        }
        this.canvas.redraw();
        this.caret.setVisible(false);
    }

    private void activateContext() {
        IGraphicalEditor editor = this.page.getParentEditor();
        if (editor instanceof MindMapEditor) {
            ((MindMapEditor)editor).changeContext("org.xmind.ui.context.mindmap.textEdit");
        }
    }

    private void deactivateContext() {
        IGraphicalEditor editor = this.page.getParentEditor();
        if (editor instanceof MindMapEditor) {
            ((MindMapEditor)editor).changeContext(this.page.getEditDomain().getActiveTool());
        }
    }

    private void paintComposition(GC gc) {
        if (this.composition == null || this.composition.isDisposed()) {
            return;
        }
        Color fg = gc.getForeground();
        Color bg = gc.getBackground();
        int lineWidth = gc.getLineWidth();
        int lineStyle = gc.getLineStyle();
        int lineJoin = gc.getLineJoin();
        int lineCap = gc.getLineCap();
        Rectangle clipping = gc.getClipping();
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setLineJoin(3);
        gc.setLineCap(1);
        Rectangle size = this.composition.getBounds();
        gc.setClipping(this.compositionLeft - 2, this.compositionTop - 2, size.width + 4, size.height + 4);
        gc.setBackground(Display.getCurrent().getSystemColor(1));
        gc.fillRectangle(this.compositionLeft - 2, this.compositionTop - 2, size.width + 4, size.height + 4);
        gc.setForeground(Display.getCurrent().getSystemColor(16));
        gc.drawRectangle(this.compositionLeft - 2, this.compositionTop - 2, size.width + 3, size.height + 3);
        gc.setForeground(Display.getCurrent().getSystemColor(2));
        this.composition.draw(gc, this.compositionLeft, this.compositionTop);
        gc.setClipping(clipping);
        gc.setLineCap(lineCap);
        gc.setLineJoin(lineJoin);
        gc.setLineStyle(lineStyle);
        gc.setLineWidth(lineWidth);
        gc.setBackground(bg);
        gc.setForeground(fg);
    }
}

