/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.ui.internal.editor.IDialogPane;
import org.xmind.ui.internal.editor.IDialogPaneContainer;

public class DialogPaneContainer
implements IDialogPaneContainer {
    private Composite composite;
    private IDialogPane currentPane;
    private IServiceLocator serviceLocator;

    public void init(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public Control getControl() {
        return this.composite;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        Display display = parent.getDisplay();
        final Color background = new Color((Device)display, 56, 56, 56);
        this.composite.setBackground(background);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                background.dispose();
                DialogPaneContainer.this.handleDispose();
            }
        });
    }

    protected void handleDispose() {
        this.hideCurrentDialog();
    }

    @Override
    public void open(IDialogPane dialog) {
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        this.showDialog(dialog);
    }

    protected void showDialog(IDialogPane dialog) {
        IContextService contextService;
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        this.doHideCurrentDialog();
        this.currentPane = dialog;
        dialog.init(this);
        this.currentPane.createControl(this.composite);
        this.currentPane.setFocus();
        this.composite.layout(true);
        IContextService iContextService = contextService = this.serviceLocator == null ? null : (IContextService)this.serviceLocator.getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.xmind.ui.context.backcover");
        }
    }

    protected IDialogPane getCurrentDialog() {
        return this.currentPane;
    }

    protected void hideCurrentDialog() {
        this.doHideCurrentDialog();
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.layout(true);
        }
    }

    private void doHideCurrentDialog() {
        if (this.currentPane != null) {
            Control pageControl = this.currentPane.getControl();
            this.currentPane.dispose();
            if (pageControl != null && !pageControl.isDisposed()) {
                pageControl.dispose();
            }
            this.currentPane = null;
        }
    }

    public void dispose() {
        this.close();
        if (this.composite != null) {
            this.composite.dispose();
        }
    }

    public void setFocus() {
        if (this.currentPane != null) {
            this.currentPane.setFocus();
        } else {
            this.composite.setFocus();
        }
    }

    @Override
    public boolean close() {
        this.hideCurrentDialog();
        return this.currentPane == null;
    }

    @Override
    public void close(int returnCode) {
        if (this.currentPane != null) {
            this.currentPane.setReturnCode(returnCode);
        }
        this.close();
    }

    @Override
    public boolean isOpen() {
        return this.currentPane != null;
    }
}

