/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.xmind.core.ISheet;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.e4models.NotesPart;
import org.xmind.ui.mindmap.MindMapUI;

public class ShowAllNotesAction
extends Action {
    private NotesPart notesPart;

    public ShowAllNotesAction(NotesPart notesPart) {
        this.notesPart = notesPart;
        this.setId("org.xmind.ui.action.showAllNotes");
        this.setText(MindMapMessages.ShowAllNotes_text);
        this.setImageDescriptor(MindMapUI.getImages().get("menu_window_notes.png", true));
        this.setToolTipText(MindMapMessages.ShowAllNotes_tooltip);
    }

    public void run() {
        this.reveal();
    }

    private void reveal() {
        ISelectionProvider selectionProvider;
        if (this.notesPart == null) {
            return;
        }
        IGraphicalEditor editor = (IGraphicalEditor)this.notesPart.getContributingPart();
        if (editor == null) {
            return;
        }
        editor.getSite().getPage().activate((IWorkbenchPart)editor);
        ISheet sheet = (ISheet)editor.getActivePageInstance().getAdapter(ISheet.class);
        if (sheet != null && (selectionProvider = editor.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection((Object)sheet));
        }
    }
}

