/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IBoundary;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetComponent;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.IWordContext;
import org.xmind.ui.IWordContextProvider;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class MindMapWordContextProvider
implements IWordContextProvider {
    private IGraphicalEditor editor;

    public MindMapWordContextProvider(IGraphicalEditor editor) {
        this.editor = editor;
    }

    public List<IWordContext> getWordContexts() {
        ArrayList<IWordContext> contexts = new ArrayList<IWordContext>();
        IWorkbook workbook = (IWorkbook)this.editor.getAdapter(IWorkbook.class);
        if (workbook != null) {
            for (ISheet sheet : workbook.getSheets()) {
                this.getContexts(sheet.getRootTopic(), contexts);
                for (IRelationship relationship : sheet.getRelationships()) {
                    contexts.add(new RelationshipWordContext(relationship));
                }
            }
        }
        return contexts;
    }

    private void getContexts(ITopic topic, List<IWordContext> contexts) {
        contexts.add(new TopicWordContext(topic));
        if (!topic.getLabels().isEmpty()) {
            contexts.add(new LabelWordContext(topic));
        }
        if (!topic.getNotes().isEmpty()) {
            contexts.add(new NotesWordContext(topic));
        }
        for (IBoundary boundary : topic.getBoundaries()) {
            contexts.add(new BoundaryWordContext(boundary));
        }
        for (ITopic child : topic.getAllChildren()) {
            this.getContexts(child, contexts);
        }
    }

    private void revealElement(Object element, boolean makeActive) {
        if (makeActive) {
            this.editor.getSite().getPage().activate((IWorkbenchPart)this.editor);
        }
        this.editor.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(element));
    }

    private void revealInvalidWord(ISheetComponent element, int start, int length, String reqType) {
        this.revealElement(element, true);
        IGraphicalEditorPage page = this.editor.findPage((Object)element.getOwnedSheet());
        if (page != null) {
            IGraphicalViewer viewer = page.getViewer();
            EditDomain domain = page.getEditDomain();
            IPart part = viewer.findPart((Object)element);
            if (part != null) {
                Request request = new Request(reqType).setPrimaryTarget(part).setDomain(domain).setViewer((IViewer)viewer).setParameter("focus", (Object)Boolean.FALSE).setParameter("textSelection", (Object)new TextSelection(start, length));
                domain.handleRequest(request);
            }
        }
    }

    private boolean replaceText(ISheetComponent element, String newText) {
        return this.replaceText(element, newText, "modify");
    }

    private boolean replaceText(ISheetComponent element, String newText, String reqType) {
        this.revealElement(element, false);
        IGraphicalEditorPage page = this.editor.findPage((Object)element.getOwnedSheet());
        if (page != null) {
            IGraphicalViewer viewer = page.getViewer();
            EditDomain domain = page.getEditDomain();
            IPart part = viewer.findPart((Object)element);
            if (part != null) {
                Request request = new Request(reqType).setPrimaryTarget(part).setDomain(domain).setViewer((IViewer)viewer).setParameter("text", (Object)newText);
                domain.handleRequest(request);
                return true;
            }
        }
        return false;
    }

    private static String replaceString(String text, int start, int length, String replacement) {
        return String.valueOf(text.substring(0, start)) + replacement + text.substring(start + length);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MindMapWordContextProvider) {
            MindMapWordContextProvider provider = (MindMapWordContextProvider)obj;
            if (this.editor != null && this.editor.equals(provider.editor)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.editor.hashCode();
    }

    private class BoundaryWordContext
    implements IWordContext {
        private IBoundary boundary;

        public BoundaryWordContext(IBoundary boundary) {
            this.boundary = boundary;
        }

        public String getContent() {
            return this.boundary.getTitleText();
        }

        public ImageDescriptor getIcon() {
            return MindMapUI.getImages().getElementIcon(this.boundary, true);
        }

        public String getName() {
            return this.boundary.getTitleText();
        }

        public boolean replaceWord(int start, int length, String replacement) {
            return MindMapWordContextProvider.this.replaceText((ISheetComponent)this.boundary, MindMapWordContextProvider.replaceString(this.boundary.getTitleText(), start, length, replacement));
        }

        public void reveal() {
            MindMapWordContextProvider.this.revealElement(this.boundary, false);
        }

        public void revealWord(int start, int length) {
            MindMapWordContextProvider.this.revealInvalidWord((ISheetComponent)this.boundary, start, length, "edit");
        }

        public boolean equals(Object obj) {
            return obj instanceof BoundaryWordContext && this.boundary != null && this.boundary.equals(((BoundaryWordContext)obj).boundary);
        }

        public int hashCode() {
            return 17 * this.boundary.hashCode();
        }
    }

    private class LabelWordContext
    implements IWordContext {
        private ITopic topic;
        private static final String TYPE = "label";

        public LabelWordContext(ITopic topic) {
            this.topic = topic;
        }

        public String getContent() {
            return MindMapUtils.getLabelText(this.topic.getLabels());
        }

        public ImageDescriptor getIcon() {
            return MindMapUI.getImages().get("label.png", true);
        }

        public String getName() {
            return NLS.bind((String)MindMapMessages.WordContext_Label_pattern, (Object)this.topic.getTitleText());
        }

        public boolean replaceWord(int start, int length, String replacement) {
            return MindMapWordContextProvider.this.replaceText((ISheetComponent)this.topic, MindMapWordContextProvider.replaceString(MindMapUtils.getLabelText(this.topic.getLabels()), start, length, replacement), "modify_label");
        }

        public void reveal() {
            MindMapWordContextProvider.this.editor.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.topic));
        }

        public void revealWord(int start, int length) {
            MindMapWordContextProvider.this.revealInvalidWord((ISheetComponent)this.topic, start, length, "edit_label");
        }

        public boolean equals(Object obj) {
            return obj instanceof LabelWordContext && this.topic != null && this.topic.equals(((LabelWordContext)obj).topic);
        }

        public int hashCode() {
            int result = 17;
            result += result * this.topic.hashCode();
            result += result * TYPE.hashCode();
            return result;
        }
    }

    private class NotesWordContext
    implements IWordContext {
        private ITopic topic;
        private static final String TYPE = "notes";

        public NotesWordContext(ITopic topic) {
            this.topic = topic;
        }

        public String getContent() {
            IPlainNotesContent plainNotesContent = (IPlainNotesContent)this.topic.getNotes().getContent("plain");
            if (plainNotesContent == null) {
                return "";
            }
            return plainNotesContent.getTextContent();
        }

        public ImageDescriptor getIcon() {
            return MindMapUI.getImages().get("notes.png", true);
        }

        public String getName() {
            return NLS.bind((String)MindMapMessages.WordContext_Notes_pattern, (Object)this.topic.getTitleText());
        }

        public boolean replaceWord(int start, int length, String replacement) {
            ITextViewer viewer;
            Object obj;
            this.revealWord(start, length);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            MPart part = E4Utils.findPart(window, "org.xmind.ui.modelPart.notes");
            if (part != null && (obj = part.getObject()) instanceof IAdaptable && (viewer = (ITextViewer)((IAdaptable)obj).getAdapter(ITextViewer.class)) != null) {
                int r;
                String toFind = viewer.getTextWidget().getText(start, start + length - 1);
                IFindReplaceTarget target = (IFindReplaceTarget)((IAdaptable)obj).getAdapter(IFindReplaceTarget.class);
                if (target != null && (r = target.findAndSelect(start, toFind, true, true, false)) > -1) {
                    target.replaceSelection(replacement);
                    return true;
                }
            }
            return false;
        }

        public void reveal() {
            MindMapWordContextProvider.this.revealElement(this.topic, false);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        E4Utils.showPart("org.xmind.ui.command.showModelPart", window, "org.xmind.ui.modelPart.notes", null, "org.xmind.ui.stack.right");
                    }
                }
            });
        }

        public void revealWord(int start, int length) {
            ITextViewer viewer;
            Object obj;
            this.reveal();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            MPart part = E4Utils.findPart(window, "org.xmind.ui.modelPart.notes");
            if (part != null && (obj = part.getObject()) instanceof IAdaptable && (viewer = (ITextViewer)((IAdaptable)obj).getAdapter(ITextViewer.class)) != null) {
                viewer.setSelectedRange(start, length);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof NotesWordContext && this.topic != null && this.topic.equals(((NotesWordContext)obj).topic);
        }

        public int hashCode() {
            int result = 17;
            result += result * this.topic.hashCode();
            result += result * TYPE.hashCode();
            return result;
        }
    }

    private class RelationshipWordContext
    implements IWordContext {
        private IRelationship relationship;

        public RelationshipWordContext(IRelationship relationship) {
            this.relationship = relationship;
        }

        public String getContent() {
            return this.relationship.getTitleText();
        }

        public ImageDescriptor getIcon() {
            return MindMapUI.getImages().getElementIcon(this.relationship, true);
        }

        public String getName() {
            return this.relationship.getTitleText();
        }

        public boolean replaceWord(int start, int length, String replacement) {
            return MindMapWordContextProvider.this.replaceText((ISheetComponent)this.relationship, MindMapWordContextProvider.replaceString(this.relationship.getTitleText(), start, length, replacement));
        }

        public void reveal() {
            MindMapWordContextProvider.this.revealElement(this.relationship, false);
        }

        public void revealWord(int start, int length) {
            MindMapWordContextProvider.this.revealInvalidWord((ISheetComponent)this.relationship, start, length, "edit");
        }

        public boolean equals(Object obj) {
            return obj instanceof RelationshipWordContext && this.relationship != null && this.relationship.equals(((RelationshipWordContext)obj).relationship);
        }

        public int hashCode() {
            return 17 * this.relationship.hashCode();
        }
    }

    private class TopicWordContext
    implements IWordContext {
        private ITopic topic;
        private static final String TYPE = "topic";

        public TopicWordContext(ITopic topic) {
            this.topic = topic;
        }

        public String getContent() {
            return this.topic.getTitleText();
        }

        public ImageDescriptor getIcon() {
            return MindMapUI.getImages().getTopicIcon(this.topic, true);
        }

        public String getName() {
            return this.topic.getTitleText();
        }

        public boolean replaceWord(int start, int length, String replacement) {
            return MindMapWordContextProvider.this.replaceText((ISheetComponent)this.topic, MindMapWordContextProvider.replaceString(this.topic.getTitleText(), start, length, replacement));
        }

        public void reveal() {
            MindMapWordContextProvider.this.revealElement(this.topic, false);
        }

        public void revealWord(int start, int length) {
            MindMapWordContextProvider.this.revealInvalidWord((ISheetComponent)this.topic, start, length, "edit");
        }

        public boolean equals(Object obj) {
            return obj instanceof TopicWordContext && this.topic != null && this.topic.equals(((TopicWordContext)obj).topic);
        }

        public int hashCode() {
            int result = 17;
            result += result * this.topic.hashCode();
            result += result * TYPE.hashCode();
            return result;
        }
    }
}

