#ifndef MACRO_H
#define MACRO_H

#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#ifdef HAVE_NCURSES_NCURSES_H
#include <ncurses/ncurses.h>
#else
#include <stdarg.h> /* required by some curses.h implementations */
#include <curses.h>
#endif
#endif

#include "buffer.h"

struct MacroChar
{
  /* If key is KEY_MAX, then ch contains an UTF-8 sequence.
   * If key is not a function key, then ch contains the character
   * for convenience, too.
   */
  chtype key;
  struct MetaChar ch; 
};

struct Macro
{
  struct MacroChar *mac;
  size_t len;
};

#define FUNCTION_KEY(ch) ((ch)&~0xff)

int mc_start(struct Macro *m, int times);
void mc_get(struct MacroChar *mch, int utf8term);
int mc_defstart(void);
int mc_defend(struct Macro *m, int delete);
void mc_null(struct Macro *m);

#endif
