package overlay

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/dom"
	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// SourceOrderConfig configuration data for drawing the source order of an
// elements children.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-SourceOrderConfig
type SourceOrderConfig struct {
	ParentOutlineColor *cdp.RGBA `json:"parentOutlineColor"` // the color to outline the givent element in.
	ChildOutlineColor  *cdp.RGBA `json:"childOutlineColor"`  // the color to outline the child elements in.
}

// GridHighlightConfig configuration data for the highlighting of Grid
// elements.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-GridHighlightConfig
type GridHighlightConfig struct {
	ShowGridExtensionLines  bool      `json:"showGridExtensionLines,omitempty"`  // Whether the extension lines from grid cells to the rulers should be shown (default: false).
	ShowPositiveLineNumbers bool      `json:"showPositiveLineNumbers,omitempty"` // Show Positive line number labels (default: false).
	ShowNegativeLineNumbers bool      `json:"showNegativeLineNumbers,omitempty"` // Show Negative line number labels (default: false).
	ShowAreaNames           bool      `json:"showAreaNames,omitempty"`           // Show area name labels (default: false).
	ShowLineNames           bool      `json:"showLineNames,omitempty"`           // Show line name labels (default: false).
	ShowTrackSizes          bool      `json:"showTrackSizes,omitempty"`          // Show track size labels (default: false).
	GridBorderColor         *cdp.RGBA `json:"gridBorderColor,omitempty"`         // The grid container border highlight color (default: transparent).
	RowLineColor            *cdp.RGBA `json:"rowLineColor,omitempty"`            // The row line color (default: transparent).
	ColumnLineColor         *cdp.RGBA `json:"columnLineColor,omitempty"`         // The column line color (default: transparent).
	GridBorderDash          bool      `json:"gridBorderDash,omitempty"`          // Whether the grid border is dashed (default: false).
	RowLineDash             bool      `json:"rowLineDash,omitempty"`             // Whether row lines are dashed (default: false).
	ColumnLineDash          bool      `json:"columnLineDash,omitempty"`          // Whether column lines are dashed (default: false).
	RowGapColor             *cdp.RGBA `json:"rowGapColor,omitempty"`             // The row gap highlight fill color (default: transparent).
	RowHatchColor           *cdp.RGBA `json:"rowHatchColor,omitempty"`           // The row gap hatching fill color (default: transparent).
	ColumnGapColor          *cdp.RGBA `json:"columnGapColor,omitempty"`          // The column gap highlight fill color (default: transparent).
	ColumnHatchColor        *cdp.RGBA `json:"columnHatchColor,omitempty"`        // The column gap hatching fill color (default: transparent).
	AreaBorderColor         *cdp.RGBA `json:"areaBorderColor,omitempty"`         // The named grid areas border color (Default: transparent).
	GridBackgroundColor     *cdp.RGBA `json:"gridBackgroundColor,omitempty"`     // The grid container background color (Default: transparent).
}

// FlexContainerHighlightConfig configuration data for the highlighting of
// Flex container elements.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-FlexContainerHighlightConfig
type FlexContainerHighlightConfig struct {
	ContainerBorder       *LineStyle `json:"containerBorder,omitempty"`       // The style of the container border
	LineSeparator         *LineStyle `json:"lineSeparator,omitempty"`         // The style of the separator between lines
	ItemSeparator         *LineStyle `json:"itemSeparator,omitempty"`         // The style of the separator between items
	MainDistributedSpace  *BoxStyle  `json:"mainDistributedSpace,omitempty"`  // Style of content-distribution space on the main axis (justify-content).
	CrossDistributedSpace *BoxStyle  `json:"crossDistributedSpace,omitempty"` // Style of content-distribution space on the cross axis (align-content).
	RowGapSpace           *BoxStyle  `json:"rowGapSpace,omitempty"`           // Style of empty space caused by row gaps (gap/row-gap).
	ColumnGapSpace        *BoxStyle  `json:"columnGapSpace,omitempty"`        // Style of empty space caused by columns gaps (gap/column-gap).
	CrossAlignment        *LineStyle `json:"crossAlignment,omitempty"`        // Style of the self-alignment line (align-items).
}

// FlexItemHighlightConfig configuration data for the highlighting of Flex
// item elements.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-FlexItemHighlightConfig
type FlexItemHighlightConfig struct {
	BaseSizeBox      *BoxStyle  `json:"baseSizeBox,omitempty"`      // Style of the box representing the item's base size
	BaseSizeBorder   *LineStyle `json:"baseSizeBorder,omitempty"`   // Style of the border around the box representing the item's base size
	FlexibilityArrow *LineStyle `json:"flexibilityArrow,omitempty"` // Style of the arrow representing if the item grew or shrank
}

// LineStyle style information for drawing a line.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-LineStyle
type LineStyle struct {
	Color   *cdp.RGBA        `json:"color,omitempty"`   // The color of the line (default: transparent)
	Pattern LineStylePattern `json:"pattern,omitempty"` // The line pattern (default: solid)
}

// BoxStyle style information for drawing a box.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-BoxStyle
type BoxStyle struct {
	FillColor  *cdp.RGBA `json:"fillColor,omitempty"`  // The background color for the box (default: transparent)
	HatchColor *cdp.RGBA `json:"hatchColor,omitempty"` // The hatching color for the box (default: transparent)
}

// ContrastAlgorithm [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-ContrastAlgorithm
type ContrastAlgorithm string

// String returns the ContrastAlgorithm as string value.
func (t ContrastAlgorithm) String() string {
	return string(t)
}

// ContrastAlgorithm values.
const (
	ContrastAlgorithmAa   ContrastAlgorithm = "aa"
	ContrastAlgorithmAaa  ContrastAlgorithm = "aaa"
	ContrastAlgorithmApca ContrastAlgorithm = "apca"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ContrastAlgorithm) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ContrastAlgorithm) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ContrastAlgorithm) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ContrastAlgorithm(v) {
	case ContrastAlgorithmAa:
		*t = ContrastAlgorithmAa
	case ContrastAlgorithmAaa:
		*t = ContrastAlgorithmAaa
	case ContrastAlgorithmApca:
		*t = ContrastAlgorithmApca

	default:
		in.AddError(fmt.Errorf("unknown ContrastAlgorithm value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ContrastAlgorithm) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// HighlightConfig configuration data for the highlighting of page elements.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-HighlightConfig
type HighlightConfig struct {
	ShowInfo                               bool                                    `json:"showInfo,omitempty"`                               // Whether the node info tooltip should be shown (default: false).
	ShowStyles                             bool                                    `json:"showStyles,omitempty"`                             // Whether the node styles in the tooltip (default: false).
	ShowRulers                             bool                                    `json:"showRulers,omitempty"`                             // Whether the rulers should be shown (default: false).
	ShowAccessibilityInfo                  bool                                    `json:"showAccessibilityInfo,omitempty"`                  // Whether the a11y info should be shown (default: true).
	ShowExtensionLines                     bool                                    `json:"showExtensionLines,omitempty"`                     // Whether the extension lines from node to the rulers should be shown (default: false).
	ContentColor                           *cdp.RGBA                               `json:"contentColor,omitempty"`                           // The content box highlight fill color (default: transparent).
	PaddingColor                           *cdp.RGBA                               `json:"paddingColor,omitempty"`                           // The padding highlight fill color (default: transparent).
	BorderColor                            *cdp.RGBA                               `json:"borderColor,omitempty"`                            // The border highlight fill color (default: transparent).
	MarginColor                            *cdp.RGBA                               `json:"marginColor,omitempty"`                            // The margin highlight fill color (default: transparent).
	EventTargetColor                       *cdp.RGBA                               `json:"eventTargetColor,omitempty"`                       // The event target element highlight fill color (default: transparent).
	ShapeColor                             *cdp.RGBA                               `json:"shapeColor,omitempty"`                             // The shape outside fill color (default: transparent).
	ShapeMarginColor                       *cdp.RGBA                               `json:"shapeMarginColor,omitempty"`                       // The shape margin fill color (default: transparent).
	CSSGridColor                           *cdp.RGBA                               `json:"cssGridColor,omitempty"`                           // The grid layout color (default: transparent).
	ColorFormat                            ColorFormat                             `json:"colorFormat,omitempty"`                            // The color format used to format color styles (default: hex).
	GridHighlightConfig                    *GridHighlightConfig                    `json:"gridHighlightConfig,omitempty"`                    // The grid layout highlight configuration (default: all transparent).
	FlexContainerHighlightConfig           *FlexContainerHighlightConfig           `json:"flexContainerHighlightConfig,omitempty"`           // The flex container highlight configuration (default: all transparent).
	FlexItemHighlightConfig                *FlexItemHighlightConfig                `json:"flexItemHighlightConfig,omitempty"`                // The flex item highlight configuration (default: all transparent).
	ContrastAlgorithm                      ContrastAlgorithm                       `json:"contrastAlgorithm,omitempty"`                      // The contrast algorithm to use for the contrast ratio (default: aa).
	ContainerQueryContainerHighlightConfig *ContainerQueryContainerHighlightConfig `json:"containerQueryContainerHighlightConfig,omitempty"` // The container query container highlight configuration (default: all transparent).
}

// ColorFormat [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-ColorFormat
type ColorFormat string

// String returns the ColorFormat as string value.
func (t ColorFormat) String() string {
	return string(t)
}

// ColorFormat values.
const (
	ColorFormatRgb ColorFormat = "rgb"
	ColorFormatHsl ColorFormat = "hsl"
	ColorFormatHwb ColorFormat = "hwb"
	ColorFormatHex ColorFormat = "hex"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ColorFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ColorFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ColorFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ColorFormat(v) {
	case ColorFormatRgb:
		*t = ColorFormatRgb
	case ColorFormatHsl:
		*t = ColorFormatHsl
	case ColorFormatHwb:
		*t = ColorFormatHwb
	case ColorFormatHex:
		*t = ColorFormatHex

	default:
		in.AddError(fmt.Errorf("unknown ColorFormat value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ColorFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// GridNodeHighlightConfig configurations for Persistent Grid Highlight.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-GridNodeHighlightConfig
type GridNodeHighlightConfig struct {
	GridHighlightConfig *GridHighlightConfig `json:"gridHighlightConfig"` // A descriptor for the highlight appearance.
	NodeID              cdp.NodeID           `json:"nodeId"`              // Identifier of the node to highlight.
}

// FlexNodeHighlightConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-FlexNodeHighlightConfig
type FlexNodeHighlightConfig struct {
	FlexContainerHighlightConfig *FlexContainerHighlightConfig `json:"flexContainerHighlightConfig"` // A descriptor for the highlight appearance of flex containers.
	NodeID                       cdp.NodeID                    `json:"nodeId"`                       // Identifier of the node to highlight.
}

// ScrollSnapContainerHighlightConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-ScrollSnapContainerHighlightConfig
type ScrollSnapContainerHighlightConfig struct {
	SnapportBorder     *LineStyle `json:"snapportBorder,omitempty"`     // The style of the snapport border (default: transparent)
	SnapAreaBorder     *LineStyle `json:"snapAreaBorder,omitempty"`     // The style of the snap area border (default: transparent)
	ScrollMarginColor  *cdp.RGBA  `json:"scrollMarginColor,omitempty"`  // The margin highlight fill color (default: transparent).
	ScrollPaddingColor *cdp.RGBA  `json:"scrollPaddingColor,omitempty"` // The padding highlight fill color (default: transparent).
}

// ScrollSnapHighlightConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-ScrollSnapHighlightConfig
type ScrollSnapHighlightConfig struct {
	ScrollSnapContainerHighlightConfig *ScrollSnapContainerHighlightConfig `json:"scrollSnapContainerHighlightConfig"` // A descriptor for the highlight appearance of scroll snap containers.
	NodeID                             cdp.NodeID                          `json:"nodeId"`                             // Identifier of the node to highlight.
}

// HingeConfig configuration for dual screen hinge.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-HingeConfig
type HingeConfig struct {
	Rect         *dom.Rect `json:"rect"`                   // A rectangle represent hinge
	ContentColor *cdp.RGBA `json:"contentColor,omitempty"` // The content box highlight fill color (default: a dark color).
	OutlineColor *cdp.RGBA `json:"outlineColor,omitempty"` // The content box highlight outline color (default: transparent).
}

// ContainerQueryHighlightConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-ContainerQueryHighlightConfig
type ContainerQueryHighlightConfig struct {
	ContainerQueryContainerHighlightConfig *ContainerQueryContainerHighlightConfig `json:"containerQueryContainerHighlightConfig"` // A descriptor for the highlight appearance of container query containers.
	NodeID                                 cdp.NodeID                              `json:"nodeId"`                                 // Identifier of the container node to highlight.
}

// ContainerQueryContainerHighlightConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-ContainerQueryContainerHighlightConfig
type ContainerQueryContainerHighlightConfig struct {
	ContainerBorder  *LineStyle `json:"containerBorder,omitempty"`  // The style of the container border.
	DescendantBorder *LineStyle `json:"descendantBorder,omitempty"` // The style of the descendants' borders.
}

// IsolatedElementHighlightConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-IsolatedElementHighlightConfig
type IsolatedElementHighlightConfig struct {
	IsolationModeHighlightConfig *IsolationModeHighlightConfig `json:"isolationModeHighlightConfig"` // A descriptor for the highlight appearance of an element in isolation mode.
	NodeID                       cdp.NodeID                    `json:"nodeId"`                       // Identifier of the isolated element to highlight.
}

// IsolationModeHighlightConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-IsolationModeHighlightConfig
type IsolationModeHighlightConfig struct {
	ResizerColor       *cdp.RGBA `json:"resizerColor,omitempty"`       // The fill color of the resizers (default: transparent).
	ResizerHandleColor *cdp.RGBA `json:"resizerHandleColor,omitempty"` // The fill color for resizer handles (default: transparent).
	MaskColor          *cdp.RGBA `json:"maskColor,omitempty"`          // The fill color for the mask covering non-isolated elements (default: transparent).
}

// InspectMode [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-InspectMode
type InspectMode string

// String returns the InspectMode as string value.
func (t InspectMode) String() string {
	return string(t)
}

// InspectMode values.
const (
	InspectModeSearchForNode         InspectMode = "searchForNode"
	InspectModeSearchForUAShadowDOM  InspectMode = "searchForUAShadowDOM"
	InspectModeCaptureAreaScreenshot InspectMode = "captureAreaScreenshot"
	InspectModeShowDistances         InspectMode = "showDistances"
	InspectModeNone                  InspectMode = "none"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t InspectMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t InspectMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *InspectMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch InspectMode(v) {
	case InspectModeSearchForNode:
		*t = InspectModeSearchForNode
	case InspectModeSearchForUAShadowDOM:
		*t = InspectModeSearchForUAShadowDOM
	case InspectModeCaptureAreaScreenshot:
		*t = InspectModeCaptureAreaScreenshot
	case InspectModeShowDistances:
		*t = InspectModeShowDistances
	case InspectModeNone:
		*t = InspectModeNone

	default:
		in.AddError(fmt.Errorf("unknown InspectMode value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *InspectMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// LineStylePattern the line pattern (default: solid).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#type-LineStyle
type LineStylePattern string

// String returns the LineStylePattern as string value.
func (t LineStylePattern) String() string {
	return string(t)
}

// LineStylePattern values.
const (
	LineStylePatternDashed LineStylePattern = "dashed"
	LineStylePatternDotted LineStylePattern = "dotted"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t LineStylePattern) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t LineStylePattern) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *LineStylePattern) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch LineStylePattern(v) {
	case LineStylePatternDashed:
		*t = LineStylePatternDashed
	case LineStylePatternDotted:
		*t = LineStylePatternDotted

	default:
		in.AddError(fmt.Errorf("unknown LineStylePattern value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *LineStylePattern) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
