// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#include "google/cloud/vmwareengine/v1/vmware_engine_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace vmwareengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VmwareEngineClient::VmwareEngineClient(
    std::shared_ptr<VmwareEngineConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
VmwareEngineClient::~VmwareEngineClient() = default;

StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::ListPrivateClouds(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request;
  request.set_parent(parent);
  return connection_->ListPrivateClouds(request);
}

StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::ListPrivateClouds(
    google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPrivateClouds(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::GetPrivateCloud(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetPrivateCloudRequest request;
  request.set_name(name);
  return connection_->GetPrivateCloud(request);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::GetPrivateCloud(
    google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::CreatePrivateCloud(
    std::string const& parent,
    google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
    std::string const& private_cloud_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreatePrivateCloudRequest request;
  request.set_parent(parent);
  *request.mutable_private_cloud() = private_cloud;
  request.set_private_cloud_id(private_cloud_id);
  return connection_->CreatePrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::CreatePrivateCloud(
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UpdatePrivateCloud(
    google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest request;
  *request.mutable_private_cloud() = private_cloud;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UpdatePrivateCloud(
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::DeletePrivateCloud(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeletePrivateCloudRequest request;
  request.set_name(name);
  return connection_->DeletePrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::DeletePrivateCloud(
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UndeletePrivateCloud(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest request;
  request.set_name(name);
  return connection_->UndeletePrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UndeletePrivateCloud(
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeletePrivateCloud(request);
}

StreamRange<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::ListClusters(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListClustersRequest request;
  request.set_parent(parent);
  return connection_->ListClusters(request);
}

StreamRange<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::ListClusters(
    google::cloud::vmwareengine::v1::ListClustersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListClusters(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::GetCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetClusterRequest request;
  request.set_name(name);
  return connection_->GetCluster(request);
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::GetCluster(
    google::cloud::vmwareengine::v1::GetClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCluster(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::CreateCluster(
    std::string const& parent,
    google::cloud::vmwareengine::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::CreateCluster(
    google::cloud::vmwareengine::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::UpdateCluster(
    google::cloud::vmwareengine::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::UpdateCluster(
    google::cloud::vmwareengine::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteCluster(
    google::cloud::vmwareengine::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(request);
}

StreamRange<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineClient::ListSubnets(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListSubnetsRequest request;
  request.set_parent(parent);
  return connection_->ListSubnets(request);
}

StreamRange<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineClient::ListSubnets(
    google::cloud::vmwareengine::v1::ListSubnetsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSubnets(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::Subnet> VmwareEngineClient::GetSubnet(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetSubnetRequest request;
  request.set_name(name);
  return connection_->GetSubnet(request);
}

StatusOr<google::cloud::vmwareengine::v1::Subnet> VmwareEngineClient::GetSubnet(
    google::cloud::vmwareengine::v1::GetSubnetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSubnet(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>
VmwareEngineClient::UpdateSubnet(
    google::cloud::vmwareengine::v1::Subnet const& subnet,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateSubnetRequest request;
  *request.mutable_subnet() = subnet;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSubnet(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>
VmwareEngineClient::UpdateSubnet(
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSubnet(request);
}

StreamRange<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::ListNodeTypes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListNodeTypesRequest request;
  request.set_parent(parent);
  return connection_->ListNodeTypes(request);
}

StreamRange<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::ListNodeTypes(
    google::cloud::vmwareengine::v1::ListNodeTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNodeTypes(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::GetNodeType(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetNodeTypeRequest request;
  request.set_name(name);
  return connection_->GetNodeType(request);
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::GetNodeType(
    google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNodeType(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowNsxCredentials(std::string const& private_cloud,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ShowNsxCredentials(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowNsxCredentials(
    google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ShowNsxCredentials(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowVcenterCredentials(std::string const& private_cloud,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ShowVcenterCredentials(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowVcenterCredentials(
    google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ShowVcenterCredentials(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetNsxCredentials(std::string const& private_cloud,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ResetNsxCredentials(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetNsxCredentials(
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetNsxCredentials(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetVcenterCredentials(std::string const& private_cloud,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ResetVcenterCredentials(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetVcenterCredentials(
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetVcenterCredentials(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
VmwareEngineClient::CreateHcxActivationKey(
    std::string const& parent,
    google::cloud::vmwareengine::v1::HcxActivationKey const& hcx_activation_key,
    std::string const& hcx_activation_key_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest request;
  request.set_parent(parent);
  *request.mutable_hcx_activation_key() = hcx_activation_key;
  request.set_hcx_activation_key_id(hcx_activation_key_id);
  return connection_->CreateHcxActivationKey(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
VmwareEngineClient::CreateHcxActivationKey(
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateHcxActivationKey(request);
}

StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::ListHcxActivationKeys(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request;
  request.set_parent(parent);
  return connection_->ListHcxActivationKeys(request);
}

StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::ListHcxActivationKeys(
    google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListHcxActivationKeys(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::GetHcxActivationKey(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest request;
  request.set_name(name);
  return connection_->GetHcxActivationKey(request);
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::GetHcxActivationKey(
    google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHcxActivationKey(request);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::GetNetworkPolicy(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetNetworkPolicyRequest request;
  request.set_name(name);
  return connection_->GetNetworkPolicy(request);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::GetNetworkPolicy(
    google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetworkPolicy(request);
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::ListNetworkPolicies(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request;
  request.set_parent(parent);
  return connection_->ListNetworkPolicies(request);
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::ListNetworkPolicies(
    google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworkPolicies(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::CreateNetworkPolicy(
    std::string const& parent,
    google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
    std::string const& network_policy_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest request;
  request.set_parent(parent);
  *request.mutable_network_policy() = network_policy;
  request.set_network_policy_id(network_policy_id);
  return connection_->CreateNetworkPolicy(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::CreateNetworkPolicy(
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNetworkPolicy(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::UpdateNetworkPolicy(
    google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest request;
  *request.mutable_network_policy() = network_policy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNetworkPolicy(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::UpdateNetworkPolicy(
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkPolicy(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPolicy(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteNetworkPolicy(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPolicy(
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkPolicy(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::CreateVmwareEngineNetwork(
    std::string const& parent,
    google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
        vmware_engine_network,
    std::string const& vmware_engine_network_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest request;
  request.set_parent(parent);
  *request.mutable_vmware_engine_network() = vmware_engine_network;
  request.set_vmware_engine_network_id(vmware_engine_network_id);
  return connection_->CreateVmwareEngineNetwork(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::CreateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVmwareEngineNetwork(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::UpdateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
        vmware_engine_network,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest request;
  *request.mutable_vmware_engine_network() = vmware_engine_network;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateVmwareEngineNetwork(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::UpdateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVmwareEngineNetwork(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteVmwareEngineNetwork(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest request;
  request.set_name(name);
  return connection_->DeleteVmwareEngineNetwork(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVmwareEngineNetwork(request);
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::GetVmwareEngineNetwork(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest request;
  request.set_name(name);
  return connection_->GetVmwareEngineNetwork(request);
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::GetVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVmwareEngineNetwork(request);
}

StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::ListVmwareEngineNetworks(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request;
  request.set_parent(parent);
  return connection_->ListVmwareEngineNetworks(request);
}

StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::ListVmwareEngineNetworks(
    google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVmwareEngineNetworks(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::CreatePrivateConnection(
    std::string const& parent,
    google::cloud::vmwareengine::v1::PrivateConnection const&
        private_connection,
    std::string const& private_connection_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest request;
  request.set_parent(parent);
  *request.mutable_private_connection() = private_connection;
  request.set_private_connection_id(private_connection_id);
  return connection_->CreatePrivateConnection(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::CreatePrivateConnection(
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateConnection(request);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::GetPrivateConnection(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetPrivateConnectionRequest request;
  request.set_name(name);
  return connection_->GetPrivateConnection(request);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::GetPrivateConnection(
    google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPrivateConnection(request);
}

StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::ListPrivateConnections(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request;
  request.set_parent(parent);
  return connection_->ListPrivateConnections(request);
}

StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::ListPrivateConnections(
    google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPrivateConnections(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::UpdatePrivateConnection(
    google::cloud::vmwareengine::v1::PrivateConnection const&
        private_connection,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest request;
  *request.mutable_private_connection() = private_connection;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePrivateConnection(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::UpdatePrivateConnection(
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateConnection(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeletePrivateConnection(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest request;
  request.set_name(name);
  return connection_->DeletePrivateConnection(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeletePrivateConnection(
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateConnection(request);
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineClient::ListPrivateConnectionPeeringRoutes(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
      request;
  request.set_parent(parent);
  return connection_->ListPrivateConnectionPeeringRoutes(request);
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineClient::ListPrivateConnectionPeeringRoutes(
    google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPrivateConnectionPeeringRoutes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1
}  // namespace cloud
}  // namespace google
