// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/timeseriesinsights/v1/timeseries_insights.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TIMESERIESINSIGHTS_V1_TIMESERIES_INSIGHTS_CONTROLLER_OPTIONS_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TIMESERIESINSIGHTS_V1_TIMESERIES_INSIGHTS_CONTROLLER_OPTIONS_H

#include "google/cloud/timeseriesinsights/v1/timeseries_insights_controller_connection.h"
#include "google/cloud/timeseriesinsights/v1/timeseries_insights_controller_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace timeseriesinsights_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * Use with `google::cloud::Options` to configure the retry policy.
 *
 * @ingroup google-cloud-timeseriesinsights-options
 */
struct TimeseriesInsightsControllerRetryPolicyOption {
  using Type = std::shared_ptr<TimeseriesInsightsControllerRetryPolicy>;
};

/**
 * Use with `google::cloud::Options` to configure the backoff policy.
 *
 * @ingroup google-cloud-timeseriesinsights-options
 */
struct TimeseriesInsightsControllerBackoffPolicyOption {
  using Type = std::shared_ptr<BackoffPolicy>;
};

/**
 * Use with `google::cloud::Options` to configure which operations are retried.
 *
 * @ingroup google-cloud-timeseriesinsights-options
 */
struct TimeseriesInsightsControllerConnectionIdempotencyPolicyOption {
  using Type =
      std::shared_ptr<TimeseriesInsightsControllerConnectionIdempotencyPolicy>;
};

/**
 * The options applicable to TimeseriesInsightsController.
 *
 * @ingroup google-cloud-timeseriesinsights-options
 */
using TimeseriesInsightsControllerPolicyOptionList =
    OptionList<TimeseriesInsightsControllerRetryPolicyOption,
               TimeseriesInsightsControllerBackoffPolicyOption,
               TimeseriesInsightsControllerConnectionIdempotencyPolicyOption>;

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace timeseriesinsights_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TIMESERIESINSIGHTS_V1_TIMESERIES_INSIGHTS_CONTROLLER_OPTIONS_H
