// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/internal/adaptation_connection_impl.h"
#include "google/cloud/speech/v1/internal/adaptation_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace speech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<speech_v1::AdaptationRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<speech_v1::AdaptationRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<speech_v1::AdaptationBackoffPolicyOption>()->clone();
}

std::unique_ptr<speech_v1::AdaptationConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<speech_v1::AdaptationConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

AdaptationConnectionImpl::AdaptationConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<speech_v1_internal::AdaptationStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      AdaptationConnection::options())) {}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationConnectionImpl::CreatePhraseSet(
    google::cloud::speech::v1::CreatePhraseSetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePhraseSet(request),
      [this](grpc::ClientContext& context,
             google::cloud::speech::v1::CreatePhraseSetRequest const& request) {
        return stub_->CreatePhraseSet(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationConnectionImpl::GetPhraseSet(
    google::cloud::speech::v1::GetPhraseSetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPhraseSet(request),
      [this](grpc::ClientContext& context,
             google::cloud::speech::v1::GetPhraseSetRequest const& request) {
        return stub_->GetPhraseSet(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::speech::v1::PhraseSet>
AdaptationConnectionImpl::ListPhraseSet(
    google::cloud::speech::v1::ListPhraseSetRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPhraseSet(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::speech::v1::PhraseSet>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<speech_v1::AdaptationRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::speech::v1::ListPhraseSetRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::speech::v1::ListPhraseSetRequest const&
                       request) {
              return stub->ListPhraseSet(context, request);
            },
            r, function_name);
      },
      [](google::cloud::speech::v1::ListPhraseSetResponse r) {
        std::vector<google::cloud::speech::v1::PhraseSet> result(
            r.phrase_sets().size());
        auto& messages = *r.mutable_phrase_sets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationConnectionImpl::UpdatePhraseSet(
    google::cloud::speech::v1::UpdatePhraseSetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePhraseSet(request),
      [this](grpc::ClientContext& context,
             google::cloud::speech::v1::UpdatePhraseSetRequest const& request) {
        return stub_->UpdatePhraseSet(context, request);
      },
      request, __func__);
}

Status AdaptationConnectionImpl::DeletePhraseSet(
    google::cloud::speech::v1::DeletePhraseSetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePhraseSet(request),
      [this](grpc::ClientContext& context,
             google::cloud::speech::v1::DeletePhraseSetRequest const& request) {
        return stub_->DeletePhraseSet(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationConnectionImpl::CreateCustomClass(
    google::cloud::speech::v1::CreateCustomClassRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCustomClass(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::speech::v1::CreateCustomClassRequest const& request) {
        return stub_->CreateCustomClass(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationConnectionImpl::GetCustomClass(
    google::cloud::speech::v1::GetCustomClassRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCustomClass(request),
      [this](grpc::ClientContext& context,
             google::cloud::speech::v1::GetCustomClassRequest const& request) {
        return stub_->GetCustomClass(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::speech::v1::CustomClass>
AdaptationConnectionImpl::ListCustomClasses(
    google::cloud::speech::v1::ListCustomClassesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCustomClasses(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::speech::v1::CustomClass>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<speech_v1::AdaptationRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::speech::v1::ListCustomClassesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::speech::v1::ListCustomClassesRequest const&
                       request) {
              return stub->ListCustomClasses(context, request);
            },
            r, function_name);
      },
      [](google::cloud::speech::v1::ListCustomClassesResponse r) {
        std::vector<google::cloud::speech::v1::CustomClass> result(
            r.custom_classes().size());
        auto& messages = *r.mutable_custom_classes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationConnectionImpl::UpdateCustomClass(
    google::cloud::speech::v1::UpdateCustomClassRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCustomClass(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::speech::v1::UpdateCustomClassRequest const& request) {
        return stub_->UpdateCustomClass(context, request);
      },
      request, __func__);
}

Status AdaptationConnectionImpl::DeleteCustomClass(
    google::cloud::speech::v1::DeleteCustomClassRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCustomClass(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::speech::v1::DeleteCustomClassRequest const& request) {
        return stub_->DeleteCustomClass(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_internal
}  // namespace cloud
}  // namespace google
